/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemPersistence;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector = new KeyedExtensionCollector<VirtualFileSystem, String>("com.intellij.virtualFileSystem"){

        @Override
        protected String keyToString(String key) {
            return key;
        }
    };
    private final List<VirtualFileSystem> myPhysicalFileSystems = new ArrayList<VirtualFileSystem>();
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners = ContainerUtil.createEmptyCOWList();
    private int myRefreshCount = 0;
    private final FileSystemPersistence myPersistence;

    public VirtualFileManagerImpl(VirtualFileSystem[] fileSystems, MessageBus bus, FileSystemPersistence persistence) {
        this.myPersistence = persistence;
        for (VirtualFileSystem fileSystem : fileSystems) {
            this.registerFileSystem(fileSystem);
        }
        if (LOG.isDebugEnabled()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    public void registerFileSystem(VirtualFileSystem fileSystem) {
        this.myCollector.addExplicitExtension(fileSystem.getProtocol(), fileSystem);
        if (!(fileSystem instanceof CachingVirtualFileSystem)) {
            fileSystem.addVirtualFileListener(this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        this.myPhysicalFileSystems.add(fileSystem);
    }

    public void unregisterFileSystem(VirtualFileSystem fileSystem) {
        this.myCollector.removeExplicitExtension(fileSystem.getProtocol(), fileSystem);
        fileSystem.removeVirtualFileListener(this.myVirtualFileListenerMulticaster.getMulticaster());
        this.myPhysicalFileSystems.remove(fileSystem);
    }

    @Override
    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List<VirtualFileSystem> systems = this.myCollector.forKey(protocol);
        if (systems.isEmpty()) {
            return null;
        }
        LOG.assertTrue(systems.size() == 1);
        return systems.get(0);
    }

    @Override
    public void refresh(boolean asynchronous) {
        this.refresh(asynchronous, null);
    }

    @Override
    public void refreshWithoutFileWatcher(boolean asynchronous) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) {
                ((CachingVirtualFileSystem)((Object)fileSystem)).refreshWithoutFileWatcher(asynchronous);
                continue;
            }
            fileSystem.refresh(asynchronous);
        }
    }

    @Override
    public void refresh(boolean asynchronous, @Nullable Runnable postAction) {
        this.refresh(asynchronous, postAction, ModalityState.NON_MODAL);
    }

    public void refresh(boolean asynchronous, @Nullable Runnable postAction, ModalityState modalityState) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.myPersistence.refresh(asynchronous, postAction, modalityState);
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.refresh(asynchronous);
        }
    }

    private List<VirtualFileSystem> getPhysicalFileSystems() {
        return this.myPhysicalFileSystems;
    }

    @Override
    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.findFileByUrl must not be null");
        }
        VirtualFileSystem fileSystem = this.getFileSystemForUrl(url);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.findFileByPath(VirtualFileManagerImpl.extractPath(url));
    }

    @Override
    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.refreshAndFindFileByUrl must not be null");
        }
        VirtualFileSystem fileSystem = this.getFileSystemForUrl(url);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.refreshAndFindFileByPath(VirtualFileManagerImpl.extractPath(url));
    }

    @Nullable
    private VirtualFileSystem getFileSystemForUrl(String url) {
        String protocol = VirtualFileManagerImpl.extractProtocol(url);
        if (protocol == null) {
            return null;
        }
        return this.getFileSystem(protocol);
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileListener must not be null");
        }
        this.myVirtualFileListenerMulticaster.addListener(listener);
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileListener must not be null");
        }
        this.myVirtualFileListenerMulticaster.addListener(listener, parentDisposable);
    }

    @Override
    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.removeVirtualFileListener must not be null");
        }
        this.myVirtualFileListenerMulticaster.removeListener(listener);
    }

    @Override
    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileManagerListener must not be null");
        }
        this.myVirtualFileManagerListeners.add(listener);
    }

    @Override
    public void addVirtualFileManagerListener(final @NotNull VirtualFileManagerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileManagerListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.addVirtualFileManagerListener must not be null");
        }
        this.addVirtualFileManagerListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                VirtualFileManagerImpl.this.removeVirtualFileManagerListener(listener);
            }
        });
    }

    @Override
    public void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFileManagerImpl.removeVirtualFileManagerListener must not be null");
        }
        this.myVirtualFileManagerListeners.remove(listener);
    }

    @Override
    public void notifyPropertyChanged(final VirtualFile virtualFile, final String property, final Object oldValue, final Object newValue) {
        final Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (virtualFile.isValid() && !application.isDisposed()) {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent(this, virtualFile, property, oldValue, newValue, false));
                            BulkFileListener listener = application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                            listener.before(events);
                            listener.after(events);
                        }
                    });
                }
            }
        };
        application.invokeLater(runnable, ModalityState.NON_MODAL);
    }

    @Override
    public void fireBeforeRefreshStart(boolean asynchronous) {
        if (this.myRefreshCount++ == 0) {
            for (VirtualFileManagerListener listener : this.myVirtualFileManagerListeners) {
                try {
                    listener.beforeRefreshStart(asynchronous);
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public void fireAfterRefreshFinish(boolean asynchronous) {
        if (--this.myRefreshCount == 0) {
            for (VirtualFileManagerListener listener : this.myVirtualFileManagerListeners) {
                try {
                    listener.afterRefreshFinish(asynchronous);
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public long getModificationCount() {
        return this.myPersistence.getCheapFileSystemModificationCount();
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        @Override
        public void propertyChanged(VirtualFilePropertyEvent event) {
            LOG.debug("propertyChanged: file = " + event.getFile().getUrl() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void contentsChanged(VirtualFileEvent event) {
            LOG.debug("contentsChanged: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileCreated(VirtualFileEvent event) {
            LOG.debug("fileCreated: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileDeleted(VirtualFileEvent event) {
            VirtualFile parent = event.getParent();
            LOG.debug("fileDeleted: file = " + event.getFile().getName() + ", parent = " + (parent != null ? parent.getUrl() : null) + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileMoved(VirtualFileMoveEvent event) {
            LOG.debug("fileMoved: file = " + event.getFile().getUrl() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void fileCopied(VirtualFileCopyEvent event) {
            LOG.debug("fileCopied: file = " + event.getFile().getUrl() + "originalFile = " + event.getOriginalFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforeContentsChange(VirtualFileEvent event) {
            LOG.debug("beforeContentsChange: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforePropertyChange(VirtualFilePropertyEvent event) {
            LOG.debug("beforePropertyChange: file = " + event.getFile().getUrl() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        @Override
        public void beforeFileDeletion(VirtualFileEvent event) {
            LOG.debug("beforeFileDeletion: file = " + event.getFile().getUrl() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        @Override
        public void beforeFileMovement(VirtualFileMoveEvent event) {
            LOG.debug("beforeFileMovement: file = " + event.getFile().getUrl() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }
    }
}

