/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFile
extends UserDataHolderBase
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.VirtualFile");
    public static final Key<Object> REQUESTOR_MARKER = Key.create("REQUESTOR_MARKER");
    private static final Key<byte[]> BOM_KEY = Key.create("BOM");
    private static final Key<Charset> CHARSET_KEY = Key.create("CHARSET");
    public static final VirtualFile[] EMPTY_ARRAY = new VirtualFile[0];
    @NonNls
    public static final String PROP_NAME = "name";
    @NonNls
    public static final String PROP_ENCODING = "encoding";
    @NonNls
    public static final String PROP_WRITABLE = "writable";

    protected VirtualFile() {
    }

    @NotNull
    @NonNls
    public abstract String getName();

    @NotNull
    public abstract VirtualFileSystem getFileSystem();

    public abstract String getPath();

    @NotNull
    public String getUrl() {
        String string = VirtualFileManager.constructUrl(this.getFileSystem().getProtocol(), this.getPath());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.getUrl must not return null");
        }
        return string;
    }

    public final String getPresentableUrl() {
        return this.getFileSystem().extractPresentableUrl(this.getPath());
    }

    @Nullable
    @NonNls
    public String getExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNls
    @NotNull
    public String getNameWithoutExtension() {
        String string;
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            string = name;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.getNameWithoutExtension must not return null");
            return string;
        }
        string = name.substring(0, index);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.getNameWithoutExtension must not return null");
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.rename must not be null");
        }
        if (this.getName().equals(newName)) {
            return;
        }
        if (!VirtualFile.isValidName(newName)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", newName));
        }
        this.getFileSystem().renameFile(requestor, this, newName);
    }

    public abstract boolean isWritable();

    public abstract boolean isDirectory();

    public boolean isSymLink() {
        return false;
    }

    @Nullable
    public String resolveSymLink() {
        return null;
    }

    public boolean isSpecialFile() {
        return false;
    }

    @Nullable
    public VirtualFile getRealFile() {
        return this.isSymLink() ? this.getCanonicalFile() : this;
    }

    @Nullable
    public String getCanonicalPath() {
        return this.getPath();
    }

    @Nullable
    public VirtualFile getCanonicalFile() {
        return this;
    }

    public abstract boolean isValid();

    public abstract VirtualFile getParent();

    public abstract VirtualFile[] getChildren();

    @Nullable
    public VirtualFile findChild(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.findChild must not be null");
        }
        VirtualFile[] children = this.getChildren();
        if (children == null) {
            return null;
        }
        for (VirtualFile child : children) {
            if (!child.nameEquals(name)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public VirtualFile findOrCreateChildData(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.findOrCreateChildData must not be null");
        }
        VirtualFile child = this.findChild(name);
        if (child != null) {
            return child;
        }
        return this.createChildData(requestor, name);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(this);
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.getFileType must not return null");
        }
        return fileType;
    }

    @Nullable
    public VirtualFile findFileByRelativePath(@NotNull @NonNls String relPath) {
        String name;
        VirtualFile child;
        if (relPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.findFileByRelativePath must not be null");
        }
        if (relPath.length() == 0) {
            return this;
        }
        int index = (relPath = StringUtil.trimStart(relPath, "/")).indexOf(47);
        if (index < 0) {
            index = relPath.length();
        }
        if ((child = (name = relPath.substring(0, index)).equals(".") ? this : (name.equals("..") ? this.getParent() : this.findChild(name))) == null) {
            return null;
        }
        if (index < relPath.length()) {
            return child.findFileByRelativePath(relPath.substring(index + 1));
        }
        return child;
    }

    public VirtualFile createChildDirectory(Object requestor, @NonNls String name) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("directory.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VirtualFile.isValidName(name)) {
            throw new IOException(VfsBundle.message("directory.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildDirectory(requestor, this, name);
    }

    public VirtualFile createChildData(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.createChildData must not be null");
        }
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("file.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VirtualFile.isValidName(name)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildFile(requestor, this, name);
    }

    public void delete(Object requestor) throws IOException {
        LOG.assertTrue(this.isValid(), "Deleting invalid file");
        this.getFileSystem().deleteFile(requestor, this);
    }

    public void move(final Object requestor, final @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.move must not be null");
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message("file.move.error", newParent.getPresentableUrl()));
        }
        EncodingRegistry.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            @Override
            public VirtualFile compute() throws IOException {
                VirtualFile.this.getFileSystem().moveFile(requestor, VirtualFile.this, newParent);
                return VirtualFile.this;
            }
        });
    }

    public VirtualFile copy(final Object requestor, final @NotNull VirtualFile newParent, final @NotNull String copyName) throws IOException {
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.copy must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.copy must not be null");
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message("file.copy.error", newParent.getPresentableUrl()));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message("file.copy.target.must.be.directory", new Object[0]));
        }
        return EncodingRegistry.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            @Override
            public VirtualFile compute() throws IOException {
                return VirtualFile.this.getFileSystem().copyFile(requestor, VirtualFile.this, newParent, copyName);
            }
        });
    }

    public Charset getCharset() {
        Charset charset = this.getUserData(CHARSET_KEY);
        if (charset == null) {
            charset = EncodingRegistry.getInstance().getDefaultCharset();
            this.setCharset(charset);
        }
        return charset;
    }

    public void setCharset(Charset charset) {
        Charset old = this.getUserData(CHARSET_KEY);
        this.putUserData(CHARSET_KEY, charset);
        if (Comparing.equal(charset, old)) {
            return;
        }
        byte[] bom = charset == null ? null : CharsetToolkit.getBom(charset);
        byte[] existingBOM = this.getBOM();
        if (bom == null && charset != null && CharsetToolkit.canHaveBom(charset, existingBOM)) {
            bom = existingBOM;
        }
        this.setBOM(bom);
        if (old != null) {
            VirtualFileManager.getInstance().notifyPropertyChanged(this, PROP_ENCODING, old, charset);
        }
    }

    public boolean isCharsetSet() {
        return this.getUserData(CHARSET_KEY) != null;
    }

    public final void setBinaryContent(byte[] content) throws IOException {
        this.setBinaryContent(content, -1L, -1L);
    }

    public void setBinaryContent(byte[] content, long newModificationStamp, long newTimeStamp) throws IOException {
        this.setBinaryContent(content, newModificationStamp, newTimeStamp, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryContent(byte[] content, long newModificationStamp, long newTimeStamp, Object requestor) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(requestor, newModificationStamp, newTimeStamp);
            outputStream.write(content);
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public final OutputStream getOutputStream(Object requestor) throws IOException {
        return this.getOutputStream(requestor, -1L, -1L);
    }

    @NotNull
    public abstract OutputStream getOutputStream(Object var1, long var2, long var4) throws IOException;

    @NotNull
    public abstract byte[] contentsToByteArray() throws IOException;

    @NotNull
    public byte[] contentsToByteArray(boolean cacheContent) throws IOException {
        byte[] byArray = this.contentsToByteArray();
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.contentsToByteArray must not return null");
        }
        return byArray;
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException();
    }

    public abstract long getTimeStamp();

    public abstract long getLength();

    public void refresh(boolean asynchronous, boolean recursive) {
        this.refresh(asynchronous, recursive, null);
    }

    public abstract void refresh(boolean var1, boolean var2, @Nullable Runnable var3);

    public String getPresentableName() {
        return this.getName();
    }

    @Override
    public long getModificationCount() {
        return this.isValid() ? this.getTimeStamp() : -1L;
    }

    protected boolean nameEquals(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.nameEquals must not be null");
        }
        return this.getName().equals(name);
    }

    public abstract InputStream getInputStream() throws IOException;

    @Nullable
    public byte[] getBOM() {
        return this.getUserData(BOM_KEY);
    }

    public void setBOM(@Nullable byte[] BOM) {
        this.putUserData(BOM_KEY, BOM);
    }

    @NonNls
    public String toString() {
        return "VirtualFile: " + this.getPresentableUrl();
    }

    public boolean exists() {
        return this.isValid();
    }

    public boolean isInLocalFileSystem() {
        return false;
    }

    public static boolean isValidName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.isValidName must not be null");
        }
        return name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }
}

