/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtilCore {
    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.isAncestor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.isAncestor must not be null");
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.getRelativePath must not be null");
        }
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.getRelativePath must not be null");
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getName().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            String name = parent.getName();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return new String(chars);
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.copyFile must not be null");
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        return newChild;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(@NotNull byte[] buf, @NotNull VirtualFile file) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.byteStreamSkippingBOM must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.byteStreamSkippingBOM must not be null");
        }
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM(stream, file);
        if (inputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.byteStreamSkippingBOM must not return null");
        }
        return inputStream;
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.inputStreamSkippingBOM must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.inputStreamSkippingBOM must not be null");
        }
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM(stream);
        if (inputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.inputStreamSkippingBOM must not return null");
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.outputStreamAddingBOM must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.outputStreamAddingBOM must not be null");
        }
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        OutputStream outputStream = stream;
        if (outputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.outputStreamAddingBOM must not return null");
        }
        return outputStream;
    }

    public static void visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor visitor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not be null");
        }
        VfsUtilCore.visitChildrenRecursively(file, visitor, null);
    }

    private static void visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor visitor, @Nullable Set<VirtualFile> visitedSymlinks) {
        VirtualFile[] children;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.visitChildrenRecursively must not be null");
        }
        if (!visitor.visitFile(file)) {
            return;
        }
        if (file.isSymLink()) {
            if (visitedSymlinks == null) {
                visitedSymlinks = new HashSet<VirtualFile>();
            }
            if (!visitedSymlinks.add(file)) {
                visitor.afterChildrenVisited(file);
                return;
            }
        }
        for (VirtualFile child : children = file.getChildren()) {
            VfsUtilCore.visitChildrenRecursively(child, visitor, visitedSymlinks);
        }
        visitor.afterChildrenVisited(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtilCore.loadText must not be null");
        }
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        String string = new String(FileUtil.loadText(reader, (int)file.getLength()));
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtilCore.loadText must not return null");
        }
        return string2;
        finally {
            reader.close();
        }
    }
}

