/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.util.ArrayUtil;
import gnu.trove.Equality;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final CopyOnWriteArraySet<ObjectTreeListener> myListeners = new CopyOnWriteArraySet();
    private final THashSet<T> myRootObjects = new MyTHashSet();
    private final THashMap<T, ObjectNode<T>> myObject2NodeMap = new THashMap<T, ObjectNode<T>>(TObjectHashingStrategy.IDENTITY){

        public void compact() {
            if ((int)((float)this.capacity() * this._loadFactor) / Math.max(1, this.size()) >= 3) {
                super.compact();
            }
        }
    };
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredNodes = new ArrayList<T>();
    final Object treeLock = new Object();
    private long myModification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.getNode must not be null");
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return (ObjectNode)this.myObject2NodeMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode<T> putNode(@NotNull T object, ObjectNode<T> node) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.putNode must not be null");
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return node == null ? (ObjectNode)this.myObject2NodeMap.remove(object) : (ObjectNode)this.myObject2NodeMap.put(object, node);
        }
    }

    public final List<ObjectNode<T>> getNodesInExecution() {
        return this.myExecutedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(T parent, T child) {
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> childNode = this.getOrCreateNodeFor(child);
            this.checkValid(childNode, child);
            ObjectNode<T> parentNode = this.getOrCreateNodeFor(parent);
            ObjectNode<T> childParent = childNode.getParent();
            if (childParent != null) {
                childParent.removeChild(childNode);
                parentNode.addChild(childNode);
            } else {
                parentNode.addChild(childNode);
                this.myRootObjects.remove(child);
            }
            this.fireRegistered(childNode.getObject());
        }
    }

    private void checkValid(ObjectNode<T> childNode, T child) {
        boolean childIsInTree;
        boolean bl = childIsInTree = childNode != null && childNode.getParent() != null;
        if (!childIsInTree) {
            return;
        }
        for (ObjectNode<T> eachParent = childNode.getParent(); eachParent != null; eachParent = eachParent.getParent()) {
            if (eachParent.getObject() != child) continue;
            LOG.error(child + " was already added as a child of: " + eachParent);
        }
    }

    private ObjectNode<T> getOrCreateNodeFor(@NotNull T parentObject) {
        if (parentObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.getOrCreateNodeFor must not be null");
        }
        ObjectNode<T> parentNode = this.getNode(parentObject);
        if (parentNode != null) {
            return parentNode;
        }
        ObjectNode<T> parentless = new ObjectNode<T>(this, null, parentObject, this.getNextModification());
        this.myRootObjects.add(parentObject);
        this.putNode(parentObject, parentless);
        return parentless;
    }

    public long getNextModification() {
        return ++this.myModification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean executeAll(@NotNull T object, boolean disposeTree, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeAll must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeAll must not be null");
        }
        try {
            ObjectNode<T> node = this.getNode(object);
            if (node == null) {
                if (processUnregistered) {
                    this.executeUnregistered(object, action);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = node.execute(disposeTree, action);
            return bl;
        }
        finally {
            Object object2 = this.treeLock;
            synchronized (object2) {
                this.myObject2NodeMap.compact();
                this.myRootObjects.compact();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull ObjectTreeAction<T> action, List<T> recursiveGuard) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeActionWithRecursiveGuard must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeActionWithRecursiveGuard must not be null");
        }
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY);
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeUnregistered must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeUnregistered must not be null");
        }
        ObjectTree.executeActionWithRecursiveGuard(object, action, this.myExecutedUnregisteredNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeChildAndReplace(@NotNull T toExecute, @NotNull T toReplace, boolean disposeTree, @NotNull ObjectTreeAction<T> action) {
        T parentObject;
        if (toExecute == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeChildAndReplace must not be null");
        }
        if (toReplace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeChildAndReplace must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.executeChildAndReplace must not be null");
        }
        ObjectNode<T> toExecuteNode = this.getNode(toExecute);
        assert (toExecuteNode != null) : "Object " + toExecute + " wasn't registered or already disposed";
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> parent = toExecuteNode.getParent();
            assert (parent != null) : "Object " + toExecute + " is not connected to the tree - doesn't have parent";
            parentObject = parent.getObject();
        }
        toExecuteNode.execute(disposeTree, action);
        this.register(parentObject, toReplace);
    }

    public boolean containsKey(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.containsKey must not be null");
        }
        return this.getNode(object) != null;
    }

    public void assertNoReferenceKeptInTree(T disposable) {
        Collection nodes = this.myObject2NodeMap.values();
        for (ObjectNode node : nodes) {
            node.assertNoReferencesKept(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootObject(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.removeRootObject must not be null");
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            this.myRootObjects.remove(object);
        }
    }

    public void assertIsEmpty(boolean throwError) {
        boolean firstObject = true;
        for (Object object : this.myRootObjects) {
            ObjectNode objectNode;
            if (object == null || (objectNode = this.getNode(object)) == null) continue;
            if (firstObject) {
                firstObject = false;
                System.err.println("***********************************************************************************************");
                System.err.println("***                        M E M O R Y    L E A K S   D E T E C T E D                       ***");
                System.err.println("***********************************************************************************************");
                System.err.println("***                                                                                         ***");
                System.err.println("***   The following objects were not disposed: ");
            }
            System.err.println("***   " + object + " of class " + object.getClass());
            Throwable trace = objectNode.getTrace();
            if (trace == null) continue;
            System.err.println("***         First seen at: ");
            trace.printStackTrace();
            if (!throwError) continue;
            throw new RuntimeException("Memory leak detected: " + object + " of class " + object.getClass() + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
        }
        if (!firstObject) {
            System.err.println("***                                                                                         ***");
            System.err.println("***********************************************************************************************");
        }
    }

    public boolean isEmpty() {
        return this.myRootObjects.isEmpty();
    }

    public void clearAll() {
        this.myRootObjects.clear();
        this.myExecutedNodes.clear();
        this.myExecutedUnregisteredNodes.clear();
        this.myObject2NodeMap.clear();
    }

    public THashSet<T> getRootObjects() {
        return this.myRootObjects;
    }

    public void addListener(ObjectTreeListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(ObjectTreeListener listener) {
        this.myListeners.remove(listener);
    }

    void fireRegistered(Object object) {
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(Object object) {
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
    }

    public int size() {
        return this.myObject2NodeMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <D extends Disposable> D findRegisteredObject(@NotNull T parentDisposable, @NotNull D object) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.findRegisteredObject must not be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/objectTree/ObjectTree.findRegisteredObject must not be null");
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode<T> parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            for (ObjectNode<T> node : parentNode.getChildren()) {
                T nodeObject = node.getObject();
                if (!nodeObject.equals(object)) continue;
                return (D)((Disposable)nodeObject);
            }
            return null;
        }
    }

    public long getModification() {
        return this.myModification;
    }

    private static class MyTHashSet<T>
    extends THashSet<T> {
        private MyTHashSet() {
            super(IDENTITY);
        }

        public void compact() {
            if ((int)((float)this.capacity() * this._loadFactor) / Math.max(1, this.size()) >= 3) {
                super.compact();
            }
        }
    }
}

