/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SystemInfo {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    private static final String _OS_NAME = OS_NAME.toLowerCase();
    public static final boolean isWindows = _OS_NAME.startsWith("windows");
    public static final boolean isWindowsNT = _OS_NAME.startsWith("windows nt");
    public static final boolean isWindows2000 = _OS_NAME.startsWith("windows 2000");
    public static final boolean isWindows2003 = _OS_NAME.startsWith("windows 2003");
    public static final boolean isWindowsXP = _OS_NAME.startsWith("windows xp");
    public static final boolean isWindowsVista = _OS_NAME.startsWith("windows vista");
    public static final boolean isWindows7 = _OS_NAME.startsWith("windows 7");
    public static final boolean isWindows9x = _OS_NAME.startsWith("windows 9") || _OS_NAME.startsWith("windows me");
    public static final boolean isOS2 = _OS_NAME.startsWith("os/2") || _OS_NAME.startsWith("os2");
    public static final boolean isMac = _OS_NAME.startsWith("mac");
    public static final boolean isFreeBSD = _OS_NAME.startsWith("freebsd");
    public static final boolean isLinux = _OS_NAME.startsWith("linux");
    public static final boolean isSolaris = _OS_NAME.startsWith("sunos");
    public static final boolean isUnix = !isWindows && !isOS2;
    private static final String _SUN_DESKTOP = SUN_DESKTOP.toLowerCase();
    public static final boolean isKDE = _SUN_DESKTOP.contains("kde");
    public static final boolean isGnome = _SUN_DESKTOP.contains("gnome");
    public static final boolean hasXdgOpen = isUnix && new File("/usr/bin/xdg-open").canExecute();
    public static final boolean isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
    public static final boolean isFileSystemCaseSensitive = !isWindows && !isOS2 && !isMac;
    public static final boolean areSymLinksSupported = isUnix || isWindows && OS_VERSION.compareTo("6.0") >= 0 && SystemInfo.isJavaVersionAtLeast("1.7");
    public static final boolean is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
    public static final boolean is64Bit = !is32Bit;
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);
    public static final boolean isMacIntel64;
    public static final String nativeFileManagerName;
    public static final boolean isMacOSTiger;
    public static final boolean isIntelMac;
    public static final boolean isMacOSLeopard;
    public static final boolean isMacOSSnowLeopard;
    public static final boolean isMacOSLion;
    public static final boolean isMacOSMountainLion;
    public static boolean X11PasteEnabledSystem;

    private static boolean isIntelMac() {
        return isMac && "i386".equals(OS_ARCH);
    }

    private static boolean isTiger() {
        return isMac && !OS_VERSION.startsWith("10.0") && !OS_VERSION.startsWith("10.1") && !OS_VERSION.startsWith("10.2") && !OS_VERSION.startsWith("10.3");
    }

    private static boolean isLeopard() {
        return isMac && SystemInfo.isTiger() && !OS_VERSION.startsWith("10.4");
    }

    private static boolean isSnowLeopard() {
        return isMac && SystemInfo.isLeopard() && !OS_VERSION.startsWith("10.5");
    }

    private static boolean isLion() {
        return isMac && SystemInfo.isSnowLeopard() && !OS_VERSION.startsWith("10.6");
    }

    private static boolean isMountainLion() {
        return isMac && SystemInfo.isLion() && !OS_VERSION.startsWith("10.7");
    }

    @NotNull
    public static String getMacOSMajorVersion() {
        String string = SystemInfo.getMacOSMajorVersion(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/SystemInfo.getMacOSMajorVersion must not return null");
        }
        return string;
    }

    public static String getMacOSMajorVersion(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%d.%d", parts[0], parts[1]);
    }

    @NotNull
    public static String getMacOSVersionCode() {
        String string = SystemInfo.getMacOSVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/SystemInfo.getMacOSVersionCode must not return null");
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode() {
        String string = SystemInfo.getMacOSMajorVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/SystemInfo.getMacOSMajorVersionCode must not return null");
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode() {
        String string = SystemInfo.getMacOSMinorVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/SystemInfo.getMacOSMinorVersionCode must not return null");
        }
        return string;
    }

    @NotNull
    public static String getMacOSVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/SystemInfo.getMacOSVersionCode must not be null");
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), SystemInfo.normalize(parts[2]));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/SystemInfo.getMacOSVersionCode must not return null");
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/SystemInfo.getMacOSMajorVersionCode must not be null");
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), 0);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/SystemInfo.getMacOSMajorVersionCode must not return null");
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/SystemInfo.getMacOSMinorVersionCode must not be null");
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%02d", parts[1], parts[2]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/SystemInfo.getMacOSMinorVersionCode must not return null");
        }
        return string;
    }

    private static int[] getMacOSVersionParts(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/SystemInfo.getMacOSVersionParts must not be null");
        }
        List<String> parts = StringUtil.split(version, ".");
        if (parts.size() != 3) {
            return new int[]{0, 0, 0};
        }
        return new int[]{SystemInfo.toInt(parts.get(0)), SystemInfo.toInt(parts.get(1)), SystemInfo.toInt(parts.get(2))};
    }

    private static int normalize(int number) {
        return number > 9 ? 9 : number;
    }

    private static int toInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    public static int getIntProperty(@NotNull String key, int defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/SystemInfo.getIntProperty must not be null");
        }
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static {
        boolean bl = isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
        nativeFileManagerName = isMac ? "Finder" : (isGnome ? "Nautilus" : (isKDE ? "Konqueror" : (isWindows ? "Explorer" : "File Manager")));
        isMacOSTiger = SystemInfo.isTiger();
        isIntelMac = SystemInfo.isIntelMac();
        isMacOSLeopard = SystemInfo.isLeopard();
        isMacOSSnowLeopard = SystemInfo.isSnowLeopard();
        isMacOSLion = SystemInfo.isLion();
        isMacOSMountainLion = SystemInfo.isMountainLion();
        X11PasteEnabledSystem = isUnix && !isMac;
    }
}

