/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public abstract class LazyInstance<T>
extends NotNullLazyValue<T> {
    protected abstract Class<T> getInstanceClass() throws ClassNotFoundException;

    @Override
    @NotNull
    protected final T compute() {
        T t;
        try {
            Class<T> tClass = this.getInstanceClass();
            Constructor<T> constructor = tClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            t = tClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/LazyInstance.compute must not return null");
        }
        return t;
    }
}

