/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOMUtil {
    private static final ThreadLocal<SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final String ENCODING = "UTF-8";
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    private JDOMUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<org.jdom.Element> getChildren(@Nullable org.jdom.Element parent) {
        List list;
        if (parent != null) {
            List children = parent.getChildren();
            list = children;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildren must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildren must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<org.jdom.Element> getChildren(@Nullable org.jdom.Element parent, @NotNull String name) {
        List list;
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.getChildren must not be null");
        }
        if (parent != null) {
            List children = parent.getChildren(name);
            list = children;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildren must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildren must not return null");
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(org.jdom.Element e1, org.jdom.Element e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.attListsEqual(e1.getAttributes(), e2.getAttributes()) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER));
    }

    public static int getTreeHash(org.jdom.Element root) {
        return JDOMUtil.addToHash(0, root);
    }

    public static int getTreeHash(Document document) {
        return JDOMUtil.getTreeHash(document.getRootElement());
    }

    private static int addToHash(int i, org.jdom.Element element) {
        i = JDOMUtil.addToHash(i, element.getName());
        i = JDOMUtil.addToHash(i, element.getText());
        List list = element.getAttributes();
        for (Object aList : list) {
            Attribute attribute = (Attribute)aList;
            i = JDOMUtil.addToHash(i, attribute);
        }
        List<org.jdom.Element> children = JDOMUtil.getChildren(element);
        for (org.jdom.Element child : children) {
            i = JDOMUtil.addToHash(i, child);
        }
        return i;
    }

    private static int addToHash(int i, Attribute attribute) {
        i = JDOMUtil.addToHash(i, attribute.getName());
        i = JDOMUtil.addToHash(i, attribute.getValue());
        return i;
    }

    private static int addToHash(int i, String s) {
        return i * 31 + s.hashCode();
    }

    @NotNull
    public static Object[] getChildNodesWithAttrs(org.jdom.Element e) {
        ArrayList result = new ArrayList();
        result.addAll(e.getContent());
        result.addAll(e.getAttributes());
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildNodesWithAttrs must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static Content[] getContent(org.jdom.Element m) {
        List list = m.getContent();
        Content[] contentArray = list.toArray(new Content[list.size()]);
        if (contentArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getContent must not return null");
        }
        return contentArray;
    }

    @NotNull
    public static org.jdom.Element[] getElements(org.jdom.Element m) {
        List list = m.getChildren();
        org.jdom.Element[] elementArray = list.toArray(new org.jdom.Element[list.size()]);
        if (elementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getElements must not return null");
        }
        return elementArray;
    }

    @NotNull
    public static String concatTextNodesValues(Object[] nodes) {
        StringBuilder result = new StringBuilder();
        for (Object node : nodes) {
            result.append(((Content)node).getValue());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.concatTextNodesValues must not return null");
        }
        return string;
    }

    public static void addContent(org.jdom.Element targetElement, Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            targetElement.addContent(content);
        } else if (node instanceof List) {
            List list = (List)node;
            targetElement.addContent((Collection)list);
        } else {
            throw new IllegalArgumentException("Wrong node: " + node);
        }
    }

    public static void internElement(org.jdom.Element element, StringInterner interner) {
        element.setName(JDOMUtil.intern(interner, element.getName()));
        List attributes = element.getAttributes();
        for (Object o : attributes) {
            Attribute attr = (Attribute)o;
            attr.setName(JDOMUtil.intern(interner, attr.getName()));
            attr.setValue(JDOMUtil.intern(interner, attr.getValue()));
        }
        List content = element.getContent();
        for (Object o : content) {
            if (o instanceof org.jdom.Element) {
                org.jdom.Element e = (org.jdom.Element)o;
                JDOMUtil.internElement(e, interner);
                continue;
            }
            if (o instanceof Text) {
                Text text = (Text)o;
                text.setText(JDOMUtil.intern(interner, text.getText()));
                continue;
            }
            if (o instanceof Comment) {
                Comment comment = (Comment)o;
                comment.setText(JDOMUtil.intern(interner, comment.getText()));
                continue;
            }
            throw new IllegalArgumentException("Wrong node: " + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static String intern(StringInterner interner, String s) {
        StringInterner stringInterner = interner;
        // MONITORENTER : stringInterner
        String string = interner.intern(s);
        // MONITOREXIT : stringInterner
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.intern must not return null");
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.legalizeText must not be null");
        }
        StringReader reader = new StringReader(str);
        StringBuilder result = new StringBuilder();
        while (true) {
            try {
                int each;
                while ((each = reader.read()) != -1) {
                    if (Verifier.isXMLCharacter((int)each)) {
                        result.append((char)each);
                        continue;
                    }
                    result.append("0x").append(Long.toHexString(each).toUpperCase());
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        String string = result.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.legalizeText must not return null");
        }
        return string;
    }

    private static boolean contentListsEqual(List c1, List c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next())) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2) {
        if (!(c1 instanceof org.jdom.Element) && !(c2 instanceof org.jdom.Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof org.jdom.Element && c2 instanceof org.jdom.Element && JDOMUtil.areElementsEqual((org.jdom.Element)c1, (org.jdom.Element)c2);
    }

    private static boolean attListsEqual(List a1, List a2) {
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            if (JDOMUtil.attEqual((Attribute)a1.get(i), (Attribute)a2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    public static boolean areDocumentsEqual(Document d1, Document d2) {
        if (d1.hasRootElement() != d2.hasRootElement()) {
            return false;
        }
        if (!d1.hasRootElement()) {
            return true;
        }
        CharArrayWriter w1 = new CharArrayWriter();
        CharArrayWriter w2 = new CharArrayWriter();
        try {
            JDOMUtil.writeDocument(d1, w1, "\n");
            JDOMUtil.writeDocument(d2, w2, "\n");
        }
        catch (IOException e) {
            JDOMUtil.getLogger().error(e);
        }
        return w1.size() == w2.size() && w1.toString().equals(w2.toString());
    }

    @NotNull
    public static Document loadDocument(char[] chars, int length) throws IOException, JDOMException {
        Document document = JDOMUtil.getSaxBuilder().build((Reader)new CharArrayReader(chars, 0, length));
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document;
    }

    private static SAXBuilder getSaxBuilder() {
        SAXBuilder saxBuilder;
        SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder sAXBuilder = saxBuilder = reference != null ? reference.get() : null;
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                }
            });
            ourSaxBuilder.set(new SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @NotNull
    public static Document loadDocument(CharSequence seq) throws IOException, JDOMException {
        Document document = JDOMUtil.getSaxBuilder().build((Reader)new CharSequenceReader(seq));
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Document loadDocument(File file) throws JDOMException, IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        Document document = JDOMUtil.loadDocument(inputStream);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document2;
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Document loadDocument(IFile iFile) throws IOException, JDOMException {
        BufferedInputStream inputStream = new BufferedInputStream(iFile.openInputStream());
        Document document = JDOMUtil.loadDocument(inputStream);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document2;
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.loadDocument must not be null");
        }
        InputStreamReader reader = new InputStreamReader(stream, ENCODING);
        Document document = JDOMUtil.getSaxBuilder().build((Reader)reader);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(Class clazz, String reaource) throws JDOMException, IOException {
        InputStream stream = clazz.getResourceAsStream(reaource);
        if (stream == null) {
            throw new FileNotFoundException(reaource);
        }
        Document document = JDOMUtil.loadDocument(stream);
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openStream(url));
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document;
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadResourceDocument must not return null");
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, String filePath, String lineSeparator) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, File file, String lineSeparator) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(Document document, OutputStream stream, String lineSeparator) throws IOException {
        JDOMUtil.writeDocument(document, new OutputStreamWriter(stream, ENCODING), lineSeparator);
    }

    @NotNull
    public static byte[] printDocument(Document document, String lineSeparator) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        JDOMUtil.writeDocument(document, writer, lineSeparator);
        byte[] byArray = new String(writer.toCharArray()).getBytes(ENCODING);
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.printDocument must not return null");
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String writeDocument(Document document, String lineSeparator) {
        String string;
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            return "";
        }
        String string2 = string;
        if (string != null) return string2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.writeDocument must not return null");
    }

    @NotNull
    public static String writeParent(Parent element, String lineSeparator) throws IOException {
        String string;
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeParent(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException ignored) {
            throw new RuntimeException(ignored);
        }
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.writeParent must not return null");
        }
        return string;
    }

    public static void writeParent(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof org.jdom.Element) {
            JDOMUtil.writeElement((org.jdom.Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(org.jdom.Element element, Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(org.jdom.Element element, String lineSeparator) {
        String string;
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException ignored) {
            throw new RuntimeException(ignored);
        }
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.writeElement must not return null");
        }
        return string;
    }

    @NotNull
    public static String writeChildren(@Nullable org.jdom.Element element, @NotNull String lineSeparator) {
        String string;
        if (lineSeparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.writeChildren must not be null");
        }
        try {
            StringWriter writer = new StringWriter();
            for (org.jdom.Element child : JDOMUtil.getChildren(element)) {
                JDOMUtil.writeElement(child, writer, lineSeparator);
                writer.append(lineSeparator);
            }
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.writeChildren must not return null");
        }
        return string;
    }

    public static void writeDocument(Document document, Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        MyXMLOutputter xmlOutputter = new MyXMLOutputter();
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding(ENCODING).setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        xmlOutputter.setFormat(format);
        MyXMLOutputter myXMLOutputter = xmlOutputter;
        if (myXMLOutputter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.createOutputter must not return null");
        }
        return myXMLOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(String text) {
        String string = JDOMUtil.escapeText(text, false, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.escapeText must not return null");
        }
        return string;
    }

    @NotNull
    public static String escapeText(String text, boolean escapeSpaces, boolean escapeLineEnds) {
        String string = JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.escapeText must not return null");
        }
        return string;
    }

    @NotNull
    public static String escapeText(String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        StringBuffer buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            if (buffer == null) {
                if (quotation == null) continue;
                buffer = new StringBuffer(text.length() + 20);
                buffer.append(text.substring(0, i));
                buffer.append(quotation);
                continue;
            }
            if (quotation == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(quotation);
        }
        String string = buffer == null ? text : buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.escapeText must not return null");
        }
        return string;
    }

    @NotNull
    public static List<org.jdom.Element> getChildrenFromAllNamespaces(org.jdom.Element element, @NonNls String name) {
        ArrayList<org.jdom.Element> result = new ArrayList<org.jdom.Element>();
        List children = element.getChildren();
        for (Object aChildren : children) {
            org.jdom.Element child = (org.jdom.Element)aChildren;
            if (!name.equals(child.getName())) continue;
            result.add(child);
        }
        ArrayList<org.jdom.Element> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildrenFromAllNamespaces must not return null");
        }
        return arrayList;
    }

    private static void printDiagnostics(org.jdom.Element element, String prefix) {
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        List<org.jdom.Element> children = JDOMUtil.getChildren(element);
        for (org.jdom.Element child : children) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(org.jdom.Element element) {
        int length;
        ElementInfo info = new ElementInfo();
        StringBuilder buf = new StringBuilder(element.getName());
        List attributes = element.getAttributes();
        if (attributes != null && (length = attributes.size()) > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = (Attribute)attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                info.hasNullAttributes = true;
            }
            buf.append("]");
        }
        info.name = buf.toString();
        ElementInfo elementInfo = info;
        if (elementInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getElementInfo must not return null");
        }
        return elementInfo;
    }

    public static void updateFileSet(File[] oldFiles, String[] newFilePaths, Document[] newFileDocuments, String lineSeparator) throws IOException {
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static Element convertToDOM(@NotNull org.jdom.Element e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.convertToDOM must not be null");
        }
        try {
            Document d = new Document();
            org.jdom.Element newRoot = new org.jdom.Element(e.getName());
            List attributes = e.getAttributes();
            for (Object o : attributes) {
                Attribute attr = (Attribute)o;
                newRoot.setAttribute(attr.getName(), attr.getValue(), attr.getNamespace());
            }
            d.addContent((Content)newRoot);
            newRoot.addContent((Collection)e.cloneContent());
            return new DOMOutputter().output(d).getDocumentElement();
        }
        catch (JDOMException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static org.jdom.Element convertFromDOM(Element e) {
        return new DOMBuilder().build(e);
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    private static class ElementInfo {
        public String name = "";
        public boolean hasNullAttributes = false;

        private ElementInfo() {
        }
    }

    public static class MyXMLOutputter
    extends XMLOutputter {
        public String escapeAttributeEntities(String str) {
            return JDOMUtil.escapeText(str, false, true);
        }

        public String escapeElementEntities(String str) {
            return JDOMUtil.escapeText(str, false, false);
        }
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            if (obj instanceof Text) {
                Text t = (Text)obj;
                return !CharArrayUtil.containsOnlyWhiteSpaces(t.getText());
            }
            return true;
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");

        private LoggerHolder() {
        }
    }
}

