/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.lang.reflect.Field;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree;
    private static final ObjectTreeAction<Disposable> ourDisposeAction;
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    private Disposer() {
    }

    @NotNull
    public static Disposable newDisposable() {
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
            }
        };
        if (disposable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/Disposer.newDisposable must not return null");
        }
        return disposable;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        Disposer.register(parent, child, null);
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, final @NonNls @Nullable String key) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        assert (parent != child) : " Cannot register to itself";
        ourTree.register(parent, child);
        if (key != null) {
            assert (Disposer.get(key) == null);
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static boolean isDisposed(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.isDisposed must not be null");
        }
        return !ourTree.containsKey(disposable);
    }

    public static Disposable get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.get must not be null");
        }
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.dispose must not be null");
        }
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.dispose must not be null");
        }
        ourTree.executeAll(disposable, true, ourDisposeAction, processUnregistered);
    }

    public static void disposeChildAndReplace(@NotNull Disposable toDipose, @NotNull Disposable toReplace) {
        if (toDipose == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.disposeChildAndReplace must not be null");
        }
        if (toReplace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.disposeChildAndReplace must not be null");
        }
        ourTree.executeChildAndReplace(toDipose, toReplace, true, ourDisposeAction);
    }

    @NotNull
    public static ObjectTree<Disposable> getTree() {
        ObjectTree<Disposable> objectTree = ourTree;
        if (objectTree == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/Disposer.getTree must not return null");
        }
        return objectTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean isEmpty() {
        return ourDebugMode && ourTree.isEmpty();
    }

    public static void setDebugMode(boolean b) {
        ourDebugMode = b;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static void clearOwnFields(@NotNull Object object) {
        Field[] all;
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.clearOwnFields must not be null");
        }
        for (Field each : all = object.getClass().getDeclaredFields()) {
            if ((each.getModifiers() & 0x18) > 0) continue;
            ReflectionUtil.resetField(object, each);
        }
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.findRegisteredObject must not be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.findRegisteredObject must not be null");
        }
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    static {
        try {
            ourTree = new ObjectTree();
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("loader=" + Disposer.class.getClassLoader(), e);
        }
        ourDisposeAction = new ObjectTreeAction<Disposable>(){

            @Override
            public void execute(Disposable each) {
                each.dispose();
            }

            @Override
            public void beforeTreeExecution(Disposable parent) {
                if (parent instanceof Disposable.Parent) {
                    ((Disposable.Parent)parent).beforeTreeDispose();
                }
            }
        };
        ourKeyDisposables = new ConcurrentWeakHashMap<String, Disposable>();
    }
}

