/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Computable<T> {
    public T compute();

    public static abstract class NullableCachedComputable<T>
    implements Computable<T> {
        private static final Object NULL_VALUE = new Object();
        private Object myValue;

        @Nullable
        protected abstract T internalCompute();

        @Override
        @Nullable
        public final T compute() {
            if (this.myValue == null) {
                T value = this.internalCompute();
                this.myValue = value != null ? value : NULL_VALUE;
            }
            return (T)(this.myValue != NULL_VALUE ? this.myValue : null);
        }
    }

    public static abstract class NotNullCachedComputable<T>
    implements Computable<T> {
        private T myValue;

        @NotNull
        protected abstract T internalCompute();

        @Override
        @NotNull
        public final T compute() {
            if (this.myValue == null) {
                this.myValue = this.internalCompute();
            }
            T t = this.myValue;
            if (t == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/Computable$NotNullCachedComputable.compute must not return null");
            }
            return t;
        }
    }

    public static class PredefinedValueComputable<T>
    implements Computable<T> {
        private final T myValue;

        public PredefinedValueComputable(@Nullable T value) {
            this.myValue = value;
        }

        @Override
        public T compute() {
            return this.myValue;
        }
    }
}

