/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExecutionCallback;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ActionCallback
implements Disposable {
    private final ExecutionCallback myDone;
    private final ExecutionCallback myRejected;
    private final String myName;

    public ActionCallback() {
        this(null);
    }

    public ActionCallback(String name) {
        this.myName = name;
        this.myDone = new ExecutionCallback();
        this.myRejected = new ExecutionCallback();
    }

    public ActionCallback(int countToDone) {
        this(null, countToDone);
    }

    public ActionCallback(String name, int countToDone) {
        this.myName = name;
        assert (countToDone >= 0) : "count=" + countToDone;
        int count = countToDone >= 1 ? countToDone : 1;
        this.myDone = new ExecutionCallback(count);
        this.myRejected = new ExecutionCallback();
        if (countToDone < 1) {
            this.setDone();
        }
    }

    public void setDone() {
        this.myDone.setExecuted();
        Disposer.dispose(this);
    }

    public boolean isDone() {
        return this.myDone.isExecuted();
    }

    public boolean isRejected() {
        return this.myRejected.isExecuted();
    }

    public boolean isProcessed() {
        return this.isDone() || this.isRejected();
    }

    public void setRejected() {
        this.myRejected.setExecuted();
        Disposer.dispose(this);
    }

    public final ActionCallback doWhenDone(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ActionCallback.doWhenDone must not be null");
        }
        this.myDone.doWhenExecuted(runnable);
        return this;
    }

    public final ActionCallback doWhenRejected(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ActionCallback.doWhenRejected must not be null");
        }
        this.myRejected.doWhenExecuted(runnable);
        return this;
    }

    public final ActionCallback doWhenProcessed(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ActionCallback.doWhenProcessed must not be null");
        }
        this.doWhenDone(runnable);
        this.doWhenRejected(runnable);
        return this;
    }

    public final ActionCallback notifyWhenDone(final ActionCallback child) {
        return this.doWhenDone(new Runnable(){

            @Override
            public void run() {
                child.setDone();
            }
        });
    }

    public final ActionCallback notifyWhenRejected(final ActionCallback child) {
        return this.doWhenRejected(new Runnable(){

            @Override
            public void run() {
                child.setRejected();
            }
        });
    }

    public final ActionCallback notify(final ActionCallback child) {
        return this.doWhenDone(new Runnable(){

            @Override
            public void run() {
                child.setDone();
            }
        }).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                child.setRejected();
            }
        });
    }

    public final ActionCallback processOnDone(Runnable runnable, boolean requiresDone) {
        if (requiresDone) {
            return this.doWhenDone(runnable);
        }
        runnable.run();
        return this;
    }

    public String toString() {
        String name = this.myName != null ? this.myName : super.toString();
        return name + " done=[" + this.myDone + "] rejected=[" + this.myRejected + "]";
    }

    @Override
    public void dispose() {
    }

    public static class Chunk {
        Set<ActionCallback> myCallbacks = new LinkedHashSet<ActionCallback>();

        public void add(ActionCallback callback) {
            this.myCallbacks.add(callback);
        }

        public ActionCallback getWhenProcessed() {
            final ActionCallback result = new ActionCallback(this.myCallbacks.size());
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        result.setDone();
                    }
                });
            }
            return result;
        }
    }

    public static class Rejected
    extends ActionCallback {
        public Rejected() {
            this.setRejected();
        }
    }

    public static class Done
    extends ActionCallback {
        public Done() {
            this.setDone();
        }
    }
}

