/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extension;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private final LogProvider myLogger;
    private final AreaInstance myArea;
    private final String myName;
    private final String myClassName;
    private final ExtensionPoint.Kind myKind;
    private final List<T> myExtensions = new ArrayList<T>();
    private volatile T[] myExtensionsCache;
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    private final Set<ExtensionComponentAdapter> myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
    private final List<ExtensionPointListener<T>> myEPListeners = ContainerUtil.createEmptyCOWList();
    private final List<ExtensionComponentAdapter> myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
    private Class<T> myExtensionClass;

    public ExtensionPointImpl(String name, String className, ExtensionPoint.Kind kind, ExtensionsAreaImpl owner, AreaInstance area, LogProvider logger, PluginDescriptor descriptor) {
        this.myName = name;
        this.myClassName = className;
        this.myKind = kind;
        this.myOwner = owner;
        this.myArea = area;
        this.myLogger = logger;
        this.myDescriptor = descriptor;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public AreaInstance getArea() {
        return this.myArea;
    }

    @Override
    public String getBeanClassName() {
        return this.myClassName;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public ExtensionPoint.Kind getKind() {
        return this.myKind;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.registerExtension must not be null");
        }
        this.registerExtension(extension, LoadingOrder.ANY);
    }

    public PluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public synchronized void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.registerExtension must not be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.registerExtension must not be null");
        }
        assert (this.myExtensions.size() == this.myLoadedAdapters.size());
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index = this.myLoadedAdapters.size();
            if (index > 0 && (lastAdapter = this.myLoadedAdapters.get(index - 1)).getOrder() == LoadingOrder.LAST) {
                --index;
            }
            this.internalRegisterExtension(extension, new ObjectComponentAdapter(extension, order), index, true);
        } else {
            this.myExtensionAdapters.add(new ObjectComponentAdapter(extension, order));
            this.processAdapters();
        }
        this.clearCache();
    }

    private void internalRegisterExtension(T extension, ExtensionComponentAdapter adapter, int index, boolean runNotifications) {
        if (this.myExtensions.contains(extension)) {
            this.myLogger.error("Extension was already added: " + extension);
            return;
        }
        this.myExtensions.add(index, extension);
        this.myLoadedAdapters.add(index, adapter);
        if (runNotifications) {
            if (extension instanceof Extension) {
                try {
                    ((Extension)extension).extensionAdded(this);
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
            this.clearCache();
            this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor());
        }
    }

    private void notifyListenersOnAdd(T extension, PluginDescriptor pluginDescriptor) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] result = this.myExtensionsCache;
        if (result == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result = this.myExtensionsCache;
                if (result == null) {
                    this.processAdapters();
                    Class<T> extensionClass = this.getExtensionClass();
                    result = this.myExtensions.toArray((Object[])Array.newInstance(extensionClass, this.myExtensions.size()));
                    for (int i = result.length - 1; i >= 0; --i) {
                        T t = result[i];
                        if (i > 0 && result[i] == result[i - 1]) {
                            LOG.error("Duplicate extension found: " + t + "; " + " Result:      " + Arrays.asList(result) + ";\n" + " extensions: " + this.myExtensions + ";\n" + " getExtensionClass(): " + extensionClass + ";\n" + " size:" + this.myExtensions.size() + ";" + result.length);
                        }
                        if (extensionClass.isAssignableFrom(t.getClass())) continue;
                        LOG.error("Extension '" + t.getClass() + "' must be an instance of '" + extensionClass + "'", new ExtensionException(t.getClass()));
                        result = ArrayUtil.remove(result, i);
                    }
                    this.myExtensionsCache = result;
                }
            }
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionPointImpl.getExtensions must not return null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        T[] cache = this.myExtensionsCache;
        if (cache != null) {
            return cache.length > 0;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.myExtensionAdapters.size() + this.myLoadedAdapters.size() > 0;
        }
    }

    private void processAdapters() {
        int totalSize = this.myExtensionAdapters.size() + this.myLoadedAdapters.size();
        if (totalSize != 0) {
            ArrayList<ExtensionComponentAdapter> allAdapters = new ArrayList<ExtensionComponentAdapter>(totalSize);
            allAdapters.addAll(this.myExtensionAdapters);
            allAdapters.addAll(this.myLoadedAdapters);
            this.myExtensions.clear();
            ExtensionComponentAdapter[] loadedAdapters = this.myLoadedAdapters.isEmpty() ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()]);
            this.myLoadedAdapters.clear();
            LoadingOrder.Orderable[] adapters = allAdapters.toArray(new ExtensionComponentAdapter[this.myExtensionAdapters.size()]);
            LoadingOrder.sort(adapters);
            for (LoadingOrder.Orderable adapter : adapters) {
                Object extension = ((ExtensionComponentAdapter)adapter).getExtension();
                this.internalRegisterExtension(extension, (ExtensionComponentAdapter)adapter, this.myExtensions.size(), ArrayUtil.find(loadedAdapters, adapter) == -1);
            }
            this.myExtensionAdapters.clear();
        }
    }

    @Override
    @Nullable
    public T getExtension() {
        T[] extensions = this.getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        return extensions[0];
    }

    @Override
    public synchronized boolean hasExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.hasExtension must not be null");
        }
        this.processAdapters();
        return this.myExtensions.contains(extension);
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        MutablePicoContainer[] pluginContainers;
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.unregisterExtension must not be null");
        }
        int index = this.getExtensionIndex(extension);
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index);
        this.myOwner.getMutablePicoContainer().unregisterComponent(adapter.getComponentKey());
        for (MutablePicoContainer pluginContainer : pluginContainers = this.myOwner.getPluginContainers()) {
            pluginContainer.unregisterComponent(adapter.getComponentKey());
        }
        this.processAdapters();
        this.internalUnregisterExtension(extension, null);
    }

    private int getExtensionIndex(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.getExtensionIndex must not be null");
        }
        int i = this.myExtensions.indexOf(extension);
        if (i == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        return i;
    }

    private void internalUnregisterExtension(T extension, PluginDescriptor pluginDescriptor) {
        int index = this.getExtensionIndex(extension);
        this.myExtensions.remove(index);
        this.myLoadedAdapters.remove(index);
        this.clearCache();
        this.notifyListenersOnRemove(extension, pluginDescriptor);
        if (extension instanceof Extension) {
            Extension o = (Extension)extension;
            try {
                o.extensionRemoved(this);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(T extensionObject, PluginDescriptor pluginDescriptor) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(final @NotNull ExtensionPointListener<T> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.addExtensionPointListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.addExtensionPointListener must not be null");
        }
        this.addExtensionPointListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ExtensionPointImpl.this.removeExtensionPointListener(listener);
            }
        });
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.addExtensionPointListener must not be null");
        }
        this.processAdapters();
        if (this.myEPListeners.add(listener)) {
            for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    listener.extensionAdded(componentAdapter.getExtension(), componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
        }
    }

    @Override
    public synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.removeExtensionPointListener must not be null");
        }
        for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
            try {
                listener.extensionRemoved(componentAdapter.getExtension(), componentAdapter.getPluginDescriptor());
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
        boolean success = this.myEPListeners.remove(listener);
        assert (success);
    }

    @Override
    public synchronized void reset() {
        this.myOwner.removeAllComponents(this.myExtensionAdapters);
        this.myExtensionAdapters.clear();
        for (T extension : this.getExtensions()) {
            this.unregisterExtension(extension);
        }
    }

    @Override
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                extensionClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return extensionClass;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(ExtensionComponentAdapter adapter) {
        this.myExtensionAdapters.add(adapter);
        this.clearCache();
    }

    private void clearCache() {
        this.myExtensionsCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean unregisterComponentAdapter(ExtensionComponentAdapter componentAdapter) {
        try {
            if (this.myExtensionAdapters.remove(componentAdapter)) {
                boolean bl = true;
                return bl;
            }
            if (this.myLoadedAdapters.contains(componentAdapter)) {
                MutablePicoContainer[] pluginContainers;
                Object componentKey = componentAdapter.getComponentKey();
                this.myOwner.getMutablePicoContainer().unregisterComponent(componentKey);
                for (MutablePicoContainer pluginContainer : pluginContainers = this.myOwner.getPluginContainers()) {
                    pluginContainer.unregisterComponent(componentKey);
                }
                this.internalUnregisterExtension(componentAdapter.getExtension(), componentAdapter.getPluginDescriptor());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    final synchronized void notifyAreaReplaced(ExtensionsArea area) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(area);
        }
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private final Object myExtension;
        private final LoadingOrder myLoadingOrder;

        private ObjectComponentAdapter(Object extension, LoadingOrder loadingOrder) {
            super(Object.class.getName(), null, null, null, false);
            this.myExtension = extension;
            this.myLoadingOrder = loadingOrder;
        }

        @Override
        public Object getExtension() {
            return this.myExtension;
        }

        @Override
        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        @Override
        @Nullable
        public String getOrderId() {
            return null;
        }

        @Override
        @NonNls
        public Element getDescribingElement() {
            return new Element("RuntimeExtension: " + this.myExtension);
        }
    }
}

