/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class Extensions {
    private static LogProvider ourLogger = new SimpleLogProvider();
    public static final ExtensionPointName<AreaListener> AREA_LISTENER_EXTENSION_POINT = new ExtensionPointName("com.intellij.arealistener");
    private static final Map<AreaInstance, ExtensionsAreaImpl> ourAreaInstance2area = new THashMap();
    @NotNull
    private static ExtensionsAreaImpl ourRootArea = Extensions.createRootArea();
    private static final MultiMap<String, AreaInstance> ourAreaClass2instances = new MultiMap();
    private static final Map<AreaInstance, String> ourAreaInstance2class = new THashMap();
    private static final Map<String, AreaClassConfiguration> ourAreaClass2Configuration = new THashMap();

    @NotNull
    private static ExtensionsAreaImpl createRootArea() {
        ExtensionsAreaImpl rootArea = new ExtensionsAreaImpl(null, null, null, ourLogger);
        rootArea.registerExtensionPoint(AREA_LISTENER_EXTENSION_POINT.getName(), AreaListener.class.getName());
        ExtensionsAreaImpl extensionsAreaImpl = rootArea;
        if (extensionsAreaImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.createRootArea must not return null");
        }
        return extensionsAreaImpl;
    }

    private Extensions() {
    }

    @NotNull
    public static ExtensionsArea getRootArea() {
        ExtensionsAreaImpl extensionsAreaImpl = ourRootArea;
        if (extensionsAreaImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getRootArea must not return null");
        }
        return extensionsAreaImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ExtensionsArea getArea(@Nullable AreaInstance areaInstance) {
        ExtensionsAreaImpl extensionsAreaImpl;
        if (areaInstance == null) {
            extensionsAreaImpl = ourRootArea;
            if (extensionsAreaImpl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getArea must not return null");
            return extensionsAreaImpl;
        }
        ExtensionsAreaImpl area = ourAreaInstance2area.get(areaInstance);
        if (area == null) {
            throw new IllegalArgumentException("No area instantiated for: " + areaInstance);
        }
        extensionsAreaImpl = area;
        if (extensionsAreaImpl != null) return extensionsAreaImpl;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getArea must not return null");
    }

    public static void cleanRootArea(@NotNull Disposable parentDisposable) {
        ExtensionsAreaImpl newArea;
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.cleanRootArea must not be null");
        }
        final ExtensionsAreaImpl oldRootArea = (ExtensionsAreaImpl)Extensions.getRootArea();
        ourRootArea = newArea = Extensions.createRootArea();
        oldRootArea.notifyAreaReplaced();
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ourRootArea = oldRootArea;
                newArea.notifyAreaReplaced();
            }
        });
    }

    @NotNull
    public static Object[] getExtensions(@NonNls String extensionPointName) {
        Object[] objectArray = Extensions.getExtensions(extensionPointName, null);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getExtensions must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.getExtensions must not be null");
        }
        T[] TArray = Extensions.getExtensions(extensionPointName.getName(), null);
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getExtensions must not return null");
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName, AreaInstance areaInstance) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.getExtensions must not be null");
        }
        T[] TArray = Extensions.getExtensions(extensionPointName.getName(), areaInstance);
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getExtensions must not return null");
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] getExtensions(String extensionPointName, @Nullable AreaInstance areaInstance) {
        ExtensionsArea area = Extensions.getArea(areaInstance);
        ExtensionPoint extensionPoint = area.getExtensionPoint(extensionPointName);
        T[] TArray = extensionPoint.getExtensions();
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getExtensions must not return null");
        }
        return TArray;
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.findExtension must not be null");
        }
        if (extClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.findExtension must not be null");
        }
        for (T t : Extensions.getExtensions(extensionPointName)) {
            if (!extClass.isInstance(t)) continue;
            T t2 = t;
            if (t2 == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.findExtension must not return null");
            }
            return (U)t2;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, AreaInstance areaInstance, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.findExtension must not be null");
        }
        if (extClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.findExtension must not be null");
        }
        for (T t : Extensions.getExtensions(extensionPointName, areaInstance)) {
            if (!extClass.isInstance(t)) continue;
            T t2 = t;
            if (t2 == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.findExtension must not return null");
            }
            return (U)t2;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    public static void instantiateArea(@NonNls @NotNull String areaClass, @Nullable AreaInstance areaInstance, @Nullable AreaInstance parentAreaInstance) {
        AreaListener[] listeners;
        if (areaClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.instantiateArea must not be null");
        }
        if (!ourAreaClass2Configuration.containsKey(areaClass)) {
            throw new IllegalArgumentException("Area class is not registered: " + areaClass);
        }
        if (areaInstance == null || ourAreaInstance2area.containsKey(areaInstance)) {
            throw new IllegalArgumentException("Area already instantiated for: " + areaInstance);
        }
        ExtensionsArea parentArea = Extensions.getArea(parentAreaInstance);
        AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
        if (!Extensions.equals(parentArea.getAreaClass(), configuration.getParentClassName())) {
            throw new IllegalArgumentException("Wrong parent area. Expected class: " + configuration.getParentClassName() + " actual class: " + parentArea.getAreaClass());
        }
        ExtensionsAreaImpl area = new ExtensionsAreaImpl(areaClass, areaInstance, (PicoContainer)parentArea.getPicoContainer(), ourLogger);
        ourAreaInstance2area.put(areaInstance, area);
        ourAreaClass2instances.putValue(areaClass, areaInstance);
        ourAreaInstance2class.put(areaInstance, areaClass);
        for (AreaListener listener : listeners = Extensions.getAreaListeners()) {
            listener.areaCreated(areaClass, areaInstance);
        }
    }

    @NotNull
    private static AreaListener[] getAreaListeners() {
        AreaListener[] areaListenerArray = Extensions.getRootArea().getExtensionPoint(AREA_LISTENER_EXTENSION_POINT).getExtensions();
        if (areaListenerArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getAreaListeners must not return null");
        }
        return areaListenerArray;
    }

    public static void registerAreaClass(@NonNls @NotNull String areaClass, @Nullable @NonNls String parentAreaClass) {
        if (areaClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.registerAreaClass must not be null");
        }
        if (ourAreaClass2Configuration.containsKey(areaClass)) {
            AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
            if (!Extensions.equals(configuration.getParentClassName(), parentAreaClass)) {
                throw new RuntimeException("Area class already registered: " + areaClass + ", " + ourAreaClass2Configuration.get(areaClass));
            }
            return;
        }
        AreaClassConfiguration configuration = new AreaClassConfiguration(areaClass, parentAreaClass);
        ourAreaClass2Configuration.put(areaClass, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeArea(@NotNull AreaInstance areaInstance) {
        if (areaInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.disposeArea must not be null");
        }
        assert (ourAreaInstance2area.containsKey(areaInstance));
        AreaListener[] listeners = Extensions.getAreaListeners();
        String areaClass = ourAreaInstance2class.get(areaInstance);
        if (areaClass == null) {
            throw new IllegalArgumentException("Area class is null (area never instantiated?). Instance: " + areaInstance);
        }
        try {
            for (AreaListener listener : listeners) {
                listener.areaDisposing(areaClass, areaInstance);
            }
        }
        finally {
            ourAreaInstance2area.remove(areaInstance);
            ourAreaClass2instances.removeValue(ourAreaInstance2class.remove(areaInstance), areaInstance);
            ourAreaInstance2class.remove(areaInstance);
        }
    }

    @NotNull
    public static AreaInstance[] getAllAreas(String areaClass) {
        Collection<AreaInstance> instances = ourAreaClass2instances.get(areaClass);
        AreaInstance[] areaInstanceArray = instances.toArray(new AreaInstance[instances.size()]);
        if (areaInstanceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getAllAreas must not return null");
        }
        return areaInstanceArray;
    }

    private static boolean equals(@Nullable Object object1, @Nullable Object object2) {
        return object1 == object2 || object1 != null && object2 != null && object1.equals(object2);
    }

    public static void setLogProvider(@NotNull LogProvider logProvider) {
        if (logProvider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.setLogProvider must not be null");
        }
        ourLogger = logProvider;
    }

    public static class SimpleLogProvider
    implements LogProvider {
        @Override
        public void error(String message) {
            new Throwable(message).printStackTrace();
        }

        @Override
        public void error(String message, @NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/Extensions$SimpleLogProvider.error must not be null");
            }
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void error(@NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions$SimpleLogProvider.error must not be null");
            }
            t.printStackTrace();
        }

        @Override
        public void warn(String message) {
            System.err.println(message);
        }

        @Override
        public void warn(String message, @NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/Extensions$SimpleLogProvider.warn must not be null");
            }
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void warn(@NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions$SimpleLogProvider.warn must not be null");
            }
            t.printStackTrace();
        }
    }

    private static class AreaClassConfiguration {
        private final String myClassName;
        private final String myParentClassName;

        AreaClassConfiguration(String className, String parentClassName) {
            this.myClassName = className;
            this.myParentClassName = parentClassName;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public String getParentClassName() {
            return this.myParentClassName;
        }
    }
}

