/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.SegmentArray;
import org.jetbrains.annotations.NotNull;

public class SegmentArrayWithData
extends SegmentArray {
    private short[] myData = new short[64];

    public void setElementAt(int i, int startOffset, int endOffset, int data) {
        if (data < 0 && data > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range" + data);
        }
        super.setElementAt(i, startOffset, endOffset);
        this.myData = SegmentArrayWithData.reallocateArray(this.myData, i + 1);
        this.myData[i] = (short)data;
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myData = this.remove(this.myData, startIndex, endIndex);
        super.remove(startIndex, endIndex);
    }

    public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
        if (newData == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.replace must not be null");
        }
        int oldLen = endIndex - startIndex;
        int newLen = newData.getSegmentCount();
        int delta = newLen - oldLen;
        if (delta < 0) {
            this.remove(endIndex + delta, endIndex);
        } else if (delta > 0) {
            SegmentArrayWithData deltaData = new SegmentArrayWithData();
            for (int i = oldLen; i < newLen; ++i) {
                deltaData.setElementAt(i - oldLen, newData.getSegmentStart(i), newData.getSegmentEnd(i), newData.getSegmentData(i));
            }
            this.insert(deltaData, startIndex + oldLen);
        }
        int common = Math.min(newLen, oldLen);
        this.replace(startIndex, newData, common);
    }

    protected void replace(int startOffset, @NotNull SegmentArrayWithData data, int len) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.replace must not be null");
        }
        System.arraycopy(data.myData, 0, this.myData, startOffset, len);
        super.replace(startOffset, data, len);
    }

    public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
        if (segmentArray == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.insert must not be null");
        }
        this.myData = this.insert(this.myData, segmentArray.myData, startIndex, segmentArray.getSegmentCount());
        super.insert(segmentArray, startIndex);
    }

    public short getSegmentData(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        return this.myData[index];
    }

    public void setSegmentData(int index, int data) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        if (data < 0 && data > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range" + data);
        }
        this.myData[index] = (short)data;
    }
}

