/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;

public class SegmentArray {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.ex.util.SegmentArray");
    private int[] myStarts = new int[64];
    private int[] myEnds = new int[64];
    protected int mySegmentCount = 0;
    protected static final int INITIAL_SIZE = 64;

    protected SegmentArray() {
    }

    protected void setElementAt(int i, int startOffset, int endOffset) {
        if (startOffset < 0) {
            LOG.error("Invalid startOffset:" + startOffset);
        }
        if (endOffset < 0) {
            LOG.error("Invalid endOffset:" + endOffset);
        }
        if (i >= this.mySegmentCount) {
            this.mySegmentCount = i + 1;
        }
        this.myStarts = SegmentArray.reallocateArray(this.myStarts, i);
        this.myStarts[i] = startOffset;
        this.myEnds = SegmentArray.reallocateArray(this.myEnds, i);
        this.myEnds[i] = endOffset;
    }

    protected void replace(int startOffset, @NotNull SegmentArray data, int len) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.replace must not be null");
        }
        System.arraycopy(data.myStarts, 0, this.myStarts, startOffset, len);
        System.arraycopy(data.myEnds, 0, this.myEnds, startOffset, len);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected static int[] reallocateArray(@NotNull int[] array, int index) {
        int[] nArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not be null");
        }
        if (index < array.length) {
            nArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not return null");
            return nArray;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 120 / 100;
        }
        int[] newArray = new int[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        nArray = newArray;
        if (newArray != null) return nArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected static <T> T[] reallocateArray(@NotNull T[] array, int index) {
        Object[] objectArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not be null");
        }
        if (index < array.length) {
            objectArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not return null");
            return objectArray;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 120 / 100;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), newArraySize);
        System.arraycopy(array, 0, newArray, 0, array.length);
        objectArray = newArray;
        if (newArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected static short[] reallocateArray(@NotNull short[] array, int index) {
        short[] sArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not be null");
        }
        if (index < array.length) {
            sArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not return null");
            return sArray;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 12 / 10;
        }
        short[] newArray = new short[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        sArray = newArray;
        if (newArray != null) return sArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.reallocateArray must not return null");
    }

    public final int findSegmentIndex(int offset) {
        if (this.mySegmentCount <= 0) {
            if (offset == 0) {
                return 0;
            }
            throw new IllegalStateException("no segments available. offset = " + offset);
        }
        int lastValidOffset = this.getLastValidOffset();
        if (offset > lastValidOffset || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Should be in range: [0, " + lastValidOffset + "]");
        }
        int lastValidIndex = this.mySegmentCount - 1;
        if (offset == lastValidOffset) {
            return lastValidIndex;
        }
        int start = 0;
        int end = lastValidIndex;
        while (start < end) {
            int i = (start + end) / 2;
            if (offset < this.myStarts[i]) {
                end = i - 1;
                continue;
            }
            if (offset >= this.myEnds[i]) {
                start = i + 1;
                continue;
            }
            return i;
        }
        assert (this.myStarts[start] <= offset && offset < this.myEnds[start]) : start;
        return start;
    }

    public int getLastValidOffset() {
        return this.mySegmentCount == 0 ? 0 : this.myEnds[this.mySegmentCount - 1];
    }

    public final void changeSegmentLength(int startIndex, int change) {
        if (startIndex >= 0 && startIndex < this.mySegmentCount) {
            int n = startIndex;
            this.myEnds[n] = this.myEnds[n] + change;
        }
        this.shiftSegments(startIndex + 1, change);
    }

    public final void shiftSegments(int startIndex, int shift) {
        for (int i = startIndex; i < this.mySegmentCount; ++i) {
            int n = i;
            this.myStarts[n] = this.myStarts[n] + shift;
            int n2 = i;
            this.myEnds[n2] = this.myEnds[n2] + shift;
            if (this.myStarts[i] >= 0 && this.myEnds[i] >= 0) continue;
            LOG.error("Error shifting segments: myStarts[" + i + "] = " + this.myStarts[i] + ", myEnds[" + i + "] = " + this.myEnds[i]);
        }
    }

    public void removeAll() {
        this.mySegmentCount = 0;
    }

    public void remove(int startIndex, int endIndex) {
        this.myStarts = this.remove(this.myStarts, startIndex, endIndex);
        this.myEnds = this.remove(this.myEnds, startIndex, endIndex);
        this.mySegmentCount -= endIndex - startIndex;
    }

    @NotNull
    protected int[] remove(@NotNull int[] array, int startIndex, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.remove must not be null");
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.remove must not return null");
        }
        return array;
    }

    @NotNull
    protected <T> T[] remove(@NotNull T[] array, int startIndex, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.remove must not be null");
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.remove must not return null");
        }
        return array;
    }

    @NotNull
    protected short[] remove(@NotNull short[] array, int startIndex, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.remove must not be null");
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.remove must not return null");
        }
        return array;
    }

    @NotNull
    protected long[] remove(@NotNull long[] array, int startIndex, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.remove must not be null");
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.remove must not return null");
        }
        return array;
    }

    protected void insert(@NotNull SegmentArray segmentArray, int startIndex) {
        if (segmentArray == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.insert must not be null");
        }
        this.myStarts = this.insert(this.myStarts, segmentArray.myStarts, startIndex, segmentArray.getSegmentCount());
        this.myEnds = this.insert(this.myEnds, segmentArray.myEnds, startIndex, segmentArray.getSegmentCount());
        this.mySegmentCount += segmentArray.getSegmentCount();
    }

    @NotNull
    protected int[] insert(@NotNull int[] array, @NotNull int[] insertArray, int startIndex, int insertLength) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.insert must not be null");
        }
        if (insertArray == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.insert must not be null");
        }
        int[] newArray = SegmentArray.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.insert must not return null");
        }
        return newArray;
    }

    @NotNull
    protected <T> T[] insert(@NotNull T[] array, @NotNull T[] insertArray, int startIndex, int insertLength) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.insert must not be null");
        }
        if (insertArray == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.insert must not be null");
        }
        T[] newArray = SegmentArray.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.insert must not return null");
        }
        return newArray;
    }

    @NotNull
    protected short[] insert(@NotNull short[] array, @NotNull short[] insertArray, int startIndex, int insertLength) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.insert must not be null");
        }
        if (insertArray == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArray.insert must not be null");
        }
        short[] newArray = SegmentArray.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArray.insert must not return null");
        }
        return newArray;
    }

    public int getSegmentStart(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.mySegmentCount);
        }
        return this.myStarts[index];
    }

    public int getSegmentEnd(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.mySegmentCount);
        }
        return this.myEnds[index];
    }

    public int getSegmentCount() {
        return this.mySegmentCount;
    }
}

