/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.util.diff.FilesTooBigForDiffException;

public interface DiffPolicy {
    public static final DiffPolicy LINES_WO_FORMATTING = new LineBlocks(ComparisonPolicy.IGNORE_SPACE);
    public static final DiffPolicy DEFAULT_LINES = new LineBlocks(ComparisonPolicy.DEFAULT);

    public DiffFragment[] buildFragments(String var1, String var2) throws FilesTooBigForDiffException;

    public static class ByChar
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public ByChar(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        public DiffFragment[] buildFragments(String text1, String text2) throws FilesTooBigForDiffException {
            return this.myComparisonPolicy.buildFragments(this.splitByChar(text1), this.splitByChar(text2));
        }

        private String[] splitByChar(String text) {
            String[] result = new String[text.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = text.substring(i, i + 1);
            }
            return result;
        }
    }

    public static class LineBlocks
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public LineBlocks(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        public DiffFragment[] buildFragments(String text1, String text2) throws FilesTooBigForDiffException {
            String[] strings1 = new LineTokenizer(text1).execute();
            String[] strings2 = new LineTokenizer(text2).execute();
            return this.myComparisonPolicy.buildDiffFragmentsFromLines(strings1, strings2);
        }
    }
}

