/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;

public class MockFileIndexFacade
extends FileIndexFacade {
    private final Module myModule = null;
    private final List<VirtualFile> myLibraryRoots = new ArrayList<VirtualFile>();

    public MockFileIndexFacade(Project project) {
        super(project);
    }

    @Override
    public boolean isInContent(VirtualFile file) {
        return true;
    }

    @Override
    public boolean isInSource(VirtualFile file) {
        return true;
    }

    @Override
    public boolean isInSourceContent(VirtualFile file) {
        return true;
    }

    @Override
    public boolean isInLibraryClasses(VirtualFile file) {
        for (VirtualFile libraryRoot : this.myLibraryRoots) {
            if (!VfsUtilCore.isAncestor(libraryRoot, file, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInLibrarySource(VirtualFile file) {
        return false;
    }

    @Override
    public boolean isExcludedFile(VirtualFile file) {
        return false;
    }

    @Override
    public Module getModuleForFile(VirtualFile file) {
        return this.myModule;
    }

    @Override
    public boolean isValidAncestor(VirtualFile baseDir, VirtualFile child) {
        return VfsUtilCore.isAncestor(baseDir, child, false);
    }

    public void addLibraryRoot(VirtualFile file) {
        this.myLibraryRoots.add(file);
    }
}

