/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DocCommentTokenTypes;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class _JavaDocLexer
implements FlexLexer {
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int INLINE_TAG_NAME = 8;
    public static final int PARAM_TAG_SPACE = 4;
    public static final int COMMENT_DATA = 2;
    public static final int DOC_TAG_VALUE = 5;
    public static final int COMMENT_DATA_START = 1;
    public static final int TAG_DOC_SPACE = 3;
    public static final int YYINITIAL = 0;
    public static final int DOC_TAG_VALUE_IN_PAREN = 6;
    public static final int DOC_TAG_VALUE_IN_LTGT = 7;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0002\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0001\u0012\u0000\u0001\u0002\u0002\u0000\u0001\u000b\u0001\u0004\u0003\u0000\u0001\t\u0001\n\u0001\u0007\u0001\u0000\u0001\f\u0001\u0005\u0001\u0003\u0001\u0006\n\u0003\u0001\u0005\u0001\u0000\u0001\u0012\u0001\u0000\u0001\u0013\u0001\u0000\u0001\r\u001a\u0004\u0001\b\u0001\u0000\u0001\b\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u000f\u000b\u0004\u0001\u0011\u0002\u0004\u0001\u000e\u0001\u0004\u0001\u0010\b\u0004\u0001\u0014\u0001\u0000\u0001\u0015$\u0000\u0004\u0004\u0004\u0000\u0001\u0004\n\u0000\u0001\u0004\u0004\u0000\u0001\u0004\u0005\u0000\u0017\u0004\u0001\u0000\u001f\u0004\u0001\u0000\u013f\u0004\u0019\u0000r\u0004\u0004\u0000\f\u0004\u000e\u0000\u0005\u0004\t\u0000\u0001\u0004\u008b\u0000\u0001\u0004\u000b\u0000\u0001\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0014\u0004\u0001\u0000,\u0004\u0001\u0000&\u0004\u0001\u0000\u0005\u0004\u0004\u0000\u0082\u0004\b\u0000E\u0004\u0001\u0000&\u0004\u0002\u0000\u0002\u0004\u0006\u0000\u0010\u0004!\u0000&\u0004\u0002\u0000\u0001\u0004\u0007\u0000'\u0004H\u0000\u001b\u0004\u0005\u0000\u0003\u0004.\u0000\u001a\u0004\u0005\u0000\u000b\u0004#\u0000\u0002\u0004\u0001\u0000c\u0004\u0001\u0000\u0001\u0004\u000f\u0000\u0002\u0004\u0007\u0000\u0002\u0004\n\u0000\u0003\u0004\u0002\u0000\u0001\u0004\u0010\u0000\u0001\u0004\u0001\u0000\u001e\u0004\u001d\u0000\u0003\u00040\u0000&\u0004\u000b\u0000\u0001\u0004\u0152\u00006\u0004\u0003\u0000\u0001\u0004\u0012\u0000\u0001\u0004\u0007\u0000\n\u0004#\u0000\b\u0004\u0002\u0000\u0002\u0004\u0002\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0003\u0000\u0004\u0004\u0003\u0000\u0001\u0004\u001e\u0000\u0002\u0004\u0001\u0000\u0003\u0004\u000e\u0000\u0004\u0004\u0011\u0000\u0006\u0004\u0004\u0000\u0002\u0004\u0002\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0002\u0004\u001f\u0000\u0004\u0004\u0001\u0000\u0001\u0004\u0013\u0000\u0003\u0004\u0010\u0000\t\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0005\u0004\u0003\u0000\u0001\u0004\u0012\u0000\u0001\u0004\u000f\u0000\u0002\u0004\u000f\u0000\u0001\u0004\u0013\u0000\b\u0004\u0002\u0000\u0002\u0004\u0002\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0005\u0004\u0003\u0000\u0001\u0004\u001e\u0000\u0002\u0004\u0001\u0000\u0003\u0004\u000f\u0000\u0001\u0004\u0011\u0000\u0001\u0004\u0001\u0000\u0006\u0004\u0003\u0000\u0003\u0004\u0001\u0000\u0004\u0004\u0003\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0002\u0004\u0003\u0000\u0002\u0004\u0003\u0000\u0003\u0004\u0003\u0000\b\u0004\u0001\u0000\u0003\u0004?\u0000\u0001\u0004\u000b\u0000\b\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0017\u0004\u0001\u0000\n\u0004\u0001\u0000\u0005\u0004&\u0000\u0002\u0004#\u0000\b\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0017\u0004\u0001\u0000\n\u0004\u0001\u0000\u0005\u0004\u0003\u0000\u0001\u0004 \u0000\u0001\u0004\u0001\u0000\u0002\u0004#\u0000\b\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0017\u0004\u0001\u0000\u0010\u0004&\u0000\u0002\u0004#\u0000\u0012\u0004\u0003\u0000\u0018\u0004\u0001\u0000\t\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0007\u0004:\u00000\u0004\u0001\u0000\u0002\u0004\u000b\u0000\b\u0004:\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0001\u0004\u0006\u0000\u0004\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0002\u0004\u0001\u0000\u0004\u0004\u0001\u0000\u0002\u0004\t\u0000\u0001\u0004\u0002\u0000\u0005\u0004\u0001\u0000\u0001\u0004\u0015\u0000\u0002\u0004\"\u0000\u0001\u0004?\u0000\b\u0004\u0001\u0000\"\u0004\u001d\u0000\u0004\u0004t\u0000\"\u0004\u0001\u0000\u0005\u0004\u0001\u0000\u0002\u0004%\u0000\u0006\u0004J\u0000&\u0004\n\u0000)\u0004\u0007\u0000Z\u0004\u0005\u0000D\u0004\u0005\u0000R\u0004\u0006\u0000\u0007\u0004\u0001\u0000?\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000'\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u001f\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0017\u0004\u0001\u0000\u001f\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000'\u0004\u0001\u0000\u0013\u0004E\u0000U\u0004\f\u0000\u026c\u0004\u0002\u0000\b\u0004\n\u0000\u001a\u0004\u0005\u0000K\u0004\u0003\u0000\u0003\u0004\u000f\u0000\r\u0004\u0001\u0000\u0004\u0004\u000e\u0000\u0012\u0004\u000e\u0000\u0012\u0004\u000e\u0000\r\u0004\u0001\u0000\u0003\u0004\u000f\u00004\u0004#\u0000\u0001\u0004\u0003\u0000\u0002\u0004C\u0000X\u0004\b\u0000)\u0004W\u0000\u001d\u00043\u0000\u001e\u0004\u0002\u0000\u0005\u0004\u038b\u0000l\u0004\u0094\u0000\u009c\u0004\u0004\u0000Z\u0004\u0006\u0000\u0016\u0004\u0002\u0000\u0006\u0004\u0002\u0000&\u0004\u0002\u0000\u0006\u0004\u0002\u0000\b\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u001f\u0004\u0002\u00005\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0003\u0000\u0003\u0004\u0001\u0000\u0007\u0004\u0003\u0000\u0004\u0004\u0002\u0000\u0006\u0004\u0004\u0000\r\u0004\u0005\u0000\u0003\u0004\u0001\u0000\u0007\u0004B\u0000\u0002\u0004\u0013\u0000\u0001\u0004\u001c\u0000\u0001\u0004\r\u0000\u0001\u0004 \u0000\u0012\u0004P\u0000\u0001\u0004\u0004\u0000\u0001\u0004\u0002\u0000\n\u0004\u0001\u0000\u0001\u0004\u0003\u0000\u0005\u0004\u0006\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0007\u0004\u0003\u0000\u0003\u0004\u0005\u0000\u0005\u0004\u0016\u0000$\u0004\u0e81\u0000\u0003\u0004\u0019\u0000\t\u0004\u0007\u0000\u0005\u0004\u0002\u0000\u0005\u0004\u0004\u0000V\u0004\u0006\u0000\u0003\u0004\u0001\u0000_\u0004\u0005\u0000(\u0004\u0004\u0000^\u0004\u0011\u0000\u0018\u00048\u0000\u0010\u0004\u0200\u0000\u19b6\u0004J\u0000\u51a6\u0004Z\u0000\u048d\u0004\u0773\u0000\u2ba4\u0004\u215c\u0000\u012e\u0004\u0002\u0000;\u0004\u0095\u0000\u0007\u0004\f\u0000\u0005\u0004\u0005\u0000\u0001\u0004\u0001\u0000\n\u0004\u0001\u0000\r\u0004\u0001\u0000\u0005\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0002\u0004\u0001\u0000l\u0004!\u0000\u016b\u0004\u0012\u0000@\u0004\u0002\u00006\u0004(\u0000\r\u00046\u0000\u0002\u0004\u0018\u0000\u0003\u0004\u0019\u0000\u0001\u0004\u0006\u0000\u0005\u0004\u0001\u0000\u0087\u0004\u0007\u0000\u0001\u0004\u001c\u0000\u001a\u0004\u0004\u0000\u0001\u0004\u0001\u0000\u001a\u0004\n\u0000Z\u0004\u0003\u0000\u0006\u0004\u0002\u0000\u0006\u0004\u0002\u0000\u0006\u0004\u0002\u0000\u0003\u0004\u0003\u0000\u0002\u0004\u0003\u0000\u0002\u0004\u0019\u0000";
    private static final char[] ZZ_CMAP = _JavaDocLexer.zzUnpackCMap("\t\u0000\u0001\u0002\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0001\u0012\u0000\u0001\u0002\u0002\u0000\u0001\u000b\u0001\u0004\u0003\u0000\u0001\t\u0001\n\u0001\u0007\u0001\u0000\u0001\f\u0001\u0005\u0001\u0003\u0001\u0006\n\u0003\u0001\u0005\u0001\u0000\u0001\u0012\u0001\u0000\u0001\u0013\u0001\u0000\u0001\r\u001a\u0004\u0001\b\u0001\u0000\u0001\b\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u000f\u000b\u0004\u0001\u0011\u0002\u0004\u0001\u000e\u0001\u0004\u0001\u0010\b\u0004\u0001\u0014\u0001\u0000\u0001\u0015$\u0000\u0004\u0004\u0004\u0000\u0001\u0004\n\u0000\u0001\u0004\u0004\u0000\u0001\u0004\u0005\u0000\u0017\u0004\u0001\u0000\u001f\u0004\u0001\u0000\u013f\u0004\u0019\u0000r\u0004\u0004\u0000\f\u0004\u000e\u0000\u0005\u0004\t\u0000\u0001\u0004\u008b\u0000\u0001\u0004\u000b\u0000\u0001\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0014\u0004\u0001\u0000,\u0004\u0001\u0000&\u0004\u0001\u0000\u0005\u0004\u0004\u0000\u0082\u0004\b\u0000E\u0004\u0001\u0000&\u0004\u0002\u0000\u0002\u0004\u0006\u0000\u0010\u0004!\u0000&\u0004\u0002\u0000\u0001\u0004\u0007\u0000'\u0004H\u0000\u001b\u0004\u0005\u0000\u0003\u0004.\u0000\u001a\u0004\u0005\u0000\u000b\u0004#\u0000\u0002\u0004\u0001\u0000c\u0004\u0001\u0000\u0001\u0004\u000f\u0000\u0002\u0004\u0007\u0000\u0002\u0004\n\u0000\u0003\u0004\u0002\u0000\u0001\u0004\u0010\u0000\u0001\u0004\u0001\u0000\u001e\u0004\u001d\u0000\u0003\u00040\u0000&\u0004\u000b\u0000\u0001\u0004\u0152\u00006\u0004\u0003\u0000\u0001\u0004\u0012\u0000\u0001\u0004\u0007\u0000\n\u0004#\u0000\b\u0004\u0002\u0000\u0002\u0004\u0002\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0003\u0000\u0004\u0004\u0003\u0000\u0001\u0004\u001e\u0000\u0002\u0004\u0001\u0000\u0003\u0004\u000e\u0000\u0004\u0004\u0011\u0000\u0006\u0004\u0004\u0000\u0002\u0004\u0002\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0002\u0004\u001f\u0000\u0004\u0004\u0001\u0000\u0001\u0004\u0013\u0000\u0003\u0004\u0010\u0000\t\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0005\u0004\u0003\u0000\u0001\u0004\u0012\u0000\u0001\u0004\u000f\u0000\u0002\u0004\u000f\u0000\u0001\u0004\u0013\u0000\b\u0004\u0002\u0000\u0002\u0004\u0002\u0000\u0016\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0005\u0004\u0003\u0000\u0001\u0004\u001e\u0000\u0002\u0004\u0001\u0000\u0003\u0004\u000f\u0000\u0001\u0004\u0011\u0000\u0001\u0004\u0001\u0000\u0006\u0004\u0003\u0000\u0003\u0004\u0001\u0000\u0004\u0004\u0003\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0002\u0004\u0003\u0000\u0002\u0004\u0003\u0000\u0003\u0004\u0003\u0000\b\u0004\u0001\u0000\u0003\u0004?\u0000\u0001\u0004\u000b\u0000\b\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0017\u0004\u0001\u0000\n\u0004\u0001\u0000\u0005\u0004&\u0000\u0002\u0004#\u0000\b\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0017\u0004\u0001\u0000\n\u0004\u0001\u0000\u0005\u0004\u0003\u0000\u0001\u0004 \u0000\u0001\u0004\u0001\u0000\u0002\u0004#\u0000\b\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0017\u0004\u0001\u0000\u0010\u0004&\u0000\u0002\u0004#\u0000\u0012\u0004\u0003\u0000\u0018\u0004\u0001\u0000\t\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0007\u0004:\u00000\u0004\u0001\u0000\u0002\u0004\u000b\u0000\b\u0004:\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0001\u0004\u0006\u0000\u0004\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0002\u0000\u0002\u0004\u0001\u0000\u0004\u0004\u0001\u0000\u0002\u0004\t\u0000\u0001\u0004\u0002\u0000\u0005\u0004\u0001\u0000\u0001\u0004\u0015\u0000\u0002\u0004\"\u0000\u0001\u0004?\u0000\b\u0004\u0001\u0000\"\u0004\u001d\u0000\u0004\u0004t\u0000\"\u0004\u0001\u0000\u0005\u0004\u0001\u0000\u0002\u0004%\u0000\u0006\u0004J\u0000&\u0004\n\u0000)\u0004\u0007\u0000Z\u0004\u0005\u0000D\u0004\u0005\u0000R\u0004\u0006\u0000\u0007\u0004\u0001\u0000?\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000'\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u001f\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0017\u0004\u0001\u0000\u001f\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0002\u0000\u0007\u0004\u0001\u0000'\u0004\u0001\u0000\u0013\u0004E\u0000U\u0004\f\u0000\u026c\u0004\u0002\u0000\b\u0004\n\u0000\u001a\u0004\u0005\u0000K\u0004\u0003\u0000\u0003\u0004\u000f\u0000\r\u0004\u0001\u0000\u0004\u0004\u000e\u0000\u0012\u0004\u000e\u0000\u0012\u0004\u000e\u0000\r\u0004\u0001\u0000\u0003\u0004\u000f\u00004\u0004#\u0000\u0001\u0004\u0003\u0000\u0002\u0004C\u0000X\u0004\b\u0000)\u0004W\u0000\u001d\u00043\u0000\u001e\u0004\u0002\u0000\u0005\u0004\u038b\u0000l\u0004\u0094\u0000\u009c\u0004\u0004\u0000Z\u0004\u0006\u0000\u0016\u0004\u0002\u0000\u0006\u0004\u0002\u0000&\u0004\u0002\u0000\u0006\u0004\u0002\u0000\b\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u001f\u0004\u0002\u00005\u0004\u0001\u0000\u0007\u0004\u0001\u0000\u0001\u0004\u0003\u0000\u0003\u0004\u0001\u0000\u0007\u0004\u0003\u0000\u0004\u0004\u0002\u0000\u0006\u0004\u0004\u0000\r\u0004\u0005\u0000\u0003\u0004\u0001\u0000\u0007\u0004B\u0000\u0002\u0004\u0013\u0000\u0001\u0004\u001c\u0000\u0001\u0004\r\u0000\u0001\u0004 \u0000\u0012\u0004P\u0000\u0001\u0004\u0004\u0000\u0001\u0004\u0002\u0000\n\u0004\u0001\u0000\u0001\u0004\u0003\u0000\u0005\u0004\u0006\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0004\u0004\u0001\u0000\u0003\u0004\u0001\u0000\u0007\u0004\u0003\u0000\u0003\u0004\u0005\u0000\u0005\u0004\u0016\u0000$\u0004\u0e81\u0000\u0003\u0004\u0019\u0000\t\u0004\u0007\u0000\u0005\u0004\u0002\u0000\u0005\u0004\u0004\u0000V\u0004\u0006\u0000\u0003\u0004\u0001\u0000_\u0004\u0005\u0000(\u0004\u0004\u0000^\u0004\u0011\u0000\u0018\u00048\u0000\u0010\u0004\u0200\u0000\u19b6\u0004J\u0000\u51a6\u0004Z\u0000\u048d\u0004\u0773\u0000\u2ba4\u0004\u215c\u0000\u012e\u0004\u0002\u0000;\u0004\u0095\u0000\u0007\u0004\f\u0000\u0005\u0004\u0005\u0000\u0001\u0004\u0001\u0000\n\u0004\u0001\u0000\r\u0004\u0001\u0000\u0005\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0002\u0004\u0001\u0000\u0002\u0004\u0001\u0000l\u0004!\u0000\u016b\u0004\u0012\u0000@\u0004\u0002\u00006\u0004(\u0000\r\u00046\u0000\u0002\u0004\u0018\u0000\u0003\u0004\u0019\u0000\u0001\u0004\u0006\u0000\u0005\u0004\u0001\u0000\u0087\u0004\u0007\u0000\u0001\u0004\u001c\u0000\u001a\u0004\u0004\u0000\u0001\u0004\u0001\u0000\u001a\u0004\n\u0000Z\u0004\u0003\u0000\u0006\u0004\u0002\u0000\u0006\u0004\u0002\u0000\u0006\u0004\u0002\u0000\u0003\u0004\u0003\u0000\u0002\u0004\u0003\u0000\u0002\u0004\u0019\u0000");
    private static final int[] ZZ_ACTION = _JavaDocLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\t\u0000\u0003\u0001\u0001\u0002\u0001\u0003\u0002\u0002\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\n\u0001\u0010\u0001\u0001\u0001\u0000\u0001\u0011\u0001\u0000\u0002\u0012\u0001\u0013\u0003\u0012\u0001\u0014";
    private static final int[] ZZ_ROWMAP = _JavaDocLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0016\u0000,\u0000B\u0000X\u0000n\u0000\u0084\u0000\u009a\u0000\u00b0\u0000\u00c6\u0000\u00dc\u0000\u00f2\u0000\u00c6\u0000\u0108\u0000\u00f2\u0000\u011e\u0000\u00c6\u0000\u00c6\u0000\u0134\u0000\u014a\u0000\u0160\u0000\u0176\u0000\u018c\u0000\u00c6\u0000\u00c6\u0000\u00c6\u0000\u00c6\u0000\u00c6\u0000\u01a2\u0000\u00c6\u0000\u011e\u0000\u01b8\u0000\u00c6\u0000\u00f2\u0000\u01ce\u0000\u01e4\u0000\u01fa\u0000\u0210\u0000\u0226\u0000\u023c\u0000\u01ce";
    private static final int[] ZZ_TRANS = _JavaDocLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0006\n\u0001\u000b\u0001\f\u000e\n\u0001\r\u0002\u000e\u0004\r\u0001\u000f\u0005\r\u0001\u0010\u0006\r\u0001\u0011\u0001\u0012\u0001\r\u0001\u000e\u0001\u0013\u0004\r\u0001\u000f\f\r\u0001\u0011\u0001\u0012\u0001\n\u0002\u0014\u0004\n\u0001\f\r\n\u0001\u0012\u0001\n\u0002\u0015\u0004\n\u0001\f\u000e\n\u0001\r\u0002\u0016\u0002\u0017\u0002\r\u0001\u000f\u0001\u0017\u0001\u0018\u0001\r\u0001\u0019\u0001\u001a\u0001\r\u0004\u0017\u0001\u001b\u0002\r\u0001\u0012\u0001\n\u0002\u000e\u0002\u0017\u0002\n\u0001\f\u0001\u0017\u0001\n\u0001\u001c\u0001\n\u0001\u001a\u0001\n\u0004\u0017\b\n\u0001\u001d\u0002\n\u0001\f\u0006\n\u0004\u001d\u0001\n\u0001\u001e\t\n\u0001\f\u0005\n\u0001\u001f\b\n\u001d\u0000\u0001 \u0014\u0000\u0001!\u0001\"\u000f\u0000\u0002\u000e\u0017\u0000\u0001#\t\u0000\u0001$\u0003#\u0006\u0000\u0001\u0013\u0014\u0000\u0002\u0014\u0014\u0000\u0002\u0015\u0014\u0000\u0002\u0016\u0016\u0000\u0002\u0017\u0003\u0000\u0001\u0017\u0005\u0000\u0004\u0017\u0007\u0000\u0003\u001d\b\u0000\u0004\u001d\u000b\u0000\u0001%\u0011\u0000\u0003#\b\u0000\u0004#\u0007\u0000\u0003#\b\u0000\u0001#\u0001&\u0002#\n\u0000\u0001!\u0012\u0000\u0003#\b\u0000\u0002#\u0001'\u0001#\u0007\u0000\u0003#\b\u0000\u0001#\u0001(\u0002#\u0007\u0000\u0003#\b\u0000\u0003#\u0001)\u0004\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final char[] EMPTY_BUFFER = new char[0];
    private static final int YYEOF = -1;
    private static Reader zzReader = null;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _JavaDocLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\t\u0000\u0001\t\u0002\u0001\u0001\t\u0003\u0001\u0002\t\u0005\u0001\u0005\t\u0001\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0000\u0007\u0001";
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private char[] zzBufferArray;
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private boolean myJdk15Enabled;
    private DocCommentTokenTypes myTokenTypes;

    private static int[] zzUnpackAction() {
        int[] result = new int[41];
        int offset = 0;
        offset = _JavaDocLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[41];
        int offset = 0;
        offset = _JavaDocLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[594];
        int offset = 0;
        offset = _JavaDocLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[41];
        int offset = 0;
        offset = _JavaDocLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public _JavaDocLexer(boolean isJdk15Enabled, DocCommentTokenTypes tokenTypes) {
        this((Reader)null);
        this.myJdk15Enabled = isJdk15Enabled;
        this.myTokenTypes = tokenTypes;
    }

    public boolean checkAhead(char c) {
        if (this.zzMarkedPos >= this.zzBuffer.length()) {
            return false;
        }
        return this.zzBuffer.charAt(this.zzMarkedPos) == c;
    }

    public void goTo(int offset) {
        this.zzMarkedPos = this.zzStartRead = offset;
        this.zzCurrentPos = this.zzStartRead;
        this.zzPushbackPos = 0;
        this.zzAtEOF = offset < this.zzEndRead;
    }

    _JavaDocLexer(Reader in) {
        zzReader = in;
    }

    _JavaDocLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 1250) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    @Override
    public final int getTokenStart() {
        return this.zzStartRead;
    }

    @Override
    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    @Override
    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzBufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzPushbackPos = 0;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    @Override
    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBufferArray != null ? this.zzBufferArray[this.zzStartRead + pos] : this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
        }
    }

    @Override
    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        char[] zzBufferArrayL = this.zzBufferArray;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block42: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 12: {
                    return this.myTokenTypes.tagValueSharp();
                }
                case 21: {
                    continue block42;
                }
                case 16: {
                    this.yybegin(2);
                    return this.myTokenTypes.tagValueGT();
                }
                case 22: {
                    continue block42;
                }
                case 3: {
                    return this.myTokenTypes.space();
                }
                case 23: {
                    continue block42;
                }
                case 6: {
                    return this.myTokenTypes.commentData();
                }
                case 24: {
                    continue block42;
                }
                case 7: {
                    if (this.checkAhead('<') || this.checkAhead('\"')) {
                        this.yybegin(2);
                    } else if (this.checkAhead('{')) {
                        this.yybegin(2);
                    } else {
                        this.yybegin(5);
                    }
                    return this.myTokenTypes.space();
                }
                case 25: {
                    continue block42;
                }
                case 4: {
                    if (this.checkAhead('@')) {
                        this.yybegin(8);
                        return this.myTokenTypes.inlineTagStart();
                    }
                    this.yybegin(2);
                    return this.myTokenTypes.inlineTagStart();
                }
                case 26: {
                    continue block42;
                }
                case 5: {
                    this.yybegin(2);
                    return this.myTokenTypes.inlineTagEnd();
                }
                case 27: {
                    continue block42;
                }
                case 19: {
                    this.yybegin(1);
                    return this.myTokenTypes.commentStart();
                }
                case 28: {
                    continue block42;
                }
                case 8: {
                    this.yybegin(5);
                    return this.myTokenTypes.space();
                }
                case 29: {
                    continue block42;
                }
                case 14: {
                    if (this.myJdk15Enabled) {
                        this.yybegin(7);
                        return this.myTokenTypes.tagValueLT();
                    }
                    this.yybegin(2);
                    return this.myTokenTypes.commentData();
                }
                case 30: {
                    continue block42;
                }
                case 10: {
                    return this.myTokenTypes.tagValueToken();
                }
                case 31: {
                    continue block42;
                }
                case 18: {
                    this.yybegin(3);
                    return this.myTokenTypes.tagName();
                }
                case 32: {
                    continue block42;
                }
                case 9: {
                    this.yybegin(2);
                    return this.myTokenTypes.space();
                }
                case 33: {
                    continue block42;
                }
                case 20: {
                    this.yybegin(4);
                    return this.myTokenTypes.tagName();
                }
                case 34: {
                    continue block42;
                }
                case 1: {
                    return this.myTokenTypes.badCharacter();
                }
                case 35: {
                    continue block42;
                }
                case 15: {
                    this.yybegin(5);
                    return this.myTokenTypes.tagValueRParen();
                }
                case 36: {
                    continue block42;
                }
                case 11: {
                    this.yybegin(6);
                    return this.myTokenTypes.tagValueLParen();
                }
                case 37: {
                    continue block42;
                }
                case 13: {
                    return this.myTokenTypes.tagValueComma();
                }
                case 38: {
                    continue block42;
                }
                case 2: {
                    this.yybegin(2);
                    return this.myTokenTypes.commentData();
                }
                case 39: {
                    continue block42;
                }
                case 17: {
                    return this.myTokenTypes.commentEnd();
                }
                case 40: {
                    continue block42;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return null;
            }
            this.zzScanError(1);
        }
    }
}

