/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.ExpressionParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.lang.java.parser.StatementParser;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class DeclarationParser {
    private final ExpressionParser myExpressionParser;
    private final StatementParser myStatementParser;
    private final ReferenceParser myReferenceParser;
    private static final TokenSet AFTER_END_DECLARATION_SET = TokenSet.create(JavaElementType.FIELD, JavaElementType.METHOD);
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD);
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD);
    private static final String WHITESPACES = "\n\r \t";
    private static final String LINE_ENDS = "\n\r";

    public DeclarationParser() {
        this.myReferenceParser = new ReferenceParser(this);
        this.myExpressionParser = new ExpressionParser(this, this.myReferenceParser);
        this.myStatementParser = new StatementParser(this, this.myExpressionParser, this.myReferenceParser);
    }

    protected DeclarationParser(ReferenceParser referenceParser, ExpressionParser expressionParser, StatementParser statementParser) {
        this.myReferenceParser = referenceParser;
        this.myExpressionParser = expressionParser;
        this.myStatementParser = statementParser;
    }

    public ReferenceParser getReferenceParser() {
        return this.myReferenceParser;
    }

    public ExpressionParser getExpressionParser() {
        return this.myExpressionParser;
    }

    public StatementParser getStatementParser() {
        return this.myStatementParser;
    }

    public void parseClassBodyWithBraces(PsiBuilder builder, boolean isAnnotation, boolean isEnum) {
        assert (builder.getTokenType() == JavaTokenType.LBRACE) : builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder builderWrapper = JavaParserUtil.braceMatchingBuilder(builder);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
    }

    @Nullable
    public PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder, PsiBuilder.Marker declaration, boolean isAnnotation, Context context) {
        boolean isEnum;
        IElementType keywordTokenType = builder.getTokenType();
        assert (ElementType.CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder.advanceLexer();
        boolean bl = isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            declaration.drop();
            return null;
        }
        this.myReferenceParser.parseTypeParameters(builder);
        this.myReferenceParser.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_LIST, JavaTokenType.COMMA);
        this.myReferenceParser.parseReferenceList(builder, JavaTokenType.IMPLEMENTS_KEYWORD, JavaElementType.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            error.error(JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            this.parseClassBodyWithBraces(builder, isAnnotation, isEnum);
        }
        if (context == Context.FILE) {
            boolean declarationsAfterEnd = false;
            while (builder.getTokenType() != null && builder.getTokenType() != JavaTokenType.RBRACE) {
                PsiBuilder.Marker position = builder.mark();
                PsiBuilder.Marker extra = this.parse(builder, Context.CLASS);
                if (extra != null && AFTER_END_DECLARATION_SET.contains(JavaParserUtil.exprType(extra))) {
                    if (!declarationsAfterEnd) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.or.interface", new Object[0]), extra);
                    }
                    declarationsAfterEnd = true;
                    position.drop();
                    continue;
                }
                position.rollbackTo();
                break;
            }
            if (declarationsAfterEnd) {
                JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
            }
        }
        JavaParserUtil.done(declaration, JavaElementType.CLASS);
        return declaration;
    }

    private void parseEnumConstants(PsiBuilder builder) {
        while (builder.getTokenType() != null) {
            if (PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON)) {
                return;
            }
            if (builder.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || builder.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder);
            if (enumConstant == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA) || builder.getTokenType() == null || builder.getTokenType() == JavaTokenType.SEMICOLON) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma.or.semicolon", new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder) {
        PsiBuilder.Marker constant = builder.mark();
        this.parseModifierList(builder);
        if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.myExpressionParser.parseArgumentList(builder);
            } else {
                JavaParserUtil.emptyElement(builder, JavaElementType.EXPRESSION_LIST);
            }
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                PsiBuilder.Marker constantInit = builder.mark();
                this.parseClassBodyWithBraces(builder, false, false);
                JavaParserUtil.done(constantInit, JavaElementType.ENUM_CONSTANT_INITIALIZER);
            }
            JavaParserUtil.done(constant, JavaElementType.ENUM_CONSTANT);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder, boolean isAnnotation) {
        IElementType tokenType;
        Context context = isAnnotation ? Context.ANNOTATION_INTERFACE : Context.CLASS;
        PsiBuilder.Marker invalidElements = null;
        while ((tokenType = builder.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
                    invalidElements = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.parse(builder, context);
            if (declaration != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), declaration);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            if ((ref = this.myReferenceParser.parseJavaCodeReference(builder, true, true, false, false, false)) != null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(PsiBuilder builder, Context context) {
        PsiBuilder.Marker type;
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context == Context.FILE || context == Context.CODE_BLOCK) {
                return null;
            }
        } else if (tokenType == JavaTokenType.IDENTIFIER || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
            if (context == Context.FILE) {
                return null;
            }
        } else {
            if (tokenType instanceof ILazyParseableElementType) {
                builder.advanceLexer();
                return null;
            }
            if (!(ElementType.MODIFIER_BIT_SET.contains(tokenType) || ElementType.CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context != Context.CODE_BLOCK && tokenType == JavaTokenType.LT)) {
                return null;
            }
        }
        PsiBuilder.Marker declaration = builder.mark();
        int declarationStart = builder.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect(builder, JavaTokenType.AT)) {
            if (builder.getTokenType() == JavaTokenType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration, true, context);
                return result != null ? result : modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (ElementType.CLASS_KEYWORD_BIT_SET.contains(builder.getTokenType())) {
            PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration, false, context);
            return result != null ? result : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder.getTokenType() == JavaTokenType.LT) {
            typeParams = this.myReferenceParser.parseTypeParameters(builder);
        }
        if (context == Context.FILE) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.or.interface", new Object[0]), typeParams);
            declaration.drop();
            return modList;
        }
        if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(builder.getTokenType())) {
            type = this.parseTypeNotNull(builder);
        } else if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker idPos = builder.mark();
            type = this.parseTypeNotNull(builder);
            if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                if (context == Context.CODE_BLOCK) {
                    declaration.rollbackTo();
                    return null;
                }
                idPos.rollbackTo();
                if (typeParams == null) {
                    JavaParserUtil.emptyElement(builder, JavaElementType.TYPE_PARAMETER_LIST);
                }
                builder.advanceLexer();
                if (builder.getTokenType() != JavaTokenType.LPARENTH) {
                    declaration.rollbackTo();
                    return null;
                }
                return this.parseMethodFromLeftParenth(builder, declaration, false, true);
            }
            idPos.drop();
        } else {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                if (context == Context.CODE_BLOCK) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier.or.type", new Object[0]), typeParams);
                    declaration.drop();
                    return modList;
                }
                PsiBuilder.Marker codeBlock = this.myStatementParser.parseCodeBlock(builder);
                assert (codeBlock != null) : builder.getOriginalText();
                if (typeParams != null) {
                    PsiBuilder.Marker error = typeParams.precede();
                    error.errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), codeBlock);
                }
                JavaParserUtil.done(declaration, JavaElementType.CLASS_INITIALIZER);
                return declaration;
            }
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder.mark();
            error.error(JavaErrorMessages.message("expected.identifier.or.type", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (context == Context.CODE_BLOCK && ((Boolean)modListInfo.second).booleanValue()) {
                declaration.rollbackTo();
                return null;
            }
            if (typeParams != null) {
                typeParams.precede().errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), type);
            }
            builder.error(JavaErrorMessages.message("expected.identifier", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (builder.getTokenType() == JavaTokenType.LPARENTH && (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE)) {
            if (typeParams == null) {
                JavaParserUtil.emptyElement(type, JavaElementType.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder, declaration, context == Context.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), type);
        }
        return this.parseFieldOrLocalVariable(builder, declaration, declarationStart, context);
    }

    @NotNull
    private PsiBuilder.Marker parseTypeNotNull(PsiBuilder builder) {
        PsiBuilder.Marker type = this.myReferenceParser.parseType(builder, 5);
        assert (type != null) : builder.getOriginalText();
        PsiBuilder.Marker marker = type;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseTypeNotNull must not return null");
        }
        return marker;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder) {
        Pair<PsiBuilder.Marker, Boolean> pair = this.parseModifierList(builder, ElementType.MODIFIER_BIT_SET);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseModifierList must not return null");
        }
        return pair;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder, TokenSet modifiers) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder.mark();
        boolean isEmpty = true;
        while ((tokenType = builder.getTokenType()) != null) {
            if (modifiers.contains(tokenType)) {
                builder.advanceLexer();
                isEmpty = false;
                continue;
            }
            if (tokenType != JavaTokenType.AT || ElementType.KEYWORD_BIT_SET.contains(PsiBuilderUtil.nextTokenType(builder))) break;
            this.parseAnnotation(builder);
            isEmpty = false;
        }
        JavaParserUtil.done(modList, JavaElementType.MODIFIER_LIST);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(modList, isEmpty);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseModifierList must not return null");
        }
        return pair;
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno, boolean constructor) {
        IElementType tokenType;
        this.parseParameterList(builder);
        DeclarationParser.eatBrackets(builder, constructor, "expected.semicolon");
        if (JavaParserUtil.areTypeAnnotationsSupported(builder)) {
            PsiBuilder.Marker receiver = builder.mark();
            PsiBuilder.Marker annotations = this.parseAnnotations(builder);
            if (annotations != null) {
                JavaParserUtil.done(receiver, JavaElementType.METHOD_RECEIVER);
            } else {
                receiver.drop();
            }
        }
        this.myReferenceParser.parseReferenceList(builder, JavaTokenType.THROWS_KEYWORD, JavaElementType.THROWS_LIST, JavaTokenType.COMMA);
        if (anno && PsiBuilderUtil.expect(builder, JavaTokenType.DEFAULT_KEYWORD)) {
            this.parseAnnotationValue(builder);
        }
        if ((tokenType = builder.getTokenType()) != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            CharSequence text = builder.getOriginalText();
            block0: do {
                for (int i = builder.getCurrentOffset() - 1; i >= 0; --i) {
                    char ch = text.charAt(i);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect(builder, APPEND_TO_METHOD_SET));
            error.error(JavaErrorMessages.message("expected.lbrace.or.semicolon", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON) && builder.getTokenType() == JavaTokenType.LBRACE) {
            this.myStatementParser.parseCodeBlock(builder);
        }
        JavaParserUtil.done(declaration, anno ? JavaElementType.ANNOTATION_METHOD : JavaElementType.METHOD);
        return declaration;
    }

    @NotNull
    public PsiBuilder.Marker parseParameterList(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseElementList(builder, false);
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseParameterList must not return null");
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseResourceList(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseElementList(builder, true);
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseResourceList must not return null");
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseElementList(PsiBuilder builder, boolean resources) {
        assert (builder.getTokenType() == JavaTokenType.LPARENTH) : builder.getTokenType();
        PsiBuilder.Marker elementList = builder.mark();
        builder.advanceLexer();
        IElementType delimiter = resources ? JavaTokenType.SEMICOLON : JavaTokenType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        PsiBuilder.Marker invalidElements = null;
        String errorMessage = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null || tokenType == JavaTokenType.RPARENTH || tokenType == JavaTokenType.LBRACE) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier.or.type", new Object[0]));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage);
                }
                invalidElements = null;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = listElement = resources ? this.parseResource(builder) : this.parseParameter(builder, true, false);
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder.getTokenType() == delimiter) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message(noElementMsg, new Object[0]));
                    builder.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder.mark();
                errorMessage = JavaErrorMessages.message(delimiterExpected ? noDelimiterMsg : noElementMsg, new Object[0]);
            }
            if ((ref = this.myReferenceParser.parseJavaCodeReference(builder, true, true, false, false, false)) != null || builder.getTokenType() == null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage);
        }
        JavaParserUtil.done(elementList, resources ? JavaElementType.RESOURCE_LIST : JavaElementType.PARAMETER_LIST);
        PsiBuilder.Marker marker = elementList;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseElementList must not return null");
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType) {
        return this.parseListElement(builder, ellipsis, disjunctiveType, false);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder) {
        return this.parseListElement(builder, false, false, true);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean resource) {
        ReferenceParser.TypeInfo typeInfo;
        PsiBuilder.Marker param = builder.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        int flags = 5;
        if (ellipsis) {
            flags |= 2;
        }
        if (disjunctiveType) {
            flags |= 0x10;
        }
        if ((typeInfo = this.myReferenceParser.parseTypeInfo(builder, flags)) == null) {
            if (((Boolean)modListInfo.second).booleanValue()) {
                param.rollbackTo();
                return null;
            }
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
            JavaParserUtil.emptyElement(builder, JavaElementType.TYPE);
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            if (!resource) {
                DeclarationParser.eatBrackets(builder, typeInfo != null && typeInfo.isVarArg, "expected.rparen");
                JavaParserUtil.done(param, JavaElementType.PARAMETER);
                return param;
            }
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (JavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq") && this.myExpressionParser.parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        }
        JavaParserUtil.done(param, JavaElementType.RESOURCE_VARIABLE);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder, PsiBuilder.Marker declaration, int declarationStart, Context context) {
        boolean shouldRollback;
        IElementType varType;
        if (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE) {
            varType = JavaElementType.FIELD;
        } else if (context == Context.CODE_BLOCK) {
            varType = JavaElementType.LOCAL_VARIABLE;
        } else {
            declaration.drop();
            assert (false) : "Unexpected context: " + (Object)((Object)context);
            return null;
        }
        PsiBuilder.Marker variable = declaration;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!DeclarationParser.eatBrackets(builder, false, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.EQ)) {
                PsiBuilder.Marker expr = this.myExpressionParser.parse(builder);
                if (expr != null) {
                    shouldRollback = false;
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder.getTokenType() != JavaTokenType.COMMA) break;
            JavaParserUtil.done(variable, varType);
            builder.advanceLexer();
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable = builder.mark();
            builder.advanceLexer();
        }
        if (builder.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            builder.advanceLexer();
        } else {
            if (!builder.eof() && shouldRollback) {
                CharSequence text = builder.getOriginalText();
                int spaceEnd = builder.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward(text, spaceEnd - 1, WHITESPACES);
                int lineStart = CharArrayUtil.shiftBackwardUntil(text, spaceEnd, LINE_ENDS);
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward(text, lineStart, WHITESPACES);
                    declaration.rollbackTo();
                    return this.parse(JavaParserUtil.stoppingBuilder(builder, newBufferEnd), context);
                }
            }
            if (!unclosed) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
            }
        }
        if (openMarker) {
            JavaParserUtil.done(variable, varType);
        }
        return declaration;
    }

    private static boolean eatBrackets(PsiBuilder builder, boolean isError, @Nullable @PropertyKey(resourceBundle="messages.JavaErrorMessages") String errorKey) {
        if (builder.getTokenType() != JavaTokenType.LBRACKET) {
            return true;
        }
        PsiBuilder.Marker marker = isError ? builder.mark() : null;
        boolean result = true;
        while (PsiBuilderUtil.expect(builder, JavaTokenType.LBRACKET)) {
            if (PsiBuilderUtil.expect(builder, JavaTokenType.RBRACKET)) continue;
            if (!isError) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbracket", new Object[0]));
            }
            result = false;
            break;
        }
        if (marker != null) {
            marker.error(errorKey != null ? JavaErrorMessages.message(errorKey, new Object[0]) : null);
        }
        return result;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder) {
        PsiBuilder.Marker firstAnno = null;
        while (builder.getTokenType() == JavaTokenType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.AT) : builder.getTokenType();
        PsiBuilder.Marker anno = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker classRef = this.myReferenceParser.parseJavaCodeReference(builder, true, false, false, false, false);
        if (classRef == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.reference", new Object[0]));
        }
        this.parseAnnotationParameterList(builder);
        JavaParserUtil.done(anno, JavaElementType.ANNOTATION);
        PsiBuilder.Marker marker = anno;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseAnnotation must not return null");
        }
        return marker;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private PsiBuilder.Marker parseAnnotationParameterList(PsiBuilder builder) {
        PsiBuilder.Marker marker;
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH)) {
            JavaParserUtil.done(list, JavaElementType.ANNOTATION_PARAMETER_LIST);
            marker = list;
            if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseAnnotationParameterList must not return null");
            return marker;
        }
        if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            JavaParserUtil.done(list, JavaElementType.ANNOTATION_PARAMETER_LIST);
            marker = list;
            if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseAnnotationParameterList must not return null");
            return marker;
        }
        boolean isFirstParamNamed = this.parseAnnotationParameter(builder, true);
        boolean isFirstParamWarned = false;
        boolean afterBad = false;
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.parameter", new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) break;
            if (tokenType == JavaTokenType.COMMA) {
                PsiBuilder.Marker errorStart = builder.mark();
                PsiBuilder.Marker errorEnd = builder.mark();
                builder.advanceLexer();
                boolean hasParamName = this.parseAnnotationParameter(builder, false);
                if (!isFirstParamNamed && hasParamName && !isFirstParamWarned) {
                    errorStart.errorBefore(JavaErrorMessages.message("annotation.name.is.missing", new Object[0]), errorEnd);
                    isFirstParamWarned = true;
                } else {
                    errorStart.drop();
                }
                errorEnd.drop();
                continue;
            }
            if (!afterBad) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma.or.rparen", new Object[0]));
                builder.advanceLexer();
                afterBad = true;
                continue;
            }
            afterBad = false;
            this.parseAnnotationParameter(builder, false);
        }
        JavaParserUtil.done(list, JavaElementType.ANNOTATION_PARAMETER_LIST);
        marker = list;
        if (marker != null) return marker;
        throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseAnnotationParameterList must not return null");
    }

    private boolean parseAnnotationParameter(PsiBuilder builder, boolean mayBeSimple) {
        PsiBuilder.Marker pair = builder.mark();
        if (mayBeSimple) {
            this.parseAnnotationValue(builder);
            if (builder.getTokenType() != JavaTokenType.EQ) {
                JavaParserUtil.done(pair, JavaElementType.NAME_VALUE_PAIR);
                return false;
            }
            pair.rollbackTo();
            pair = builder.mark();
        }
        boolean hasName = JavaParserUtil.expectOrError(builder, JavaTokenType.IDENTIFIER, "expected.identifier");
        JavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq");
        this.parseAnnotationValue(builder);
        JavaParserUtil.done(pair, JavaElementType.NAME_VALUE_PAIR);
        return hasName;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotationValue(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        PsiBuilder.Marker result = tokenType == JavaTokenType.AT ? this.parseAnnotation(builder) : (tokenType == JavaTokenType.LBRACE ? this.parseAnnotationArrayInitializer(builder) : this.myExpressionParser.parseConditional(builder));
        if (result == null) {
            result = builder.mark();
            result.error(JavaErrorMessages.message("expected.value", new Object[0]));
        }
        PsiBuilder.Marker marker = result;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseAnnotationValue must not return null");
        }
        return marker;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private PsiBuilder.Marker parseAnnotationArrayInitializer(PsiBuilder builder) {
        PsiBuilder.Marker marker;
        assert (builder.getTokenType() == JavaTokenType.LBRACE) : builder.getTokenType();
        PsiBuilder.Marker annoArray = builder.mark();
        builder.advanceLexer();
        if (PsiBuilderUtil.expect(builder, JavaTokenType.RBRACE)) {
            JavaParserUtil.done(annoArray, JavaElementType.ANNOTATION_ARRAY_INITIALIZER);
            marker = annoArray;
            if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseAnnotationArrayInitializer must not return null");
            return marker;
        }
        this.parseAnnotationValue(builder);
        boolean unclosed = false;
        while (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACE)) {
            if (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA)) {
                if (builder.getTokenType() == JavaTokenType.RBRACE) continue;
                this.parseAnnotationValue(builder);
                continue;
            }
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
            unclosed = true;
            break;
        }
        JavaParserUtil.done(annoArray, JavaElementType.ANNOTATION_ARRAY_INITIALIZER);
        if (unclosed) {
            annoArray.setCustomEdgeTokenBinders(null, JavaParserUtil.GREEDY_RIGHT_EDGE_PROCESSOR);
        }
        if ((marker = annoArray) != null) return marker;
        throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/DeclarationParser.parseAnnotationArrayInitializer must not return null");
    }

    public static enum Context {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE;

    }
}

