/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderUtil {
    private PsiBuilderUtil() {
    }

    @Nullable
    public static IElementType nextTokenType(PsiBuilder builder) {
        if (builder.getTokenType() == null) {
            return null;
        }
        PsiBuilder.Marker sp = builder.mark();
        builder.advanceLexer();
        IElementType result = builder.getTokenType();
        sp.rollbackTo();
        return result;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType ... tokenTypes) {
        int i;
        if (tokenTypes.length == 0) {
            return true;
        }
        if (!tokenTypes[0].equals(builder.getTokenType())) {
            return false;
        }
        if (tokenTypes.length == 1) {
            return true;
        }
        PsiBuilder.Marker rb = builder.mark();
        builder.advanceLexer();
        for (i = 1; !builder.eof() && i < tokenTypes.length && tokenTypes[i].equals(builder.getTokenType()); ++i) {
            builder.advanceLexer();
        }
        rb.rollbackTo();
        return i == tokenTypes.length;
    }

    public static void advance(PsiBuilder builder, int count) {
        for (int i = 0; i < count && !builder.eof(); ++i) {
            builder.getTokenType();
            builder.advanceLexer();
        }
    }

    public static boolean expect(PsiBuilder builder, IElementType expectedType) {
        if (builder.getTokenType() == expectedType) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean expect(PsiBuilder builder, TokenSet expectedTypes) {
        if (expectedTypes.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static void drop(PsiBuilder.Marker ... markers) {
        for (PsiBuilder.Marker marker : markers) {
            if (marker == null) continue;
            marker.drop();
        }
    }
}

