/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.CodeFragmentElement;
import com.intellij.psi.impl.source.DummyHolderElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTFactory {
    private static final CharTable WHITESPACES = new CharTableImpl();

    @Nullable
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        return null;
    }

    @Nullable
    public CompositeElement createComposite(IElementType type) {
        return null;
    }

    @Nullable
    public LeafElement createLeaf(IElementType type, CharSequence text) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LazyParseableElement lazy(@NotNull ILazyParseableElementType type, CharSequence text) {
        LazyParseableElement lazyParseableElement;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ASTFactory.lazy must not be null");
        }
        ASTNode node = type.createNode(text);
        if (node != null) {
            lazyParseableElement = (LazyParseableElement)node;
            if (lazyParseableElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.lazy must not return null");
            return lazyParseableElement;
        }
        if (type == TokenType.CODE_FRAGMENT) {
            lazyParseableElement = new CodeFragmentElement(null);
            if (lazyParseableElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.lazy must not return null");
            return lazyParseableElement;
        }
        if (type == TokenType.DUMMY_HOLDER) {
            lazyParseableElement = new DummyHolderElement(text);
            if (lazyParseableElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.lazy must not return null");
            return lazyParseableElement;
        }
        LazyParseableElement customLazy = ASTFactory.factory(type).createLazy(type, text);
        lazyParseableElement = customLazy != null ? customLazy : DefaultFactoryHolder.DEFAULT.createLazy(type, text);
        if (lazyParseableElement != null) return lazyParseableElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.lazy must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static CompositeElement composite(@NotNull IElementType type) {
        CompositeElement compositeElement;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ASTFactory.composite must not be null");
        }
        if (type instanceof ICompositeElementType) {
            compositeElement = (CompositeElement)((ICompositeElementType)((Object)type)).createCompositeNode();
            if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.composite must not return null");
            return compositeElement;
        }
        CompositeElement customComposite = ASTFactory.factory(type).createComposite(type);
        compositeElement = customComposite != null ? customComposite : DefaultFactoryHolder.DEFAULT.createComposite(type);
        if (compositeElement != null) return compositeElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.composite must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LeafElement leaf(@NotNull IElementType type, CharSequence text) {
        LeafElement leafElement;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ASTFactory.leaf must not be null");
        }
        if (type == TokenType.WHITE_SPACE) {
            leafElement = new PsiWhiteSpaceImpl(text);
            if (leafElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.leaf must not return null");
            return leafElement;
        }
        if (type instanceof ILeafElementType) {
            leafElement = (LeafElement)((ILeafElementType)((Object)type)).createLeafNode(text);
            if (leafElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.leaf must not return null");
            return leafElement;
        }
        LeafElement customLeaf = ASTFactory.factory(type).createLeaf(type, text);
        leafElement = customLeaf != null ? customLeaf : DefaultFactoryHolder.DEFAULT.createLeaf(type, text);
        if (leafElement != null) return leafElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.leaf must not return null");
    }

    private static ASTFactory factory(IElementType type) {
        return (ASTFactory)LanguageASTFactory.INSTANCE.forLanguage(type.getLanguage());
    }

    @NotNull
    public static LeafElement whitespace(CharSequence text) {
        PsiWhiteSpaceImpl w = new PsiWhiteSpaceImpl(WHITESPACES.intern(text));
        CodeEditUtil.setNodeGenerated(w, true);
        PsiWhiteSpaceImpl psiWhiteSpaceImpl = w;
        if (psiWhiteSpaceImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ASTFactory.whitespace must not return null");
        }
        return psiWhiteSpaceImpl;
    }

    public static class DefaultFactoryHolder {
        public static final ASTFactory DEFAULT = DefaultFactoryHolder.def();

        private static ASTFactory def() {
            return (ASTFactory)((Object)ServiceManager.getService(DefaultASTFactory.class));
        }

        private DefaultFactoryHolder() {
        }
    }
}

