/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class RemoteServer {
    private static Remote ourRemote;
    private static Remote ourStub;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void start(Remote remote) throws Exception {
        Registry registry;
        RemoteServer.setupRMI();
        RemoteServer.banJNDI();
        if (ourRemote != null) {
            throw new AssertionError((Object)"Already started");
        }
        ourRemote = remote;
        int port = 0;
        Random random = new Random();
        while (true) {
            if ((port = random.nextInt(65535)) < 4000) {
                continue;
            }
            try {
                registry = LocateRegistry.createRegistry(port);
            }
            catch (ExportException ex) {
                continue;
            }
            break;
        }
        try {
            Object lock;
            ourStub = UnicastRemoteObject.exportObject(ourRemote, 0);
            String name = remote.getClass().getSimpleName() + Integer.toHexString(ourStub.hashCode());
            registry.bind(name, ourStub);
            System.out.println("Port/ID:" + port + "/" + name);
            Object object = lock = new Object();
            synchronized (object) {
                lock.wait();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void setupRMI() {
        System.setProperty("java.rmi.server.hostname", "localhost");
        System.setProperty("java.rmi.server.disableHttp", "true");
    }

    private static void banJNDI() {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", "com.intellij.execution.rmi.RemoteServer$Jndi");
        }
    }

    public static class Jndi
    implements InitialContextFactory,
    InvocationHandler {
        @Override
        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
            return (Context)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Context.class}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    }
}

