/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Processor;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class UnixProcessManager {
    public static final int SIGINT = 2;
    public static final int SIGKILL = 9;
    public static final int SIGCONT = 19;
    private static CLib C_LIB;
    private static final ProcessKiller UNIX_KILLER;

    private UnixProcessManager() {
    }

    public static int getProcessPid() {
        UnixProcessManager.checkCLib();
        return C_LIB.getpid();
    }

    public static int getProcessPid(Process process) {
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            return ((Number)f.get(process)).intValue();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("system is not unix", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("system is not unix", e);
        }
    }

    public static void sendSignal(Process process, int signal) {
        int process_pid = UnixProcessManager.getProcessPid(process);
        UnixProcessManager.sendSignal(process_pid, signal);
    }

    public static void sendSignal(int pid, int signal) {
        UnixProcessManager.checkCLib();
        C_LIB.kill(pid, signal);
    }

    private static void checkCLib() {
        if (C_LIB == null) {
            throw new IllegalStateException("System is not unix(couldn't load c library)");
        }
    }

    public static boolean sendSigIntToProcessTree(Process process) {
        return UnixProcessManager.sendSignalToProcessTree(process, 2);
    }

    public static boolean sendSigKillToProcessTree(Process process) {
        return UnixProcessManager.sendSignalToProcessTree(process, 9);
    }

    public static boolean sendSignalToProcessTree(Process process, int signal) {
        boolean result;
        UnixProcessManager.checkCLib();
        final int our_pid = C_LIB.getpid();
        final int process_pid = UnixProcessManager.getProcessPid(process);
        final Ref foundPid = new Ref();
        final ProcessInfo processInfo = new ProcessInfo();
        final ArrayList childrenPids = new ArrayList();
        UnixProcessManager.processPSOutput(UnixProcessManager.getPSCmd(false), new Processor<String>(){

            @Override
            public boolean process(String s) {
                StringTokenizer st = new StringTokenizer(s, " ");
                int parent_pid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                processInfo.register(pid, parent_pid);
                if (parent_pid == process_pid) {
                    childrenPids.add(pid);
                }
                if (pid == process_pid) {
                    if (parent_pid == our_pid) {
                        foundPid.set(pid);
                    } else {
                        throw new IllegalStateException("process is not our child");
                    }
                }
                return false;
            }
        });
        if (!foundPid.isNull()) {
            processInfo.killProcTree((Integer)foundPid.get(), signal, UNIX_KILLER);
            result = true;
        } else {
            for (Integer pid : childrenPids) {
                processInfo.killProcTree(pid, signal, UNIX_KILLER);
            }
            result = false;
        }
        return result;
    }

    public static void processPSOutput(String[] cmd, Processor<String> processor) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            UnixProcessManager.processPSOutput(p, processor);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPSOutput(Process psProcess, Processor<String> processor) throws IOException {
        BufferedReader stdOutput = new BufferedReader(new InputStreamReader(psProcess.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(psProcess.getErrorStream()));
        try {
            String s;
            stdOutput.readLine();
            while ((s = stdOutput.readLine()) != null) {
                processor.process(s);
            }
            StringBuilder errorStr = new StringBuilder();
            while ((s = stdError.readLine()) != null) {
                errorStr.append(s).append("\n");
            }
            if (errorStr.length() > 0) {
                throw new IllegalStateException("error:" + errorStr.toString());
            }
        }
        finally {
            stdOutput.close();
            stdError.close();
        }
    }

    public static String[] getPSCmd(boolean commandLineOnly) {
        return UnixProcessManager.getPSCmd(commandLineOnly, false);
    }

    public static String[] getPSCmd(boolean commandLineOnly, boolean isShortenCommand) {
        String psCommand = "/bin/ps";
        if (!new File(psCommand).isFile()) {
            psCommand = "ps";
        }
        if (SystemInfo.isLinux) {
            return new String[]{psCommand, "-e", "--format", commandLineOnly ? "%a" : "%P%p%a"};
        }
        if (SystemInfo.isMac || SystemInfo.isFreeBSD) {
            String command = isShortenCommand ? "comm" : "command";
            return new String[]{psCommand, "-ax", "-o", commandLineOnly ? command : "ppid,pid," + command};
        }
        throw new IllegalStateException(System.getProperty("os.name") + " is not supported.");
    }

    @NotNull
    public static String readProcEnviron(int child_pid) throws FileNotFoundException {
        StringBuffer res = new StringBuffer();
        Scanner s = new Scanner(new File("/proc/" + child_pid + "/environ"));
        while (s.hasNextLine()) {
            res.append(s).append("\n");
        }
        String string = res.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/process/UnixProcessManager.readProcEnviron must not return null");
        }
        return string;
    }

    static {
        try {
            if (!Platform.isWindows()) {
                C_LIB = (CLib)Native.loadLibrary((String)"c", CLib.class);
            }
        }
        catch (Exception e) {
            C_LIB = null;
        }
        UNIX_KILLER = new ProcessKiller(){

            @Override
            public void kill(int pid, int signal) {
                UnixProcessManager.sendSignal(pid, signal);
            }
        };
    }

    public static interface ProcessKiller {
        public void kill(int var1, int var2);
    }

    public static class ProcessInfo {
        private Map<Integer, List<Integer>> BY_PARENT = new TreeMap<Integer, List<Integer>>();

        public void register(Integer pid, Integer parentPid) {
            List<Integer> children = this.BY_PARENT.get(parentPid);
            if (children == null) {
                children = new LinkedList<Integer>();
            }
            children.add(pid);
            this.BY_PARENT.put(parentPid, children);
        }

        public void killProcTree(int pid, int signal, ProcessKiller killer) {
            List<Integer> children = this.BY_PARENT.get(pid);
            if (children != null) {
                for (int child : children) {
                    this.killProcTree(child, signal, killer);
                }
            }
            killer.kill(pid, signal);
        }
    }

    public static interface CLib
    extends Library {
        public int getpid();

        public int kill(int var1, int var2);
    }
}

