/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreEnvironment;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.CoreJavaPsiImplementationHelper;
import com.intellij.core.CoreLanguageLevelProjectExtension;
import com.intellij.core.CorePsiPackageImplementationHelper;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProviderFactory;
import com.intellij.psi.EmptySubstitutor;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.compiled.ClassFileStubBuilder;
import com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import com.intellij.psi.impl.compiled.DefaultClsStubBuilderFactory;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import com.intellij.psi.impl.source.tree.CoreJavaASTFactory;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import java.io.File;

public class JavaCoreEnvironment
extends CoreEnvironment {
    private final CoreJavaFileManager myFileManager;

    public JavaCoreEnvironment(Disposable parentDisposable) {
        super(parentDisposable);
        this.registerFileType(JavaClassFileType.INSTANCE, "class");
        this.addExplicitExtension(FileTypeFileViewProviders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileViewProviderFactory());
        this.addExplicitExtension(BinaryFileStubBuilders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileStubBuilder());
        this.registerFileType(JavaFileType.INSTANCE, "java");
        this.addExplicitExtension(LanguageASTFactory.INSTANCE, JavaLanguage.INSTANCE, new CoreJavaASTFactory());
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, JavaLanguage.INSTANCE, new JavaParserDefinition());
        this.registerProjectExtensionPoint(PsiElementFinder.EP_NAME, PsiElementFinder.class);
        this.registerExtensionPoint(Extensions.getRootArea(), ClsStubBuilderFactory.EP_NAME, ClsStubBuilderFactory.class);
        this.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        this.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        this.addExtension(ClsStubBuilderFactory.EP_NAME, new DefaultClsStubBuilderFactory());
        this.myApplication.registerService(PsiPackageImplementationHelper.class, new CorePsiPackageImplementationHelper());
        this.myFileManager = new CoreJavaFileManager(this.myPsiManager, this.getLocalFileSystem(), this.myJarFileSystem);
        this.myProject.registerService(PsiElementFactory.class, new PsiElementFactoryImpl(this.myPsiManager));
        this.myProject.registerService(JavaPsiImplementationHelper.class, new CoreJavaPsiImplementationHelper());
        this.myProject.registerService(PsiResolveHelper.class, new PsiResolveHelperImpl(this.myPsiManager));
        this.myProject.registerService(LanguageLevelProjectExtension.class, new CoreLanguageLevelProjectExtension());
        this.myProject.registerService(PackageIndex.class, this.myFileManager);
        this.myProject.registerService(JavaResolveCache.class, new JavaResolveCache(null));
        JavaPsiFacadeImpl javaPsiFacade = new JavaPsiFacadeImpl(this.myProject, this.myPsiManager, this.myFileManager, null);
        this.myProject.registerService(CoreJavaFileManager.class, this.myFileManager);
        this.registerComponentInstance(this.myProject.getPicoContainer(), JavaPsiFacade.class, javaPsiFacade);
        this.myProject.registerService(JavaPsiFacade.class, javaPsiFacade);
        this.myApplication.registerService(EmptySubstitutor.class, new EmptySubstitutorImpl());
        this.myApplication.registerService(JavaDirectoryService.class, new CoreJavaDirectoryService());
    }

    public void addToClasspath(File path) {
        VirtualFile root;
        VirtualFile virtualFile = root = path.isFile() ? this.myJarFileSystem.findFileByPath(path + "!/") : this.getLocalFileSystem().findFileByPath(path.getPath());
        if (root == null) {
            throw new IllegalArgumentException("trying to add non-existing file to classpath: " + path);
        }
        this.myFileManager.addToClasspath(path);
        this.myFileIndexFacade.addLibraryRoot(root);
    }
}

