/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import org.jetbrains.annotations.NotNull;

public class CoreProjectScopeBuilder
extends ProjectScopeBuilder {
    private final Project myProject;
    private final FileIndexFacade myFileIndexFacade;
    private final CoreLibrariesScope myLibrariesScope;

    public CoreProjectScopeBuilder(Project project, FileIndexFacade fileIndexFacade) {
        this.myFileIndexFacade = fileIndexFacade;
        this.myProject = project;
        this.myLibrariesScope = new CoreLibrariesScope();
    }

    @Override
    public GlobalSearchScope buildLibrariesScope() {
        return this.myLibrariesScope;
    }

    @Override
    public GlobalSearchScope buildAllScope() {
        return new EverythingGlobalScope();
    }

    @Override
    public GlobalSearchScope buildProjectScope() {
        return new ProjectScopeImpl(this.myProject, this.myFileIndexFacade);
    }

    @Override
    public GlobalSearchScope buildContentScope() {
        return new ContentSearchScope(this.myFileIndexFacade);
    }

    public static class ContentSearchScope
    extends GlobalSearchScope {
        private final FileIndexFacade myFileIndexFacade;

        public ContentSearchScope(FileIndexFacade fileIndexFacade) {
            this.myFileIndexFacade = fileIndexFacade;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myFileIndexFacade.isInContent(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope.isSearchInModuleContent must not be null");
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private class CoreLibrariesScope
    extends GlobalSearchScope {
        private CoreLibrariesScope() {
        }

        @Override
        public boolean contains(VirtualFile file) {
            return CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibraryClasses(file) || CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibrarySource(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

