/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.buildtools.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.K2JVMCompileEnvironmentConfiguration;
import org.jetbrains.jet.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;

public class BytecodeCompiler {
    private List<CompilerPlugin> compilerPlugins = new ArrayList<CompilerPlugin>();

    private K2JVMCompileEnvironmentConfiguration env(String stdlib, String[] classpath) {
        CompilerDependencies dependencies = CompilerDependencies.compilerDependenciesForProduction(CompilerSpecialMode.REGULAR);
        JetCoreEnvironment environment = new JetCoreEnvironment(CompileEnvironmentUtil.createMockDisposable(), dependencies);
        K2JVMCompileEnvironmentConfiguration env = new K2JVMCompileEnvironmentConfiguration(environment, MessageCollector.PLAIN_TEXT_TO_SYSTEM_ERR, false, Collections.<String>emptyList());
        if (stdlib != null && stdlib.trim().length() > 0) {
            File file = new File(stdlib);
            CompileEnvironmentUtil.addToClasspath(env.getEnvironment(), file);
        }
        if (classpath != null && classpath.length > 0) {
            CompileEnvironmentUtil.addToClasspath(env.getEnvironment(), classpath);
        }
        env.getCompilerPlugins().addAll(this.getCompilerPlugins());
        return env;
    }

    private static String errorMessage(@NotNull String source, boolean exceptionThrown) {
        return String.format("[%s] compilation failed" + (exceptionThrown ? "" : ", see \"ERROR:\" messages above for more details."), new File(source).getAbsolutePath());
    }

    public void sourcesToDir(@NotNull String src, @NotNull String output, @Nullable String stdlib, @Nullable String[] classpath) {
        try {
            boolean success = KotlinToJVMBytecodeCompiler.compileBunchOfSources(this.env(stdlib, classpath), Collections.singletonList(src), null, output, false, true);
            if (!success) {
                throw new CompileEnvironmentException(BytecodeCompiler.errorMessage(src, false));
            }
        }
        catch (Exception e) {
            throw new CompileEnvironmentException(BytecodeCompiler.errorMessage(src, true), e);
        }
    }

    public void sourcesToJar(@NotNull String src, @NotNull String jar, boolean includeRuntime, @Nullable String stdlib, @Nullable String[] classpath) {
        try {
            boolean success = KotlinToJVMBytecodeCompiler.compileBunchOfSources(this.env(stdlib, classpath), Collections.singletonList(src), jar, null, false, includeRuntime);
            if (!success) {
                throw new CompileEnvironmentException(BytecodeCompiler.errorMessage(src, false));
            }
        }
        catch (Exception e) {
            throw new CompileEnvironmentException(BytecodeCompiler.errorMessage(src, true), e);
        }
    }

    public void moduleToJar(@NotNull String module, @NotNull String jar, boolean includeRuntime, @Nullable String stdlib, @Nullable String[] classpath) {
        try {
            K2JVMCompileEnvironmentConfiguration env = this.env(stdlib, classpath);
            List<Module> modules = CompileEnvironmentUtil.loadModuleScript(module, env.getMessageCollector());
            File directory = new File(module).getParentFile();
            boolean success = KotlinToJVMBytecodeCompiler.compileModules(env, modules, directory, jar, null, includeRuntime);
            if (!success) {
                throw new CompileEnvironmentException(BytecodeCompiler.errorMessage(module, false));
            }
        }
        catch (Exception e) {
            throw new CompileEnvironmentException(BytecodeCompiler.errorMessage(module, true), e);
        }
    }

    public List<CompilerPlugin> getCompilerPlugins() {
        return this.compilerPlugins;
    }

    public void setCompilerPlugins(List<CompilerPlugin> compilerPlugins) {
        this.compilerPlugins = compilerPlugins;
    }
}

