/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.buildtools.core;

import org.jetbrains.jet.compiler.CompileEnvironment;
import org.jetbrains.jet.compiler.CompileEnvironmentException;

public class BytecodeCompiler {
    private CompileEnvironment env(String stdlib, String[] classpath) {
        CompileEnvironment env = new CompileEnvironment();
        if (stdlib != null && stdlib.trim().length() > 0) {
            env.setStdlib(stdlib);
        }
        if (classpath != null && classpath.length > 0) {
            env.addToClasspath(classpath);
        }
        return env;
    }

    private String compilationError(String source) {
        return String.format("[%s] compilation failed, see \"ERROR:\" messages above for more details.", source);
    }

    public void sourcesToDir(String src, String output, String stdlib, String[] classpath) {
        boolean success = this.env(stdlib, classpath).compileBunchOfSources(src, null, output, true);
        if (!success) {
            throw new CompileEnvironmentException(this.compilationError(src));
        }
    }

    public void sourcesToJar(String src, String jar, boolean includeRuntime, String stdlib, String[] classpath) {
        boolean success = this.env(stdlib, classpath).compileBunchOfSources(src, jar, null, includeRuntime);
        if (!success) {
            throw new CompileEnvironmentException(this.compilationError(src));
        }
    }

    public void moduleToJar(String module, String jar, boolean includeRuntime, String stdlib, String[] classpath) {
        this.env(stdlib, classpath).compileModuleScript(module, jar, null, includeRuntime);
    }
}

