/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.buildtools.ant;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jetbrains.jet.buildtools.core.BytecodeCompiler;
import org.jetbrains.jet.buildtools.core.Util;
import org.jetbrains.jet.compiler.CompileEnvironmentException;

public class BytecodeCompilerTask
extends Task {
    private File output;
    private File jar;
    private File stdlib;
    private File src;
    private File module;
    private Path compileClasspath;
    private boolean includeRuntime = true;

    public void setOutput(File output) {
        this.output = output;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setStdlib(File stdlib) {
        this.stdlib = stdlib;
    }

    public void setSrc(File src) {
        this.src = src;
    }

    public void setModule(File module) {
        this.module = module;
    }

    public void setIncludeRuntime(boolean includeRuntime) {
        this.includeRuntime = includeRuntime;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public void setClasspathRef(Reference ref) {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        this.compileClasspath.createPath().setRefid(ref);
    }

    public void addConfiguredClasspath(Path classpath) {
        this.setClasspath(classpath);
    }

    public void execute() {
        String[] classpath;
        BytecodeCompiler compiler = new BytecodeCompiler();
        String stdlibPath = this.stdlib != null ? Util.getPath(this.stdlib) : null;
        String[] stringArray = classpath = this.compileClasspath != null ? this.compileClasspath.list() : null;
        if (this.src != null) {
            if (this.output == null && this.jar == null) {
                throw new CompileEnvironmentException("\"output\" or \"jar\" should be specified");
            }
            String source = Util.getPath(this.src);
            String destination = Util.getPath(this.output != null ? this.output : this.jar);
            this.log(String.format("Compiling [%s] => [%s]", source, destination));
            if (this.output != null) {
                compiler.sourcesToDir(source, destination, stdlibPath, classpath);
            } else {
                compiler.sourcesToJar(source, destination, this.includeRuntime, stdlibPath, classpath);
            }
        } else if (this.module != null) {
            if (this.output != null) {
                throw new CompileEnvironmentException("Module compilation is only supported for jar destination");
            }
            String modulePath = Util.getPath(this.module);
            String jarPath = this.jar != null ? Util.getPath(this.jar) : null;
            this.log(jarPath != null ? String.format("Compiling [%s] => [%s]", modulePath, jarPath) : String.format("Compiling [%s]", modulePath));
            compiler.moduleToJar(modulePath, jarPath, this.includeRuntime, stdlibPath, classpath);
        } else {
            throw new CompileEnvironmentException("\"src\" or \"module\" should be specified");
        }
    }
}

