/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualifiedNamesUtil {
    public static boolean isSubpackageOf(@NotNull String subpackageName, @NotNull String packageName) {
        return subpackageName.equals(packageName) || subpackageName.startsWith(packageName) && subpackageName.charAt(packageName.length()) == '.';
    }

    public static boolean isShortNameForFQN(@NotNull String name, @NotNull String fqn) {
        return fqn.equals(name) || fqn.endsWith(name) && fqn.charAt(fqn.length() - name.length() - 1) == '.';
    }

    public static boolean isOneSegmentFQN(@NotNull String fqn) {
        if (fqn.isEmpty()) {
            return false;
        }
        return fqn.indexOf(46) < 0;
    }

    @NotNull
    public static String fqnToShortName(@NotNull String fqn) {
        return QualifiedNamesUtil.getLastSegment(fqn);
    }

    @NotNull
    public static String getLastSegment(@NotNull String fqn) {
        int lastDotIndex = fqn.lastIndexOf(46);
        return lastDotIndex != -1 ? fqn.substring(lastDotIndex + 1, fqn.length()) : fqn;
    }

    @NotNull
    public static String getFirstSegment(@NotNull String fqn) {
        int dotIndex = fqn.indexOf(46);
        return dotIndex != -1 ? fqn.substring(0, dotIndex) : fqn;
    }

    @NotNull
    public static String withoutLastSegment(@NotNull String fqn) {
        int lastDotIndex = fqn.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return fqn.substring(0, lastDotIndex);
        }
        return "";
    }

    public static String combine(@Nullable String first, @NotNull String second) {
        if (StringUtil.isEmpty((String)first)) {
            return second;
        }
        return first + "." + second;
    }

    @NotNull
    public static String tail(@NotNull String headFQN, @NotNull String fullFQN) {
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, headFQN)) {
            return fullFQN;
        }
        return fullFQN.equals(headFQN) ? "" : fullFQN.substring(headFQN.length() + 1);
    }

    @Nullable
    public static String plusOneSegment(String fqn, String fullFQN) {
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, fqn)) {
            return null;
        }
        String nextSegment = QualifiedNamesUtil.getFirstSegment(QualifiedNamesUtil.tail(fqn, fullFQN));
        if (QualifiedNamesUtil.isOneSegmentFQN(nextSegment)) {
            return QualifiedNamesUtil.combine(fqn, nextSegment);
        }
        return null;
    }

    public static boolean isImported(@NotNull String importPath, @NotNull String fqn) {
        if (importPath.endsWith("*")) {
            return QualifiedNamesUtil.withoutLastSegment(importPath).equals(QualifiedNamesUtil.withoutLastSegment(fqn));
        }
        return importPath.equals(fqn);
    }
}

