/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.resolve;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Renderer;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;

public class DescriptorRenderer
implements Renderer<DeclarationDescriptor> {
    public static final DescriptorRenderer TEXT = new DescriptorRenderer();
    public static final DescriptorRenderer HTML = new DescriptorRenderer(){

        @Override
        protected String escape(String s) {
            return s.replaceAll("<", "&lt;");
        }

        @Override
        public String renderKeyword(String keyword) {
            return "<b>" + keyword + "</b>";
        }

        @Override
        public String renderMessage(String s) {
            return "<i>" + s + "</i>";
        }
    };
    private final RenderDeclarationDescriptorVisitor rootVisitor = new RenderDeclarationDescriptorVisitor();
    private final DeclarationDescriptorVisitor<Void, StringBuilder> subVisitor = new RenderDeclarationDescriptorVisitor(){

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, StringBuilder builder) {
            this.renderTypeParameter(descriptor, builder);
            return null;
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, StringBuilder builder) {
            return super.visitVariableDescriptor((VariableDescriptor)descriptor, builder);
        }
    };

    private DescriptorRenderer() {
    }

    protected String renderKeyword(String keyword) {
        return keyword;
    }

    public String renderType(JetType type) {
        if (type == null) {
            return this.escape("[NULL]");
        }
        return this.escape(type.toString());
    }

    protected String escape(String s) {
        return s;
    }

    private String lt() {
        return this.escape("<");
    }

    @Override
    @NotNull
    public String render(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            return this.lt() + "null>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        declarationDescriptor.accept(this.rootVisitor, stringBuilder);
        this.appendDefinedIn(declarationDescriptor, stringBuilder);
        return stringBuilder.toString();
    }

    private void appendDefinedIn(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder) {
        stringBuilder.append(" ").append(this.renderMessage("defined in")).append(" ");
        DeclarationDescriptor containingDeclaration = declarationDescriptor.getContainingDeclaration();
        if (containingDeclaration != null) {
            this.renderFullyQualifiedName(containingDeclaration, stringBuilder);
        }
    }

    public String renderAsObject(@NotNull ClassDescriptor classDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        this.rootVisitor.renderClassDescriptor(classDescriptor, stringBuilder, "object");
        this.appendDefinedIn(classDescriptor, stringBuilder);
        return stringBuilder.toString();
    }

    public String renderMessage(String s) {
        return s;
    }

    private void renderFullyQualifiedName(DeclarationDescriptor descriptor, StringBuilder stringBuilder) {
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration != null) {
            this.renderFullyQualifiedName(containingDeclaration, stringBuilder);
            stringBuilder.append(".");
        }
        stringBuilder.append(this.escape(descriptor.getName()));
    }

    private class RenderDeclarationDescriptorVisitor
    extends DeclarationDescriptorVisitor<Void, StringBuilder> {
        private RenderDeclarationDescriptorVisitor() {
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.renderKeyword("value-parameter")).append(" ");
            if (descriptor.getVarargElementType() != null) {
                builder.append(DescriptorRenderer.this.renderKeyword("vararg")).append(" ");
            }
            return (Void)super.visitValueParameterDescriptor(descriptor, builder);
        }

        @Override
        public Void visitVariableDescriptor(VariableDescriptor descriptor, StringBuilder builder) {
            String typeString = this.renderPropertyPrefixAndComputeTypeString(builder, Collections.<TypeParameterDescriptor>emptyList(), ReceiverDescriptor.NO_RECEIVER, descriptor.getType());
            this.renderName(descriptor, builder);
            builder.append(" : ").append(DescriptorRenderer.this.escape(typeString));
            return (Void)super.visitVariableDescriptor(descriptor, builder);
        }

        private String renderPropertyPrefixAndComputeTypeString(@NotNull StringBuilder builder, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull ReceiverDescriptor receiver, @Nullable JetType outType) {
            String typeString = DescriptorRenderer.this.lt() + "no type>";
            if (outType != null) {
                builder.append(DescriptorRenderer.this.renderKeyword("var")).append(" ");
                typeString = DescriptorRenderer.this.renderType(outType);
            } else if (outType != null) {
                builder.append(DescriptorRenderer.this.renderKeyword("val")).append(" ");
                typeString = DescriptorRenderer.this.renderType(outType);
            }
            this.renderTypeParameters(typeParameters, builder);
            if (receiver.exists()) {
                builder.append(DescriptorRenderer.this.escape(DescriptorRenderer.this.renderType(receiver.getType()))).append(".");
            }
            return typeString;
        }

        @Override
        public Void visitPropertyDescriptor(PropertyDescriptor descriptor, StringBuilder builder) {
            this.renderModality(descriptor.getModality(), builder);
            String typeString = this.renderPropertyPrefixAndComputeTypeString(builder, descriptor.getTypeParameters(), descriptor.getReceiverParameter(), descriptor.getType());
            this.renderName(descriptor, builder);
            builder.append(" : ").append(DescriptorRenderer.this.escape(typeString));
            return null;
        }

        private void renderModality(Modality modality, StringBuilder builder) {
            switch (modality) {
                case FINAL: {
                    builder.append("final");
                    break;
                }
                case OPEN: {
                    builder.append("open");
                    break;
                }
                case ABSTRACT: {
                    builder.append("abstract");
                }
            }
            builder.append(" ");
        }

        @Override
        public Void visitFunctionDescriptor(FunctionDescriptor descriptor, StringBuilder builder) {
            this.renderModality(descriptor.getModality(), builder);
            builder.append(DescriptorRenderer.this.renderKeyword("fun")).append(" ");
            this.renderTypeParameters(descriptor.getTypeParameters(), builder);
            ReceiverDescriptor receiver = descriptor.getReceiverParameter();
            if (receiver.exists()) {
                builder.append(DescriptorRenderer.this.escape(DescriptorRenderer.this.renderType(receiver.getType()))).append(".");
            }
            this.renderName(descriptor, builder);
            this.renderValueParameters(descriptor, builder);
            builder.append(" : ").append(DescriptorRenderer.this.escape(DescriptorRenderer.this.renderType(descriptor.getReturnType())));
            return (Void)super.visitFunctionDescriptor(descriptor, builder);
        }

        private void renderValueParameters(FunctionDescriptor descriptor, StringBuilder builder) {
            builder.append("(");
            Iterator<ValueParameterDescriptor> iterator = descriptor.getValueParameters().iterator();
            while (iterator.hasNext()) {
                ValueParameterDescriptor parameterDescriptor = iterator.next();
                parameterDescriptor.accept(DescriptorRenderer.this.subVisitor, builder);
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(")");
        }

        @Override
        public Void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.renderKeyword("ctor")).append(" ");
            ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
            builder.append(classDescriptor.getName());
            this.renderTypeParameters(classDescriptor.getTypeConstructor().getParameters(), builder);
            this.renderValueParameters(constructorDescriptor, builder);
            return null;
        }

        private void renderTypeParameters(List<TypeParameterDescriptor> typeParameters, StringBuilder builder) {
            if (!typeParameters.isEmpty()) {
                builder.append(DescriptorRenderer.this.lt());
                Iterator<TypeParameterDescriptor> iterator = typeParameters.iterator();
                while (iterator.hasNext()) {
                    TypeParameterDescriptor typeParameterDescriptor = iterator.next();
                    typeParameterDescriptor.accept(DescriptorRenderer.this.subVisitor, builder);
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append("> ");
            }
        }

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.lt());
            this.renderTypeParameter(descriptor, builder);
            builder.append(">");
            return (Void)super.visitTypeParameterDescriptor(descriptor, builder);
        }

        @Override
        public Void visitNamespaceDescriptor(NamespaceDescriptor namespaceDescriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.renderKeyword(JetTokens.PACKAGE_KEYWORD.getValue())).append(" ");
            this.renderName(namespaceDescriptor, builder);
            return (Void)super.visitNamespaceDescriptor(namespaceDescriptor, builder);
        }

        @Override
        public Void visitClassDescriptor(ClassDescriptor descriptor, StringBuilder builder) {
            String keyword = descriptor.getKind() == ClassKind.TRAIT ? "trait" : "class";
            this.renderClassDescriptor(descriptor, builder, keyword);
            return (Void)super.visitClassDescriptor(descriptor, builder);
        }

        public void renderClassDescriptor(ClassDescriptor descriptor, StringBuilder builder, String keyword) {
            Collection<? extends JetType> supertypes;
            this.renderModality(descriptor.getModality(), builder);
            builder.append(DescriptorRenderer.this.renderKeyword(keyword)).append(" ");
            this.renderName(descriptor, builder);
            this.renderTypeParameters(descriptor.getTypeConstructor().getParameters(), builder);
            if (!descriptor.equals(JetStandardClasses.getNothing()) && !(supertypes = descriptor.getTypeConstructor().getSupertypes()).isEmpty()) {
                builder.append(" : ");
                Iterator<? extends JetType> iterator = supertypes.iterator();
                while (iterator.hasNext()) {
                    JetType supertype = iterator.next();
                    builder.append(DescriptorRenderer.this.renderType(supertype));
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
            }
        }

        protected void renderName(DeclarationDescriptor descriptor, StringBuilder stringBuilder) {
            stringBuilder.append(DescriptorRenderer.this.escape(descriptor.getName()));
        }

        protected void renderTypeParameter(TypeParameterDescriptor descriptor, StringBuilder builder) {
            JetType bound;
            if (!descriptor.isReified()) {
                builder.append(DescriptorRenderer.this.renderKeyword("erased")).append(" ");
            }
            this.renderName(descriptor, builder);
            if (!descriptor.getUpperBounds().isEmpty() && (bound = descriptor.getUpperBounds().iterator().next()) != JetStandardClasses.getDefaultBound()) {
                builder.append(" : ").append(DescriptorRenderer.this.renderType(bound));
                if (descriptor.getUpperBounds().size() > 1) {
                    builder.append(" (...)");
                }
            }
        }
    }
}

