/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.plugin.compiler;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtil {
    private PathUtil() {
    }

    public static File getDefaultCompilerPath() {
        File plugin_jar_path = new File(PathUtil.getJarPathForClass(PathUtil.class));
        if (!plugin_jar_path.exists()) {
            return null;
        }
        if (plugin_jar_path.getName().equals("kotlin-plugin.jar")) {
            File lib = plugin_jar_path.getParentFile();
            File pluginHome = lib.getParentFile();
            File answer = new File(pluginHome, "kotlinc");
            return answer.exists() ? answer : null;
        }
        if (plugin_jar_path.getName().equals("kotlin-compiler.jar")) {
            File lib = plugin_jar_path.getParentFile();
            File answer = lib.getParentFile();
            return answer.exists() ? answer : null;
        }
        File current = new File("").getAbsoluteFile();
        do {
            File atDevHome;
            if (!(atDevHome = new File(current, "dist/kotlinc")).exists()) continue;
            return atDevHome;
        } while ((current = current.getParentFile()) != null);
        return null;
    }

    @Nullable
    public static File getDefaultRuntimePath() {
        File compilerPath = PathUtil.getDefaultCompilerPath();
        if (compilerPath == null) {
            return null;
        }
        File answer = new File(compilerPath, "lib/kotlin-runtime.jar");
        return answer.exists() ? answer : null;
    }

    public static File getAltHeadersPath() {
        File compilerPath = PathUtil.getDefaultCompilerPath();
        if (compilerPath == null) {
            return null;
        }
        File answer = new File(compilerPath, "lib/alt");
        return answer.exists() ? answer : null;
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class aClass) {
        String resourceRoot = PathManager.getResourceRoot((Class)aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }

    public static List<VirtualFile> getAltHeadersRoots() {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        File alts = PathUtil.getAltHeadersPath();
        if (alts != null) {
            for (File root : alts.listFiles()) {
                VirtualFile jarRoot = VirtualFileManager.getInstance().findFileByUrl("jar://" + root.getPath() + "!/");
                roots.add(jarRoot);
            }
        }
        return roots;
    }
}

