/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.plugin;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;

public class JetMainDetector {
    private JetMainDetector() {
    }

    public static boolean hasMain(List<JetDeclaration> declarations) {
        for (JetDeclaration declaration : declarations) {
            if (!(declaration instanceof JetNamedFunction) || !JetMainDetector.isMain((JetNamedFunction)declaration)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMain(JetNamedFunction function) {
        JetTypeReference reference;
        List<JetParameter> parameters;
        return "main".equals(function.getName()) && (parameters = function.getValueParameters()).size() == 1 && (reference = parameters.get(0).getTypeReference()) != null && reference.getText().equals("Array<String>");
    }

    @Nullable
    public static JetFile getFileWithMain(@NotNull List<JetFile> files) {
        for (JetFile file : files) {
            if (!JetMainDetector.hasMain(file.getDeclarations())) continue;
            return file;
        }
        return null;
    }
}

