/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBindingPattern;
import org.jetbrains.jet.lang.psi.JetDecomposerPattern;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionPattern;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTuplePattern;
import org.jetbrains.jet.lang.psi.JetTuplePatternEntry;
import org.jetbrains.jet.lang.psi.JetTypePattern;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWildcardPattern;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;

public class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    protected PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    @Override
    public JetType visitIsExpression(JetIsExpression expression, ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression leftHandSide = expression.getLeftHandSide();
        JetType knownType = this.facade.safeGetType(leftHandSide, context.replaceScope(context.scope));
        JetPattern pattern = expression.getPattern();
        if (pattern != null) {
            WritableScopeImpl scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context).setDebugName("Scope extended in 'is'");
            DataFlowInfo newDataFlowInfo = this.checkPatternType(pattern, knownType, false, scopeToExtend, context, DataFlowValueFactory.INSTANCE.createDataFlowValue(leftHandSide, knownType, context.trace.getBindingContext()));
            context.patternsToDataFlowInfo.put(pattern, newDataFlowInfo);
            context.patternsToBoundVariableLists.put(pattern, scopeToExtend.getDeclaredVariables());
        }
        return DataFlowUtils.checkType(context.semanticServices.getStandardLibrary().getBooleanType(), expression, contextWithExpectedType);
    }

    @Override
    public JetType visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext context) {
        return this.visitWhenExpression(expression, context, false);
    }

    public JetType visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression subjectExpression = expression.getSubjectExpression();
        JetType subjectType = subjectExpression != null ? context.getServices().safeGetType(context.scope, subjectExpression, TypeUtils.NO_EXPECTED_TYPE) : ErrorUtils.createErrorType("Unknown type");
        DataFlowValue variableDescriptor = subjectExpression != null ? DataFlowValueFactory.INSTANCE.createDataFlowValue(subjectExpression, subjectType, context.trace.getBindingContext()) : DataFlowValue.NULL;
        HashSet expressionTypes = Sets.newHashSet();
        for (JetWhenEntry whenEntry : expression.getEntries()) {
            CoercionStrategy coercionStrategy;
            JetExpression bodyExpression;
            DataFlowInfo newDataFlowInfo;
            WritableScopeImpl scopeToExtend;
            JetWhenCondition[] conditions = whenEntry.getConditions();
            if (conditions.length == 1) {
                scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context).setDebugName("Scope extended in when entry");
                newDataFlowInfo = context.dataFlowInfo;
                JetWhenCondition condition = conditions[0];
                if (condition != null) {
                    newDataFlowInfo = this.checkWhenCondition(subjectExpression, subjectExpression == null, subjectType, condition, scopeToExtend, context, variableDescriptor);
                }
            } else {
                scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context);
                newDataFlowInfo = null;
                for (JetWhenCondition condition : conditions) {
                    DataFlowInfo dataFlowInfo = this.checkWhenCondition(subjectExpression, subjectExpression == null, subjectType, condition, ExpressionTypingUtils.newWritableScopeImpl(context), context, variableDescriptor);
                    newDataFlowInfo = newDataFlowInfo == null ? dataFlowInfo : newDataFlowInfo.or(dataFlowInfo);
                }
                newDataFlowInfo = newDataFlowInfo == null ? context.dataFlowInfo : newDataFlowInfo.and(context.dataFlowInfo);
            }
            if ((bodyExpression = whenEntry.getExpression()) == null) continue;
            ExpressionTypingContext newContext = contextWithExpectedType.replaceScope(scopeToExtend).replaceDataFlowInfo(newDataFlowInfo);
            CoercionStrategy coercionStrategy2 = coercionStrategy = isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
            JetType type = context.getServices().getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(bodyExpression), coercionStrategy, newContext);
            if (type == null) continue;
            expressionTypes.add(type);
        }
        if (!expressionTypes.isEmpty()) {
            return DataFlowUtils.checkImplicitCast(CommonSupertypes.commonSupertype(expressionTypes), expression, contextWithExpectedType, isStatement);
        }
        if (expression.getEntries().isEmpty()) {
            context.trace.report(Errors.NO_WHEN_ENTRIES.on(expression));
        }
        return null;
    }

    private DataFlowInfo checkWhenCondition(final @Nullable JetExpression subjectExpression, final boolean expectedCondition, final JetType subjectType, JetWhenCondition condition, final WritableScope scopeToExtend, final ExpressionTypingContext context, final DataFlowValue ... subjectVariables) {
        final DataFlowInfo[] newDataFlowInfo = new DataFlowInfo[]{context.dataFlowInfo};
        condition.accept(new JetVisitorVoid(){

            @Override
            public void visitWhenConditionInRange(JetWhenConditionInRange condition) {
                JetExpression rangeExpression = condition.getRangeExpression();
                if (rangeExpression == null) {
                    return;
                }
                if (expectedCondition) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                    PatternMatchingTypingVisitor.this.facade.getType(rangeExpression, context);
                    return;
                }
                if (!PatternMatchingTypingVisitor.this.facade.checkInExpression(condition, condition.getOperationReference(), subjectExpression, rangeExpression, context)) {
                    context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on(condition));
                }
            }

            @Override
            public void visitWhenConditionIsPattern(JetWhenConditionIsPattern condition) {
                JetPattern pattern = condition.getPattern();
                if (expectedCondition) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                }
                if (pattern != null) {
                    newDataFlowInfo[0] = PatternMatchingTypingVisitor.this.checkPatternType(pattern, subjectType, subjectExpression == null, scopeToExtend, context, subjectVariables);
                }
            }

            @Override
            public void visitWhenConditionWithExpression(JetWhenConditionWithExpression condition) {
                JetExpressionPattern pattern = condition.getPattern();
                if (pattern != null) {
                    newDataFlowInfo[0] = PatternMatchingTypingVisitor.this.checkPatternType(pattern, subjectType, subjectExpression == null, scopeToExtend, context, subjectVariables);
                }
            }

            @Override
            public void visitJetElement(JetElement element) {
                context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element, ((Object)((Object)this)).getClass().getCanonicalName()));
            }
        });
        return newDataFlowInfo[0];
    }

    private DataFlowInfo checkPatternType(@NotNull JetPattern pattern, final @NotNull JetType subjectType, final boolean conditionExpected, final @NotNull WritableScope scopeToExtend, final ExpressionTypingContext context, final DataFlowValue ... subjectVariables) {
        final Ref result = new Ref((Object)context.dataFlowInfo);
        pattern.accept(new JetVisitorVoid(){

            @Override
            public void visitTypePattern(JetTypePattern typePattern) {
                JetTypeReference typeReference = typePattern.getTypeReference();
                if (typeReference == null) {
                    return;
                }
                JetType type = context.getTypeResolver().resolveType(context.scope, typeReference);
                this.checkTypeCompatibility(type, subjectType, typePattern);
                result.set((Object)context.dataFlowInfo.establishSubtyping(subjectVariables, type));
            }

            @Override
            public void visitTuplePattern(JetTuplePattern pattern) {
                List<JetTuplePatternEntry> entries = pattern.getEntries();
                TypeConstructor typeConstructor = subjectType.getConstructor();
                if (!JetStandardClasses.getTuple(entries.size()).getTypeConstructor().equals(typeConstructor) || typeConstructor.getParameters().size() != entries.size()) {
                    context.trace.report(Errors.TYPE_MISMATCH_IN_TUPLE_PATTERN.on(pattern, subjectType, entries.size()));
                    return;
                }
                int entriesSize = entries.size();
                for (int i = 0; i < entriesSize; ++i) {
                    JetPattern entryPattern;
                    JetTuplePatternEntry entry = entries.get(i);
                    JetType type = subjectType.getArguments().get(i).getType();
                    ASTNode nameLabelNode = entry.getNameLabelNode();
                    if (nameLabelNode != null) {
                        context.trace.report(Errors.UNSUPPORTED.on(nameLabelNode.getPsi(), ((Object)((Object)this)).getClass().getCanonicalName()));
                    }
                    if ((entryPattern = entry.getPattern()) == null) continue;
                    result.set((Object)((DataFlowInfo)result.get()).and(PatternMatchingTypingVisitor.this.checkPatternType(entryPattern, type, false, scopeToExtend, context, new DataFlowValue[0])));
                }
            }

            @Override
            public void visitDecomposerPattern(JetDecomposerPattern pattern) {
                JetExpression decomposerExpression = pattern.getDecomposerExpression();
                if (decomposerExpression != null) {
                    TransientReceiver receiver = new TransientReceiver(subjectType);
                    JetType selectorReturnType = PatternMatchingTypingVisitor.this.facade.getSelectorReturnType(receiver, null, decomposerExpression, context);
                    if (pattern.getArgumentList() != null) {
                        result.set((Object)PatternMatchingTypingVisitor.this.checkPatternType(pattern.getArgumentList(), selectorReturnType == null ? ErrorUtils.createErrorType("No type") : selectorReturnType, false, scopeToExtend, context, new DataFlowValue[0]));
                    }
                }
            }

            @Override
            public void visitWildcardPattern(JetWildcardPattern pattern) {
            }

            @Override
            public void visitExpressionPattern(JetExpressionPattern pattern) {
                JetExpression expression = pattern.getExpression();
                if (expression == null) {
                    return;
                }
                JetType type = PatternMatchingTypingVisitor.this.facade.getType(expression, context.replaceScope(scopeToExtend));
                if (conditionExpected) {
                    JetType booleanType = context.semanticServices.getStandardLibrary().getBooleanType();
                    if (type != null && !context.semanticServices.getTypeChecker().equalTypes(booleanType, type)) {
                        context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(pattern, type));
                    }
                    return;
                }
                this.checkTypeCompatibility(type, subjectType, pattern);
            }

            @Override
            public void visitBindingPattern(JetBindingPattern pattern) {
                JetWhenCondition condition;
                JetProperty variableDeclaration = pattern.getVariableDeclaration();
                JetTypeReference propertyTypeRef = variableDeclaration.getPropertyTypeRef();
                JetType type = propertyTypeRef == null ? subjectType : context.getTypeResolver().resolveType(context.scope, propertyTypeRef);
                VariableDescriptorImpl variableDescriptor = context.getDescriptorResolver().resolveLocalVariableDescriptorWithType(context.scope.getContainingDeclaration(), variableDeclaration, type);
                scopeToExtend.addVariableDescriptor(variableDescriptor);
                if (propertyTypeRef != null && !context.semanticServices.getTypeChecker().isSubtypeOf(subjectType, type)) {
                    context.trace.report(Errors.TYPE_MISMATCH_IN_BINDING_PATTERN.on(propertyTypeRef, type, subjectType));
                }
                if ((condition = pattern.getCondition()) != null) {
                    int oldLength = subjectVariables.length;
                    DataFlowValue[] newSubjectVariables = new DataFlowValue[oldLength + 1];
                    System.arraycopy(subjectVariables, 0, newSubjectVariables, 0, oldLength);
                    newSubjectVariables[oldLength] = DataFlowValueFactory.INSTANCE.createDataFlowValue(variableDescriptor);
                    result.set((Object)PatternMatchingTypingVisitor.this.checkWhenCondition(null, false, subjectType, condition, scopeToExtend, context, newSubjectVariables));
                }
            }

            private void checkTypeCompatibility(@Nullable JetType type, @NotNull JetType subjectType2, @NotNull JetElement reportErrorOn) {
                if (type == null) {
                    return;
                }
                if (TypeUtils.intersect(context.semanticServices.getTypeChecker(), Sets.newHashSet((Object[])new JetType[]{type, subjectType2})) == null) {
                    context.trace.report(Errors.INCOMPATIBLE_TYPES.on(reportErrorOn, type, subjectType2));
                    return;
                }
                if (BasicExpressionTypingVisitor.isCastErased(subjectType2, type, context.semanticServices.getTypeChecker())) {
                    context.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on(reportErrorOn, type));
                }
            }

            @Override
            public void visitJetElement(JetElement element) {
                context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element, ((Object)((Object)this)).getClass().getCanonicalName()));
            }
        });
        return (DataFlowInfo)result.get();
    }
}

