/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class OperatorConventions {
    public static final String EQUALS = "equals";
    public static final String COMPARE_TO = "compareTo";
    public static final String CONTAINS = "contains";
    public static final String DOUBLE = "toDouble";
    public static final String FLOAT = "toFloat";
    public static final String LONG = "toLong";
    public static final String INT = "toInt";
    public static final String CHAR = "toChar";
    public static final String SHORT = "toShort";
    public static final String BYTE = "toByte";
    public static final ImmutableSet<String> NUMBER_CONVERSIONS = ImmutableSet.of((Object)"toDouble", (Object)"toFloat", (Object)"toLong", (Object)"toInt", (Object)"toShort", (Object)"toByte", (Object[])new String[]{"toChar"});
    public static final ImmutableBiMap<JetToken, String> UNARY_OPERATION_NAMES = ImmutableBiMap.builder().put((Object)JetTokens.PLUSPLUS, (Object)"inc").put((Object)JetTokens.MINUSMINUS, (Object)"dec").put((Object)JetTokens.PLUS, (Object)"plus").put((Object)JetTokens.MINUS, (Object)"minus").put((Object)JetTokens.EXCL, (Object)"not").build();
    public static final ImmutableBiMap<JetToken, String> BINARY_OPERATION_NAMES = ImmutableBiMap.builder().put((Object)JetTokens.MUL, (Object)"times").put((Object)JetTokens.PLUS, (Object)"plus").put((Object)JetTokens.MINUS, (Object)"minus").put((Object)JetTokens.DIV, (Object)"div").put((Object)JetTokens.PERC, (Object)"mod").put((Object)JetTokens.ARROW, (Object)"arrow").put((Object)JetTokens.RANGE, (Object)"rangeTo").build();
    public static final ImmutableSet<JetToken> NOT_OVERLOADABLE = ImmutableSet.of((Object)((Object)JetTokens.ANDAND), (Object)((Object)JetTokens.OROR), (Object)((Object)JetTokens.ELVIS));
    public static final ImmutableSet<JetToken> INCREMENT_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.PLUSPLUS), (Object)((Object)JetTokens.MINUSMINUS));
    public static final ImmutableSet<JetToken> COMPARISON_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.LT), (Object)((Object)JetTokens.GT), (Object)((Object)JetTokens.LTEQ), (Object)((Object)JetTokens.GTEQ));
    public static final ImmutableSet<JetToken> EQUALS_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.EQEQ), (Object)((Object)JetTokens.EXCLEQ));
    public static final ImmutableSet<JetToken> IN_OPERATIONS = ImmutableSet.of((Object)((Object)JetTokens.IN_KEYWORD), (Object)((Object)JetTokens.NOT_IN));
    public static final ImmutableBiMap<JetToken, String> ASSIGNMENT_OPERATIONS = ImmutableBiMap.builder().put((Object)JetTokens.MULTEQ, (Object)"timesAssign").put((Object)JetTokens.DIVEQ, (Object)"divAssign").put((Object)JetTokens.PERCEQ, (Object)"modAssign").put((Object)JetTokens.PLUSEQ, (Object)"plusAssign").put((Object)JetTokens.MINUSEQ, (Object)"minusAssign").build();
    public static final ImmutableMap<JetToken, JetToken> ASSIGNMENT_OPERATION_COUNTERPARTS = ImmutableMap.builder().put((Object)JetTokens.MULTEQ, (Object)JetTokens.MUL).put((Object)JetTokens.DIVEQ, (Object)JetTokens.DIV).put((Object)JetTokens.PERCEQ, (Object)JetTokens.PERC).put((Object)JetTokens.PLUSEQ, (Object)JetTokens.PLUS).put((Object)JetTokens.MINUSEQ, (Object)JetTokens.MINUS).build();

    private OperatorConventions() {
    }

    @Nullable
    public static String getNameForOperationSymbol(@NotNull JetToken token) {
        String name = (String)UNARY_OPERATION_NAMES.get((Object)token);
        if (name != null) {
            return name;
        }
        name = (String)BINARY_OPERATION_NAMES.get((Object)token);
        if (name != null) {
            return name;
        }
        name = (String)ASSIGNMENT_OPERATIONS.get((Object)token);
        if (name != null) {
            return name;
        }
        if (COMPARISON_OPERATIONS.contains((Object)token)) {
            return COMPARE_TO;
        }
        if (EQUALS_OPERATIONS.contains((Object)token)) {
            return EQUALS;
        }
        if (IN_OPERATIONS.contains((Object)token)) {
            return CONTAINS;
        }
        return null;
    }
}

