/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetIdeTemplateExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalyzer;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.jet.lexer.JetTokens;

public class ExpressionTypingVisitorForStatements
extends ExpressionTypingVisitor {
    private final WritableScope scope;
    private final BasicExpressionTypingVisitor basic;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;

    public ExpressionTypingVisitorForStatements(@NotNull ExpressionTypingInternals facade, @NotNull WritableScope scope, BasicExpressionTypingVisitor basic, @NotNull ControlStructureTypingVisitor controlStructures, @NotNull PatternMatchingTypingVisitor patterns) {
        super(facade);
        this.scope = scope;
        this.basic = basic;
        this.controlStructures = controlStructures;
        this.patterns = patterns;
    }

    @Nullable
    private JetType checkAssignmentType(@Nullable JetType assignmentType, @NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext context) {
        if (assignmentType != null && !JetStandardClasses.isUnit(assignmentType) && context.expectedType != TypeUtils.NO_EXPECTED_TYPE && TypeUtils.equalTypes(context.expectedType, assignmentType)) {
            context.trace.report(Errors.ASSIGNMENT_TYPE_MISMATCH.on(expression, context.expectedType));
            return null;
        }
        return DataFlowUtils.checkStatementType(expression, context);
    }

    @Override
    public JetType visitObjectDeclaration(JetObjectDeclaration declaration, ExpressionTypingContext context) {
        TopDownAnalyzer.processObject(context.semanticServices, context.trace, this.scope, this.scope.getContainingDeclaration(), declaration);
        ClassDescriptor classDescriptor = context.trace.getBindingContext().get(BindingContext.CLASS, declaration);
        if (classDescriptor != null) {
            VariableDescriptor variableDescriptor = context.getDescriptorResolver().resolveObjectDeclaration(this.scope.getContainingDeclaration(), declaration, classDescriptor);
            this.scope.addVariableDescriptor(variableDescriptor);
        }
        return DataFlowUtils.checkStatementType(declaration, context);
    }

    @Override
    public JetType visitProperty(JetProperty property, ExpressionTypingContext context) {
        VariableDescriptor olderVariable;
        JetPropertyAccessor setter;
        JetPropertyAccessor getter;
        JetTypeReference receiverTypeRef = property.getReceiverTypeRef();
        if (receiverTypeRef != null) {
            context.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on(receiverTypeRef));
        }
        if ((getter = property.getGetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on(getter));
        }
        if ((setter = property.getSetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on(setter));
        }
        VariableDescriptor propertyDescriptor = context.getDescriptorResolver().resolveLocalVariableDescriptor(this.scope.getContainingDeclaration(), this.scope, property, context.dataFlowInfo);
        JetExpression initializer = property.getInitializer();
        if (property.getPropertyTypeRef() != null && initializer != null) {
            JetType outType = propertyDescriptor.getType();
            JetType initializerType = this.facade.getType(initializer, context.replaceExpectedType(outType).replaceScope(this.scope));
        }
        if ((olderVariable = this.scope.getLocalVariable(propertyDescriptor.getName())) != null && DescriptorUtils.isLocal(propertyDescriptor.getContainingDeclaration(), olderVariable)) {
            context.trace.report(Errors.NAME_SHADOWING.on(propertyDescriptor, context.trace.getBindingContext()));
        }
        this.scope.addVariableDescriptor(propertyDescriptor);
        return DataFlowUtils.checkStatementType(property, context);
    }

    @Override
    public JetType visitNamedFunction(JetNamedFunction function, ExpressionTypingContext context) {
        SimpleFunctionDescriptor functionDescriptor = context.getDescriptorResolver().resolveFunctionDescriptor(this.scope.getContainingDeclaration(), this.scope, function);
        this.scope.addFunctionDescriptor(functionDescriptor);
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace);
        context.getServices().checkFunctionReturnType(functionInnerScope, (JetDeclarationWithBody)function, (FunctionDescriptor)functionDescriptor, context.dataFlowInfo);
        return DataFlowUtils.checkStatementType(function, context);
    }

    @Override
    public JetType visitClass(JetClass klass, ExpressionTypingContext context) {
        return (JetType)super.visitClass(klass, context);
    }

    @Override
    public JetType visitTypedef(JetTypedef typedef, ExpressionTypingContext context) {
        return (JetType)super.visitTypedef(typedef, context);
    }

    @Override
    public JetType visitDeclaration(JetDeclaration dcl, ExpressionTypingContext context) {
        return DataFlowUtils.checkStatementType(dcl, context);
    }

    @Override
    public JetType visitBinaryExpression(JetBinaryExpression expression, ExpressionTypingContext context) {
        JetType result;
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.EQ) {
            result = this.visitAssignment(expression, context);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
            result = this.visitAssignmentOperation(expression, context);
        } else {
            return this.facade.getType(expression, context);
        }
        return DataFlowUtils.checkType(result, expression, context);
    }

    protected JetType visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetType type;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(contextWithExpectedType.trace);
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE).replaceExpectedReturnType(TypeUtils.NO_EXPECTED_TYPE).replaceBindingTrace(temporaryBindingTrace);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
        if (left == null) {
            return null;
        }
        JetType leftType = this.facade.getType(left, context);
        if (leftType == null) {
            this.facade.getType(expression.getRight(), context);
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(operationSign));
            temporaryBindingTrace.commit();
            return null;
        }
        ExpressionReceiver receiver = new ExpressionReceiver(left, leftType);
        String name = (String)OperatorConventions.ASSIGNMENT_OPERATIONS.get((Object)operationType);
        TemporaryBindingTrace assignmentOperationTrace = TemporaryBindingTrace.create(context.trace);
        OverloadResolutionResults<FunctionDescriptor> assignmentOperationDescriptors = this.basic.getResolutionResultsForBinaryCall(this.scope, name, context.replaceBindingTrace(assignmentOperationTrace), expression, receiver);
        JetType assignmentOperationType = OverloadResolutionResultsUtil.getResultType(assignmentOperationDescriptors);
        String counterpartName = (String)OperatorConventions.BINARY_OPERATION_NAMES.get(OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get((Object)operationType));
        TemporaryBindingTrace binaryOperationTrace = TemporaryBindingTrace.create(context.trace);
        OverloadResolutionResults<FunctionDescriptor> binaryOperationDescriptors = this.basic.getResolutionResultsForBinaryCall(this.scope, counterpartName, context.replaceBindingTrace(binaryOperationTrace), expression, receiver);
        JetType binaryOperationType = OverloadResolutionResultsUtil.getResultType(binaryOperationDescriptors);
        JetType jetType = type = assignmentOperationType != null ? assignmentOperationType : binaryOperationType;
        if (assignmentOperationType != null && binaryOperationType != null) {
            OverloadResolutionResults<FunctionDescriptor> ambiguityResolutionResults = OverloadResolutionResultsUtil.ambiguity(assignmentOperationDescriptors, binaryOperationDescriptors);
            context.trace.report(Errors.ASSIGN_OPERATOR_AMBIGUITY.on(operationSign, ambiguityResolutionResults.getResultingCalls()));
            HashSet descriptors = Sets.newHashSet();
            for (ResolvedCall<FunctionDescriptor> call : ambiguityResolutionResults.getResultingCalls()) {
                descriptors.add(call.getResultingDescriptor());
            }
            this.facade.getType(expression.getRight(), context);
            context.trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationSign, descriptors);
        } else if (assignmentOperationType != null) {
            assignmentOperationTrace.commit();
            if (!JetStandardClasses.isUnit(assignmentOperationType)) {
                context.trace.report(Errors.ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT.on(operationSign, assignmentOperationDescriptors.getResultingDescriptor(), operationSign));
            }
        } else {
            binaryOperationTrace.commit();
            context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
            ExpressionTypingUtils.checkWrappingInRef(expression.getLeft(), context);
            if (left instanceof JetArrayAccessExpression) {
                ExpressionTypingContext contextForResolve = context.replaceScope(this.scope).replaceBindingTrace(TemporaryBindingTrace.create(contextWithExpectedType.trace));
                this.basic.resolveArrayAccessSetMethod((JetArrayAccessExpression)left, expression.getRight(), contextForResolve, context.trace);
            }
        }
        this.basic.checkLValue(context.trace, expression.getLeft());
        temporaryBindingTrace.commit();
        return this.checkAssignmentType(type, expression, contextWithExpectedType);
    }

    protected JetType visitAssignment(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE).replaceExpectedReturnType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
        JetExpression right = expression.getRight();
        if (left instanceof JetArrayAccessExpression) {
            JetArrayAccessExpression arrayAccessExpression = (JetArrayAccessExpression)left;
            JetType assignmentType = this.basic.resolveArrayAccessSetMethod(arrayAccessExpression, right, context.replaceScope(this.scope), context.trace);
            this.basic.checkLValue(context.trace, arrayAccessExpression);
            return this.checkAssignmentType(assignmentType, expression, contextWithExpectedType);
        }
        JetType leftType = this.facade.getType(expression.getLeft(), context.replaceScope(this.scope));
        if (right != null) {
            JetType rightType = this.facade.getType(right, context.replaceExpectedType(leftType).replaceScope(this.scope));
        }
        if (leftType != null) {
            this.basic.checkLValue(context.trace, expression.getLeft());
        }
        if (left instanceof JetSimpleNameExpression) {
            ExpressionTypingUtils.checkWrappingInRef(left, context);
        }
        return DataFlowUtils.checkStatementType(expression, contextWithExpectedType);
    }

    @Override
    public JetType visitExpression(JetExpression expression, ExpressionTypingContext context) {
        return this.facade.getType(expression, context);
    }

    @Override
    public JetType visitJetElement(JetElement element, ExpressionTypingContext context) {
        context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element, "in a block"));
        return null;
    }

    @Override
    public JetType visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext context) {
        return this.controlStructures.visitWhileExpression(expression, context, true);
    }

    @Override
    public JetType visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext context) {
        return this.controlStructures.visitDoWhileExpression(expression, context, true);
    }

    @Override
    public JetType visitForExpression(JetForExpression expression, ExpressionTypingContext context) {
        return this.controlStructures.visitForExpression(expression, context, true);
    }

    @Override
    public JetType visitIfExpression(JetIfExpression expression, ExpressionTypingContext context) {
        return this.controlStructures.visitIfExpression(expression, context, true);
    }

    @Override
    public JetType visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext context) {
        return this.patterns.visitWhenExpression(expression, context, true);
    }

    @Override
    public JetType visitBlockExpression(JetBlockExpression expression, ExpressionTypingContext context) {
        return this.basic.visitBlockExpression(expression, context, true);
    }

    @Override
    public JetType visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context) {
        return this.basic.visitParenthesizedExpression(expression, context, true);
    }

    @Override
    public JetType visitUnaryExpression(JetUnaryExpression expression, ExpressionTypingContext context) {
        return this.basic.visitUnaryExpression(expression, context, true);
    }

    @Override
    public JetType visitIdeTemplateExpression(JetIdeTemplateExpression expression, ExpressionTypingContext context) {
        context.trace.report(Errors.UNRESOLVED_IDE_TEMPLATE.on(expression, (String)ObjectUtils.notNull((Object)expression.getText(), (Object)"<no name>")));
        return null;
    }
}

