/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.intellij.lang.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIdeTemplateExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ClosureExpressionsTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitorForStatements;
import org.jetbrains.jet.lang.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.jet.util.lazy.ReenteringLazyValueComputationException;

public class ExpressionTypingVisitorDispatcher
extends JetVisitor<JetType, ExpressionTypingContext>
implements ExpressionTypingInternals {
    private final BasicExpressionTypingVisitor basic;
    private final ExpressionTypingVisitorForStatements statements;
    private final ClosureExpressionsTypingVisitor closures = new ClosureExpressionsTypingVisitor(this);
    private final ControlStructureTypingVisitor controlStructures = new ControlStructureTypingVisitor(this);
    private final PatternMatchingTypingVisitor patterns = new PatternMatchingTypingVisitor(this);
    protected DataFlowInfo resultDataFlowInfo;

    @Override
    public JetType visitIdeTemplateExpression(JetIdeTemplateExpression expression, ExpressionTypingContext data) {
        return this.basic.visitIdeTemplateExpression(expression, data);
    }

    @NotNull
    public static ExpressionTypingFacade create() {
        return new ExpressionTypingVisitorDispatcher(null);
    }

    @NotNull
    public static ExpressionTypingInternals createForBlock(WritableScope writableScope) {
        return new ExpressionTypingVisitorDispatcher(writableScope);
    }

    private ExpressionTypingVisitorDispatcher(WritableScope writableScope) {
        this.basic = new BasicExpressionTypingVisitor(this);
        this.statements = writableScope != null ? new ExpressionTypingVisitorForStatements(this, writableScope, this.basic, this.controlStructures, this.patterns) : null;
    }

    @Override
    @Nullable
    public DataFlowInfo getResultingDataFlowInfo() {
        return this.resultDataFlowInfo;
    }

    @Override
    public JetType getSelectorReturnType(@NotNull ReceiverDescriptor receiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression selectorExpression, @NotNull ExpressionTypingContext context) {
        return this.basic.getSelectorReturnType(receiver, callOperationNode, selectorExpression, context);
    }

    @Override
    public boolean checkInExpression(JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @Nullable JetExpression left, @NotNull JetExpression right, ExpressionTypingContext context) {
        return this.basic.checkInExpression(callElement, operationSign, left, right, context);
    }

    @Override
    public void setResultingDataFlowInfo(@NotNull DataFlowInfo dataFlowInfo) {
        this.resultDataFlowInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public final JetType safeGetType(@NotNull JetExpression expression, ExpressionTypingContext context) {
        JetType type = this.getType(expression, context);
        if (type != null) {
            return type;
        }
        return ErrorUtils.createErrorType("Type for " + expression.getText());
    }

    @Override
    @Nullable
    public final JetType getType(@NotNull JetExpression expression, ExpressionTypingContext context) {
        return this.getType(expression, context, this);
    }

    @Override
    @Nullable
    public final JetType getType(@NotNull JetExpression expression, ExpressionTypingContext context, boolean isStatement) {
        if (!isStatement) {
            return this.getType(expression, context);
        }
        if (this.statements != null) {
            return this.getType(expression, context, this.statements);
        }
        return this.getType(expression, context, this.createStatementVisitor(context));
    }

    private ExpressionTypingVisitorForStatements createStatementVisitor(ExpressionTypingContext context) {
        return new ExpressionTypingVisitorForStatements(this, ExpressionTypingUtils.newWritableScopeImpl(context).setDebugName("statement scope"), this.basic, this.controlStructures, this.patterns);
    }

    @Override
    public void checkStatementType(@NotNull JetExpression expression, ExpressionTypingContext context) {
        expression.accept(this.createStatementVisitor(context), context);
    }

    @Nullable
    private JetType getType(@NotNull JetExpression expression, ExpressionTypingContext context, JetVisitor<JetType, ExpressionTypingContext> visitor) {
        JetType result;
        if (context.trace.get(BindingContext.PROCESSED, expression).booleanValue()) {
            return context.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
        }
        try {
            result = expression.accept(visitor, context);
            if (context.trace.get(BindingContext.PROCESSED, expression).booleanValue()) {
                return context.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
            }
            if (result instanceof DeferredType) {
                result = ((DeferredType)result).getActualType();
            }
            if (result != null) {
                context.trace.record(BindingContext.EXPRESSION_TYPE, expression, result);
            }
        }
        catch (ReenteringLazyValueComputationException e) {
            context.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression));
            result = null;
        }
        if (!context.trace.get(BindingContext.PROCESSED, expression).booleanValue()) {
            context.trace.record(BindingContext.RESOLUTION_SCOPE, expression, context.scope);
        }
        context.trace.record(BindingContext.PROCESSED, expression);
        return result;
    }

    @Override
    public JetType visitFunctionLiteralExpression(JetFunctionLiteralExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.closures, data);
    }

    @Override
    public JetType visitObjectLiteralExpression(JetObjectLiteralExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.closures, data);
    }

    @Override
    public JetType visitThrowExpression(JetThrowExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitReturnExpression(JetReturnExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitContinueExpression(JetContinueExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitIfExpression(JetIfExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitTryExpression(JetTryExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitForExpression(JetForExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitBreakExpression(JetBreakExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.controlStructures, data);
    }

    @Override
    public JetType visitIsExpression(JetIsExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.patterns, data);
    }

    @Override
    public JetType visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext data) {
        return expression.accept(this.patterns, data);
    }

    @Override
    public JetType visitJetElement(JetElement element, ExpressionTypingContext data) {
        return element.accept(this.basic, data);
    }
}

