/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetTokens;

public class ExpressionTypingServices {
    private final JetSemanticServices semanticServices;
    private final BindingTrace trace;
    private final ExpressionTypingFacade expressionTypingFacade = ExpressionTypingVisitorDispatcher.create();

    public ExpressionTypingServices(JetSemanticServices semanticServices, BindingTrace trace) {
        this.semanticServices = semanticServices;
        this.trace = trace;
    }

    @NotNull
    public JetType safeGetType(@NotNull JetScope scope, @NotNull JetExpression expression, @NotNull JetType expectedType) {
        return this.safeGetType(scope, expression, expectedType, DataFlowInfo.EMPTY);
    }

    public JetType safeGetType(@NotNull JetScope scope, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo) {
        JetType type = this.getType(scope, expression, expectedType, dataFlowInfo);
        if (type != null) {
            return type;
        }
        return ErrorUtils.createErrorType("Type for " + expression.getText());
    }

    @Nullable
    public JetType getType(@NotNull JetScope scope, @NotNull JetExpression expression, @NotNull JetType expectedType) {
        return this.getType(scope, expression, expectedType, DataFlowInfo.EMPTY);
    }

    @Nullable
    public JetType getType(@NotNull JetScope scope, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo) {
        ExpressionTypingContext context = ExpressionTypingContext.newContext(expression.getProject(), this.semanticServices, new HashMap<JetPattern, DataFlowInfo>(), new HashMap<JetPattern, List<VariableDescriptor>>(), new LabelResolver(), this.trace, scope, dataFlowInfo, expectedType, TypeUtils.FORBIDDEN, false);
        return this.expressionTypingFacade.getType(expression, context);
    }

    public JetType getTypeWithNamespaces(@NotNull JetScope scope, @NotNull JetExpression expression) {
        ExpressionTypingContext context = ExpressionTypingContext.newContext(expression.getProject(), this.semanticServices, new HashMap<JetPattern, DataFlowInfo>(), new HashMap<JetPattern, List<VariableDescriptor>>(), new LabelResolver(), this.trace, scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, TypeUtils.FORBIDDEN, true);
        return this.expressionTypingFacade.getType(expression, context);
    }

    @NotNull
    public JetType inferFunctionReturnType(@NotNull JetScope outerScope, JetDeclarationWithBody function, FunctionDescriptor functionDescriptor) {
        Map<JetExpression, JetType> typeMap = this.collectReturnedExpressionsWithTypes(this.trace, outerScope, function, functionDescriptor);
        Collection<JetType> types = typeMap.values();
        return types.isEmpty() ? JetStandardClasses.getNothingType() : CommonSupertypes.commonSupertype(types);
    }

    public void checkFunctionReturnType(@NotNull JetScope functionInnerScope, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor) {
        this.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, DataFlowInfo.EMPTY, null);
    }

    public void checkFunctionReturnType(@NotNull JetScope functionInnerScope, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @Nullable JetType expectedReturnType) {
        this.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, DataFlowInfo.EMPTY, expectedReturnType);
    }

    void checkFunctionReturnType(@NotNull JetScope functionInnerScope, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo) {
        this.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, dataFlowInfo, null);
    }

    void checkFunctionReturnType(@NotNull JetScope functionInnerScope, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable JetType expectedReturnType) {
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function.hasBlockBody() && !function.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function, ExpressionTypingContext.newContext(function.getProject(), this.semanticServices, new HashMap<JetPattern, DataFlowInfo>(), new HashMap<JetPattern, List<VariableDescriptor>>(), new LabelResolver(), this.trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, expectedReturnType, false));
    }

    void checkFunctionReturnType(JetDeclarationWithBody function, ExpressionTypingContext context) {
        ExpressionTypingContext newContext;
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function.hasBlockBody();
        ExpressionTypingContext expressionTypingContext = blockBody ? context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : (newContext = context.replaceExpectedType(context.expectedReturnType == TypeUtils.FORBIDDEN ? TypeUtils.NO_EXPECTED_TYPE : context.expectedReturnType).replaceExpectedReturnType(TypeUtils.FORBIDDEN));
        if (function instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteralExpression functionLiteralExpression = (JetFunctionLiteralExpression)function;
            JetBlockExpression blockExpression = functionLiteralExpression.getBodyExpression();
            assert (blockExpression != null);
            this.getBlockReturnedType(newContext.scope, blockExpression, CoercionStrategy.COERCION_TO_UNIT, context);
        } else {
            this.expressionTypingFacade.getType(bodyExpression, newContext, !blockBody);
        }
    }

    @Nullable
    JetType getBlockReturnedType(@NotNull JetScope outerScope, @NotNull JetBlockExpression expression, @NotNull CoercionStrategy coercionStrategyForLastExpression, ExpressionTypingContext context) {
        List<JetElement> block = expression.getStatements();
        if (block.isEmpty()) {
            return DataFlowUtils.checkType(JetStandardClasses.getUnitType(), expression, context);
        }
        DeclarationDescriptor containingDescriptor = outerScope.getContainingDeclaration();
        WritableScopeImpl scope = new WritableScopeImpl(outerScope, containingDescriptor, new TraceBasedRedeclarationHandler(context.trace)).setDebugName("getBlockReturnedType");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        return this.getBlockReturnedTypeWithWritableScope(scope, block, coercionStrategyForLastExpression, context);
    }

    private Map<JetExpression, JetType> collectReturnedExpressionsWithTypes(final @NotNull BindingTrace trace, JetScope outerScope, final JetDeclarationWithBody function, FunctionDescriptor functionDescriptor) {
        JetExpression bodyExpression = function.getBodyExpression();
        assert (bodyExpression != null);
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace);
        this.expressionTypingFacade.getType(bodyExpression, ExpressionTypingContext.newContext(function.getProject(), this.semanticServices, new HashMap<JetPattern, DataFlowInfo>(), new HashMap<JetPattern, List<VariableDescriptor>>(), new LabelResolver(), trace, functionInnerScope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, TypeUtils.FORBIDDEN, false), !function.hasBlockBody());
        final ArrayList returnedExpressions = Lists.newArrayList();
        if (function.hasBlockBody()) {
            bodyExpression.accept(new JetTreeVisitor<JetDeclarationWithBody>(){

                @Override
                public Void visitReturnExpression(JetReturnExpression expression, JetDeclarationWithBody outerFunction) {
                    PsiElement element;
                    JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                    PsiElement psiElement = element = targetLabel != null ? trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                    if (element == function || targetLabel == null && outerFunction == function) {
                        returnedExpressions.add(expression);
                    }
                    return null;
                }

                @Override
                public Void visitFunctionLiteralExpression(JetFunctionLiteralExpression expression, JetDeclarationWithBody outerFunction) {
                    return (Void)super.visitFunctionLiteralExpression(expression, expression.getFunctionLiteral());
                }

                @Override
                public Void visitNamedFunction(JetNamedFunction function2, JetDeclarationWithBody outerFunction) {
                    return (Void)super.visitNamedFunction(function2, function2);
                }
            }, function);
        } else {
            returnedExpressions.add(bodyExpression);
        }
        HashMap<JetExpression, JetType> typeMap = new HashMap<JetExpression, JetType>();
        for (JetExpression returnedExpression : returnedExpressions) {
            JetType cachedType = trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, returnedExpression);
            trace.record(BindingContext.STATEMENT, returnedExpression, false);
            if (cachedType != null) {
                typeMap.put(returnedExpression, cachedType);
                continue;
            }
            typeMap.put(returnedExpression, ErrorUtils.createErrorType("Error function type"));
        }
        return typeMap;
    }

    JetType getBlockReturnedTypeWithWritableScope(@NotNull WritableScope scope, @NotNull List<? extends JetElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, ExpressionTypingContext context) {
        if (block.isEmpty()) {
            return JetStandardClasses.getUnitType();
        }
        ExpressionTypingInternals blockLevelVisitor = ExpressionTypingVisitorDispatcher.createForBlock(scope);
        ExpressionTypingContext newContext = this.createContext(context, this.trace, scope, context.dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, context.expectedReturnType);
        JetType result = null;
        Iterator<? extends JetElement> iterator = block.iterator();
        while (iterator.hasNext()) {
            JetElement statement = iterator.next();
            this.trace.record(BindingContext.STATEMENT, statement);
            JetExpression statementExpression = (JetExpression)statement;
            if (!iterator.hasNext()) {
                if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
                    if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && JetStandardClasses.isUnit(context.expectedType)) {
                        TemporaryBindingTrace temporaryTraceExpectingUnit = TemporaryBindingTrace.create(this.trace);
                        boolean[] mismatch = new boolean[1];
                        ObservableBindingTrace errorInterceptingTrace = this.makeTraceInterceptingTypeMismatch(temporaryTraceExpectingUnit, statementExpression, mismatch);
                        newContext = this.createContext(newContext, errorInterceptingTrace, scope, newContext.dataFlowInfo, context.expectedType, context.expectedReturnType);
                        result = blockLevelVisitor.getType(statementExpression, newContext, true);
                        if (mismatch[0]) {
                            TemporaryBindingTrace temporaryTraceNoExpectedType = TemporaryBindingTrace.create(this.trace);
                            mismatch[0] = false;
                            ObservableBindingTrace interceptingTrace = this.makeTraceInterceptingTypeMismatch(temporaryTraceNoExpectedType, statementExpression, mismatch);
                            newContext = this.createContext(newContext, interceptingTrace, scope, newContext.dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, context.expectedReturnType);
                            result = blockLevelVisitor.getType(statementExpression, newContext, true);
                            if (mismatch[0]) {
                                temporaryTraceExpectingUnit.commit();
                            } else {
                                temporaryTraceNoExpectedType.commit();
                            }
                        } else {
                            temporaryTraceExpectingUnit.commit();
                        }
                    } else {
                        newContext = this.createContext(newContext, this.trace, scope, newContext.dataFlowInfo, context.expectedType, context.expectedReturnType);
                        result = blockLevelVisitor.getType(statementExpression, newContext, true);
                    }
                } else {
                    result = blockLevelVisitor.getType(statementExpression, newContext, true);
                    if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
                        JetBinaryExpression binaryExpression;
                        IElementType operationType;
                        boolean mightBeUnit = false;
                        if (statementExpression instanceof JetDeclaration) {
                            mightBeUnit = true;
                        }
                        if (statementExpression instanceof JetBinaryExpression && ((operationType = (binaryExpression = (JetBinaryExpression)statementExpression).getOperationToken()) == JetTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType))) {
                            mightBeUnit = true;
                        }
                        if (mightBeUnit) {
                            assert (result == null || JetStandardClasses.isUnit(result));
                            result = JetStandardClasses.getUnitType();
                        }
                    }
                }
            } else {
                result = blockLevelVisitor.getType(statementExpression, newContext, true);
            }
            DataFlowInfo newDataFlowInfo = blockLevelVisitor.getResultingDataFlowInfo();
            if (newDataFlowInfo == null) {
                newDataFlowInfo = context.dataFlowInfo;
            }
            if (newDataFlowInfo != context.dataFlowInfo) {
                newContext = this.createContext(newContext, this.trace, scope, newDataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, context.expectedReturnType);
            }
            blockLevelVisitor = ExpressionTypingVisitorDispatcher.createForBlock(scope);
        }
        return result;
    }

    private ExpressionTypingContext createContext(ExpressionTypingContext oldContext, BindingTrace trace, WritableScope scope, DataFlowInfo dataFlowInfo, JetType expectedType, JetType expectedReturnType) {
        return ExpressionTypingContext.newContext(oldContext.project, oldContext.semanticServices, oldContext.patternsToDataFlowInfo, oldContext.patternsToBoundVariableLists, oldContext.labelResolver, trace, scope, dataFlowInfo, expectedType, expectedReturnType, oldContext.namespacesAllowed);
    }

    private ObservableBindingTrace makeTraceInterceptingTypeMismatch(BindingTrace trace, final JetExpression expressionToWatch, final boolean[] mismatchFound) {
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic.getFactory() == Errors.TYPE_MISMATCH && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }
        };
    }
}

