/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;

class ExpressionTypingContext {
    public final Project project;
    public final JetSemanticServices semanticServices;
    public final BindingTrace trace;
    public final JetScope scope;
    public final DataFlowInfo dataFlowInfo;
    public final JetType expectedType;
    public final JetType expectedReturnType;
    public final Map<JetPattern, DataFlowInfo> patternsToDataFlowInfo;
    public final Map<JetPattern, List<VariableDescriptor>> patternsToBoundVariableLists;
    public final LabelResolver labelResolver;
    public final boolean namespacesAllowed;
    private CallResolver callResolver;
    private TypeResolver typeResolver;
    private DescriptorResolver descriptorResolver;
    private ExpressionTypingServices services;
    private CompileTimeConstantResolver compileTimeConstantResolver;

    @NotNull
    public static ExpressionTypingContext newContext(@NotNull Project project, @NotNull JetSemanticServices semanticServices, @NotNull Map<JetPattern, DataFlowInfo> patternsToDataFlowInfo, @NotNull Map<JetPattern, List<VariableDescriptor>> patternsToBoundVariableLists, @NotNull LabelResolver labelResolver, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull JetType expectedReturnType, boolean namespacesAllowed) {
        return new ExpressionTypingContext(project, semanticServices, patternsToDataFlowInfo, patternsToBoundVariableLists, labelResolver, trace, scope, dataFlowInfo, expectedType, expectedReturnType, namespacesAllowed);
    }

    private ExpressionTypingContext(@NotNull Project project, @NotNull JetSemanticServices semanticServices, @NotNull Map<JetPattern, DataFlowInfo> patternsToDataFlowInfo, @NotNull Map<JetPattern, List<VariableDescriptor>> patternsToBoundVariableLists, @NotNull LabelResolver labelResolver, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull JetType expectedReturnType, boolean namespacesAllowed) {
        this.project = project;
        this.trace = trace;
        this.patternsToBoundVariableLists = patternsToBoundVariableLists;
        this.patternsToDataFlowInfo = patternsToDataFlowInfo;
        this.labelResolver = labelResolver;
        this.scope = scope;
        this.semanticServices = semanticServices;
        this.dataFlowInfo = dataFlowInfo;
        this.expectedType = expectedType;
        this.expectedReturnType = expectedReturnType;
        this.namespacesAllowed = namespacesAllowed;
    }

    @NotNull
    public ExpressionTypingContext replaceNamespacesAllowed(boolean namespacesAllowed) {
        if (namespacesAllowed == this.namespacesAllowed) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.project, this.semanticServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.expectedReturnType, namespacesAllowed);
    }

    @NotNull
    public ExpressionTypingContext replaceDataFlowInfo(DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == this.dataFlowInfo) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.project, this.semanticServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, this.scope, newDataFlowInfo, this.expectedType, this.expectedReturnType, this.namespacesAllowed);
    }

    public ExpressionTypingContext replaceExpectedType(@Nullable JetType newExpectedType) {
        if (newExpectedType == null) {
            return this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        }
        if (this.expectedType == newExpectedType) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.project, this.semanticServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.expectedReturnType, this.namespacesAllowed);
    }

    public ExpressionTypingContext replaceExpectedReturnType(@Nullable JetType newExpectedReturnType) {
        if (newExpectedReturnType == null) {
            return this.replaceExpectedReturnType(TypeUtils.NO_EXPECTED_TYPE);
        }
        if (this.expectedReturnType == newExpectedReturnType) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.project, this.semanticServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, this.scope, this.dataFlowInfo, this.expectedType, newExpectedReturnType, this.namespacesAllowed);
    }

    public ExpressionTypingContext replaceBindingTrace(@NotNull BindingTrace newTrace) {
        if (newTrace == this.trace) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.project, this.semanticServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, newTrace, this.scope, this.dataFlowInfo, this.expectedType, this.expectedReturnType, this.namespacesAllowed);
    }

    @NotNull
    public ExpressionTypingContext replaceScope(@NotNull JetScope newScope) {
        if (newScope == this.scope) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.project, this.semanticServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, newScope, this.dataFlowInfo, this.expectedType, this.expectedReturnType, this.namespacesAllowed);
    }

    public CallResolver getCallResolver() {
        if (this.callResolver == null) {
            this.callResolver = new CallResolver(this.semanticServices, this.dataFlowInfo);
        }
        return this.callResolver;
    }

    public ExpressionTypingServices getServices() {
        if (this.services == null) {
            this.services = new ExpressionTypingServices(this.semanticServices, this.trace);
        }
        return this.services;
    }

    public TypeResolver getTypeResolver() {
        if (this.typeResolver == null) {
            this.typeResolver = new TypeResolver(this.semanticServices, this.trace, true);
        }
        return this.typeResolver;
    }

    public DescriptorResolver getDescriptorResolver() {
        if (this.descriptorResolver == null) {
            this.descriptorResolver = this.semanticServices.getClassDescriptorResolver(this.trace);
        }
        return this.descriptorResolver;
    }

    public CompileTimeConstantResolver getCompileTimeConstantResolver() {
        if (this.compileTimeConstantResolver == null) {
            this.compileTimeConstantResolver = new CompileTimeConstantResolver(this.semanticServices, this.trace);
        }
        return this.compileTimeConstantResolver;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull String name) {
        return this.getCallResolver().resolveCallWithGivenName(this.trace, this.scope, call, functionReference, name, this.expectedType);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenNameToDescriptor(@NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull String name) {
        return this.resolveCallWithGivenName(call, functionReference, name);
    }

    @Nullable
    public FunctionDescriptor resolveCall(@NotNull ReceiverDescriptor receiver, @Nullable ASTNode callOperationNode, @NotNull JetCallExpression callExpression) {
        OverloadResolutionResults<FunctionDescriptor> results = this.getCallResolver().resolveCall(this.trace, this.scope, CallMaker.makeCall(receiver, callOperationNode, callExpression), this.expectedType);
        return results.singleResult() ? results.getResultingDescriptor() : null;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull ReceiverDescriptor receiver, @Nullable ASTNode callOperationNode, @NotNull JetSimpleNameExpression nameExpression) {
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        return this.getCallResolver().resolveSimpleProperty(this.trace, this.scope, call, this.expectedType);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveExactSignature(@NotNull ReceiverDescriptor receiver, @NotNull String name, @NotNull List<JetType> parameterTypes) {
        return this.getCallResolver().resolveExactSignature(this.scope, receiver, name, parameterTypes);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }
}

