/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetHashQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetIdeTemplateExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedInstanceExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetRootNamespaceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTupleExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiverDescriptor;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetTokens;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    @Override
    public JetType visitSimpleNameExpression(JetSimpleNameExpression expression, ExpressionTypingContext context) {
        return DataFlowUtils.checkType(this.getSelectorReturnType(ReceiverDescriptor.NO_RECEIVER, null, expression, context), expression, context);
    }

    private JetType lookupNamespaceOrClassObject(JetSimpleNameExpression expression, String referencedName, ExpressionTypingContext context) {
        TemporaryBindingTrace temporaryTrace;
        JetType[] result;
        ClassifierDescriptor classifier = context.scope.getClassifier(referencedName);
        if (classifier != null) {
            JetType classObjectType = classifier.getClassObjectType();
            JetType result2 = null;
            if (classObjectType != null) {
                if (context.namespacesAllowed || classifier.isClassObjectAValue()) {
                    result2 = classObjectType;
                } else {
                    context.trace.report(Errors.NO_CLASS_OBJECT.on(expression, classifier));
                }
                context.trace.record(BindingContext.REFERENCE_TARGET, expression, classifier);
                if (result2 == null) {
                    return ErrorUtils.createErrorType("No class object in " + expression.getReferencedName());
                }
                return DataFlowUtils.checkType(result2, expression, context);
            }
        }
        if (this.furtherNameLookup(expression, referencedName, result = new JetType[1], context.replaceBindingTrace(temporaryTrace = TemporaryBindingTrace.create(context.trace)))) {
            temporaryTrace.commit();
            return DataFlowUtils.checkType(result[0], expression, context);
        }
        if (classifier != null) {
            context.trace.report(Errors.NO_CLASS_OBJECT.on(expression, classifier));
            context.trace.record(BindingContext.REFERENCE_TARGET, expression, classifier);
            return classifier.getDefaultType();
        }
        temporaryTrace.commit();
        return result[0];
    }

    protected boolean furtherNameLookup(@NotNull JetSimpleNameExpression expression, @NotNull String referencedName, @NotNull JetType[] result, ExpressionTypingContext context) {
        if (context.namespacesAllowed) {
            result[0] = this.lookupNamespaceType(expression, referencedName, context);
            return result[0] != null;
        }
        NamespaceType namespaceType = this.lookupNamespaceType(expression, referencedName, context);
        if (namespaceType != null) {
            context.trace.report(Errors.EXPRESSION_EXPECTED_NAMESPACE_FOUND.on(expression));
            result[0] = ErrorUtils.createErrorType("Type for " + referencedName);
        }
        return false;
    }

    @Nullable
    protected NamespaceType lookupNamespaceType(@NotNull JetSimpleNameExpression expression, @NotNull String referencedName, ExpressionTypingContext context) {
        NamespaceDescriptor namespace = context.scope.getNamespace(referencedName);
        if (namespace == null) {
            return null;
        }
        context.trace.record(BindingContext.REFERENCE_TARGET, expression, namespace);
        return namespace.getNamespaceType();
    }

    @Override
    public JetType visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context) {
        return this.visitParenthesizedExpression(expression, context, false);
    }

    public JetType visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context, boolean isStatement) {
        JetExpression innerExpression = expression.getExpression();
        if (innerExpression == null) {
            return null;
        }
        return DataFlowUtils.checkType(this.facade.getType(innerExpression, context.replaceScope(context.scope), isStatement), expression, context);
    }

    @Override
    public JetType visitConstantExpression(JetConstantExpression expression, ExpressionTypingContext context) {
        CompileTimeConstant<?> value;
        ASTNode node = expression.getNode();
        IElementType elementType = node.getElementType();
        String text = node.getText();
        JetStandardLibrary standardLibrary = context.semanticServices.getStandardLibrary();
        CompileTimeConstantResolver compileTimeConstantResolver = context.getCompileTimeConstantResolver();
        if (elementType == JetNodeTypes.INTEGER_CONSTANT) {
            value = compileTimeConstantResolver.getIntegerValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.FLOAT_CONSTANT) {
            value = compileTimeConstantResolver.getFloatValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.BOOLEAN_CONSTANT) {
            value = compileTimeConstantResolver.getBooleanValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.CHARACTER_CONSTANT) {
            value = compileTimeConstantResolver.getCharValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.NULL) {
            value = compileTimeConstantResolver.getNullValue(context.expectedType);
        } else {
            throw new IllegalArgumentException("Unsupported constant: " + (Object)((Object)expression));
        }
        if (value instanceof ErrorValue) {
            ErrorValue errorValue = (ErrorValue)value;
            context.trace.report(Errors.ERROR_COMPILE_TIME_VALUE.on(node.getPsi(), errorValue.getMessage()));
            return ExpressionTypingUtils.getDefaultType(context.semanticServices, elementType);
        }
        context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, value);
        return DataFlowUtils.checkType(value.getType(standardLibrary), expression, context);
    }

    @Override
    public JetType visitBinaryWithTypeRHSExpression(JetBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context) {
        JetTypeReference right = expression.getRight();
        JetType result = null;
        if (right != null) {
            JetType targetType = context.getTypeResolver().resolveType(context.scope, right);
            if (ExpressionTypingUtils.isTypeFlexible(expression.getLeft())) {
                TemporaryBindingTrace temporaryTraceWithExpectedType = TemporaryBindingTrace.create(context.trace);
                boolean success = this.checkBinaryWithTypeRHS(expression, context, targetType, targetType, temporaryTraceWithExpectedType);
                if (success) {
                    temporaryTraceWithExpectedType.commit();
                } else {
                    TemporaryBindingTrace temporaryTraceWithoutExpectedType = TemporaryBindingTrace.create(context.trace);
                    this.checkBinaryWithTypeRHS(expression, context, targetType, TypeUtils.NO_EXPECTED_TYPE, temporaryTraceWithoutExpectedType);
                    temporaryTraceWithoutExpectedType.commit();
                }
            } else {
                TemporaryBindingTrace temporaryTraceWithoutExpectedType = TemporaryBindingTrace.create(context.trace);
                this.checkBinaryWithTypeRHS(expression, context, targetType, TypeUtils.NO_EXPECTED_TYPE, temporaryTraceWithoutExpectedType);
                temporaryTraceWithoutExpectedType.commit();
            }
            IElementType operationType = expression.getOperationSign().getReferencedNameElementType();
            result = operationType == JetTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        } else {
            this.facade.getType(expression.getLeft(), context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        }
        return DataFlowUtils.checkType(result, expression, context);
    }

    private boolean checkBinaryWithTypeRHS(JetBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context, @NotNull JetType targetType, @NotNull JetType expectedType, TemporaryBindingTrace temporaryTrace) {
        ExpressionTypingContext newContext = context.replaceExpectedType(expectedType).replaceBindingTrace(temporaryTrace);
        JetType actualType = this.facade.getType(expression.getLeft(), newContext);
        if (actualType == null) {
            return false;
        }
        JetSimpleNameExpression operationSign = expression.getOperationSign();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.COLON) {
            if (targetType != TypeUtils.NO_EXPECTED_TYPE && !context.semanticServices.getTypeChecker().isSubtypeOf(actualType, targetType)) {
                context.trace.report(Errors.TYPE_MISMATCH.on((PsiElement)expression.getLeft(), targetType, actualType));
                return false;
            }
            return true;
        }
        if (operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
            this.checkForCastImpossibility(expression, actualType, targetType, context);
            return true;
        }
        context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "binary operation with type RHS"));
        return false;
    }

    private void checkForCastImpossibility(JetBinaryExpressionWithTypeRHS expression, JetType actualType, JetType targetType, ExpressionTypingContext context) {
        if (actualType == null || targetType == TypeUtils.NO_EXPECTED_TYPE) {
            return;
        }
        JetTypeChecker typeChecker = context.semanticServices.getTypeChecker();
        if (!typeChecker.isSubtypeOf(targetType, actualType)) {
            if (typeChecker.isSubtypeOf(actualType, targetType)) {
                context.trace.report(Errors.USELESS_CAST_STATIC_ASSERT_IS_FINE.on(expression.getOperationSign()));
            } else {
                context.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression.getOperationSign()));
            }
        } else if (typeChecker.isSubtypeOf(actualType, targetType)) {
            context.trace.report(Errors.USELESS_CAST.on(expression.getOperationSign()));
        } else if (BasicExpressionTypingVisitor.isCastErased(actualType, targetType, typeChecker)) {
            context.trace.report(Errors.UNCHECKED_CAST.on(expression, actualType, targetType));
        }
    }

    public static boolean isCastErased(JetType actualType, JetType targetType, JetTypeChecker typeChecker) {
        int i;
        if (!(targetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return false;
        }
        if (ErrorUtils.isErrorType(actualType) || ErrorUtils.isErrorType(targetType)) {
            return false;
        }
        Multimap<TypeConstructor, TypeProjection> typeSubstitutionMap = TypeUtils.buildDeepSubstitutionMultimap(targetType);
        for (int i2 = 0; i2 < actualType.getConstructor().getParameters().size(); ++i2) {
            TypeProjection actualTypeParameter = actualType.getArguments().get(i2);
            TypeParameterDescriptor subjectTypeParameterDescriptor = actualType.getConstructor().getParameters().get(i2);
            if (subjectTypeParameterDescriptor.isReified()) continue;
            Collection subst = typeSubstitutionMap.get((Object)subjectTypeParameterDescriptor.getTypeConstructor());
            for (TypeProjection proj : subst) {
                if (typeChecker.isSubtypeOf(actualTypeParameter.getType(), proj.getType())) continue;
                return true;
            }
        }
        JetType targetTypeClerared = TypeUtils.makeUnsubstitutedType((ClassDescriptor)targetType.getConstructor().getDeclarationDescriptor(), null);
        Multimap<TypeConstructor, TypeProjection> clearTypeSubstitutionMap = TypeUtils.buildDeepSubstitutionMultimap(targetTypeClerared);
        HashSet<JetType> clearSubstituted = new HashSet<JetType>();
        for (i = 0; i < actualType.getConstructor().getParameters().size(); ++i) {
            TypeParameterDescriptor subjectTypeParameterDescriptor = actualType.getConstructor().getParameters().get(i);
            Collection subst = clearTypeSubstitutionMap.get((Object)subjectTypeParameterDescriptor.getTypeConstructor());
            for (TypeProjection proj : subst) {
                clearSubstituted.add(proj.getType());
            }
        }
        for (i = 0; i < targetType.getConstructor().getParameters().size(); ++i) {
            TypeParameterDescriptor typeParameter = targetType.getConstructor().getParameters().get(i);
            TypeProjection typeProjection = targetType.getArguments().get(i);
            if (typeParameter.isReified() || typeProjection.equals(TypeUtils.makeStarProjection(typeParameter)) || clearSubstituted.contains(typeParameter.getDefaultType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public JetType visitTupleExpression(JetTupleExpression expression, ExpressionTypingContext context) {
        List<JetType> enrichedTypes;
        List<JetExpression> entries = expression.getEntries();
        ArrayList<JetType> types = new ArrayList<JetType>();
        for (JetExpression entry : entries) {
            types.add(context.getServices().safeGetType(context.scope, entry, TypeUtils.NO_EXPECTED_TYPE));
        }
        if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE && JetStandardClasses.isTupleType(context.expectedType) && (enrichedTypes = this.checkArgumentTypes(types, entries, context.expectedType.getArguments(), context)) != types) {
            return JetStandardClasses.getTupleType(enrichedTypes);
        }
        return DataFlowUtils.checkType(JetStandardClasses.getTupleType(types), expression, context);
    }

    @NotNull
    private List<JetType> checkArgumentTypes(@NotNull List<JetType> argumentTypes, @NotNull List<JetExpression> arguments, @NotNull List<TypeProjection> expectedArgumentTypes, @NotNull ExpressionTypingContext context) {
        if (arguments.size() == 0 || argumentTypes.size() != arguments.size() || expectedArgumentTypes.size() != arguments.size()) {
            return argumentTypes;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)arguments.size());
        int argumentTypesSize = argumentTypes.size();
        for (int i = 0; i < argumentTypesSize; ++i) {
            result.add(DataFlowUtils.checkType(argumentTypes.get(i), arguments.get(i), context.replaceExpectedType(expectedArgumentTypes.get(i).getType())));
        }
        return result;
    }

    @Override
    public JetType visitThisExpression(JetThisExpression expression, ExpressionTypingContext context) {
        JetType result = null;
        ReceiverDescriptor thisReceiver = this.resolveToReceiver(expression, context, false);
        if (thisReceiver != null) {
            if (!thisReceiver.exists()) {
                context.trace.report(Errors.NO_THIS.on(expression));
            } else {
                result = thisReceiver.getType();
                context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
            }
        }
        return DataFlowUtils.checkType(result, expression, context);
    }

    @Override
    public JetType visitSuperExpression(JetSuperExpression expression, ExpressionTypingContext context) {
        JetType result;
        block15: {
            block19: {
                TypeSubstitutor substitutor;
                Collection<? extends JetType> supertypes;
                block16: {
                    boolean validType;
                    JetTypeArgumentList redundantTypeArguments;
                    JetType supertype;
                    ClassifierDescriptor classifierCandidate;
                    JetTypeReference superTypeQualifier;
                    block18: {
                        block17: {
                            ReceiverDescriptor thisReceiver;
                            block14: {
                                if (!context.namespacesAllowed) {
                                    context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression, expression.getText()));
                                    return null;
                                }
                                result = null;
                                thisReceiver = this.resolveToReceiver(expression, context, true);
                                if (thisReceiver == null) {
                                    return null;
                                }
                                if (thisReceiver.exists()) break block14;
                                context.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression));
                                break block15;
                            }
                            JetType thisType = thisReceiver.getType();
                            supertypes = thisType.getConstructor().getSupertypes();
                            substitutor = TypeSubstitutor.create(thisType);
                            superTypeQualifier = expression.getSuperTypeQualifier();
                            if (superTypeQualifier == null) break block16;
                            JetTypeElement typeElement = superTypeQualifier.getTypeElement();
                            classifierCandidate = null;
                            supertype = null;
                            redundantTypeArguments = null;
                            if (typeElement instanceof JetUserType) {
                                JetUserType userType = (JetUserType)typeElement;
                                if (userType.getTypeArguments().isEmpty()) {
                                    classifierCandidate = context.getTypeResolver().resolveClass(context.scope, userType);
                                } else {
                                    supertype = context.getTypeResolver().resolveType(context.scope, superTypeQualifier);
                                    redundantTypeArguments = userType.getTypeArgumentList();
                                }
                            } else {
                                supertype = context.getTypeResolver().resolveType(context.scope, superTypeQualifier);
                            }
                            if (supertype == null) break block17;
                            if (!supertypes.contains(supertype)) break block18;
                            result = supertype;
                            break block18;
                        }
                        if (classifierCandidate instanceof ClassDescriptor) {
                            ClassDescriptor superclass = (ClassDescriptor)classifierCandidate;
                            for (JetType jetType : supertypes) {
                                if (!jetType.getConstructor().equals(superclass.getTypeConstructor())) continue;
                                result = substitutor.safeSubstitute(jetType, Variance.INVARIANT);
                                break;
                            }
                        }
                    }
                    boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                    boolean bl = validType = supertype != null && !ErrorUtils.isErrorType(supertype);
                    if (result == null && (validClassifier || validType)) {
                        context.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                    } else if (redundantTypeArguments != null) {
                        context.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on((PsiElement)redundantTypeArguments));
                    }
                    break block19;
                }
                if (supertypes.size() > 1) {
                    context.trace.report(Errors.AMBIGUOUS_SUPER.on(expression));
                } else {
                    JetType type = supertypes.isEmpty() ? JetStandardClasses.getAnyType() : supertypes.iterator().next();
                    result = substitutor.substitute(type, Variance.INVARIANT);
                }
            }
            if (result != null) {
                context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
                context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result.getConstructor().getDeclarationDescriptor());
            }
        }
        return DataFlowUtils.checkType(result, expression, context);
    }

    @Nullable
    private ReceiverDescriptor resolveToReceiver(JetLabelQualifiedInstanceExpression expression, ExpressionTypingContext context, boolean onlyClassReceivers) {
        ReceiverDescriptor thisReceiver = null;
        String labelName = expression.getLabelName();
        if (labelName != null) {
            thisReceiver = context.labelResolver.resolveThisLabel(expression.getInstanceReference(), expression.getTargetLabel(), context, thisReceiver, labelName);
        } else {
            if (onlyClassReceivers) {
                ArrayList receivers = Lists.newArrayList();
                context.scope.getImplicitReceiversHierarchy(receivers);
                for (ReceiverDescriptor receiver : receivers) {
                    if (!(receiver instanceof ClassReceiver)) continue;
                    thisReceiver = receiver;
                    break;
                }
            } else {
                thisReceiver = context.scope.getImplicitReceiver();
            }
            if (thisReceiver instanceof ThisReceiverDescriptor) {
                context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), ((ThisReceiverDescriptor)thisReceiver).getDeclarationDescriptor());
            }
        }
        return thisReceiver;
    }

    @Override
    public JetType visitBlockExpression(JetBlockExpression expression, ExpressionTypingContext context) {
        return this.visitBlockExpression(expression, context, false);
    }

    public JetType visitBlockExpression(JetBlockExpression expression, ExpressionTypingContext context, boolean isStatement) {
        return context.getServices().getBlockReturnedType(context.scope, expression, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context);
    }

    @Override
    public JetType visitHashQualifiedExpression(JetHashQualifiedExpression expression, ExpressionTypingContext context) {
        context.trace.report(Errors.UNSUPPORTED.on((PsiElement)expression, ((Object)((Object)this)).getClass().getCanonicalName()));
        return null;
    }

    @Override
    public JetType visitQualifiedExpression(JetQualifiedExpression expression, ExpressionTypingContext context) {
        JetType result;
        JetExpression selectorExpression = expression.getSelectorExpression();
        JetExpression receiverExpression = expression.getReceiverExpression();
        ExpressionTypingContext contextWithNoExpectedType = context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetType receiverType = this.facade.getType(receiverExpression, contextWithNoExpectedType.replaceExpectedReturnType(TypeUtils.NO_EXPECTED_TYPE).replaceNamespacesAllowed(true));
        if (selectorExpression == null) {
            return null;
        }
        if (receiverType == null) {
            receiverType = ErrorUtils.createErrorType("Type for " + expression.getText());
        }
        if (selectorExpression instanceof JetSimpleNameExpression) {
            this.propagateConstantValues(expression, context, (JetSimpleNameExpression)selectorExpression);
        }
        JetType selectorReturnType = this.getSelectorReturnType(new ExpressionReceiver(receiverExpression, receiverType), expression.getOperationTokenNode(), selectorExpression, context);
        if (expression.getOperationSign() == JetTokens.SAFE_ACCESS && selectorReturnType != null && !selectorReturnType.isNullable() && !JetStandardClasses.isUnit(selectorReturnType) && receiverType.isNullable()) {
            selectorReturnType = TypeUtils.makeNullable(selectorReturnType);
        }
        if (expression.getOperationSign() == JetTokens.QUEST) {
            if (selectorReturnType != null && !ExpressionTypingUtils.isBoolean(context.semanticServices, selectorReturnType)) {
                context.trace.report(Errors.TYPE_MISMATCH.on((PsiElement)selectorExpression, context.semanticServices.getStandardLibrary().getBooleanType(), selectorReturnType));
            }
            result = TypeUtils.makeNullable(receiverType);
        } else {
            result = selectorReturnType;
        }
        if (result != null) {
            context.trace.record(BindingContext.EXPRESSION_TYPE, selectorExpression, result);
        }
        return DataFlowUtils.checkType(result, expression, context);
    }

    private void propagateConstantValues(JetQualifiedExpression expression, ExpressionTypingContext context, JetSimpleNameExpression selectorExpression) {
        JetExpression receiverExpression = expression.getReceiverExpression();
        CompileTimeConstant<?> receiverValue = context.trace.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, receiverExpression);
        CompileTimeConstant<?> wholeExpressionValue = context.trace.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, expression);
        DeclarationDescriptor declarationDescriptor = context.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, selectorExpression);
        if (wholeExpressionValue == null && receiverValue != null && !(receiverValue instanceof ErrorValue) && receiverValue.getValue() instanceof Number && context.semanticServices.getStandardLibrary().getNumber() == declarationDescriptor) {
            Number value = (Number)receiverValue.getValue();
            String referencedName = selectorExpression.getReferencedName();
            if (OperatorConventions.NUMBER_CONVERSIONS.contains((Object)referencedName)) {
                if ("toDouble".equals(referencedName)) {
                    context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new DoubleValue(value.doubleValue()));
                } else if ("toFloat".equals(referencedName)) {
                    context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new FloatValue(value.floatValue()));
                } else if ("toLong".equals(referencedName)) {
                    context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new LongValue(value.longValue()));
                } else if ("toShort".equals(referencedName)) {
                    context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new ShortValue(value.shortValue()));
                } else if ("toByte".equals(referencedName)) {
                    context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new ByteValue(value.byteValue()));
                } else if ("toInt".equals(referencedName)) {
                    context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new IntValue(value.intValue()));
                }
            }
        }
    }

    @Nullable
    public JetType getSelectorReturnType(@NotNull ReceiverDescriptor receiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression selectorExpression, @NotNull ExpressionTypingContext context) {
        if (selectorExpression instanceof JetCallExpression) {
            JetCallExpression callExpression = (JetCallExpression)selectorExpression;
            FunctionDescriptor functionDescriptor = context.resolveCall(receiver, callOperationNode, callExpression);
            BasicExpressionTypingVisitor.checkSuper(receiver, functionDescriptor, context.trace, selectorExpression);
            return functionDescriptor != null ? functionDescriptor.getReturnType() : null;
        }
        if (selectorExpression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)selectorExpression;
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace);
            OverloadResolutionResults<VariableDescriptor> resolutionResult = context.replaceBindingTrace(temporaryTrace).resolveSimpleProperty(receiver, callOperationNode, nameExpression);
            if (resolutionResult.isSuccess()) {
                temporaryTrace.commit();
                VariableDescriptor resultingDescriptor = resolutionResult.getResultingDescriptor();
                BasicExpressionTypingVisitor.checkSuper(receiver, resultingDescriptor, context.trace, selectorExpression);
                return resultingDescriptor.getType();
            }
            if (resolutionResult.isAmbiguity() || resolutionResult.singleResult()) {
                temporaryTrace.commit();
                return null;
            }
            ExpressionTypingContext newContext = receiver.exists() ? context.replaceScope(receiver.getType().getMemberScope()) : context;
            JetType jetType = this.lookupNamespaceOrClassObject(nameExpression, nameExpression.getReferencedName(), newContext);
            if (jetType == null) {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression));
            }
            return jetType;
        }
        if (selectorExpression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)selectorExpression;
            JetExpression newReceiverExpression = qualifiedExpression.getReceiverExpression();
            JetType newReceiverType = this.getSelectorReturnType(receiver, callOperationNode, newReceiverExpression, context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
            JetExpression newSelectorExpression = qualifiedExpression.getSelectorExpression();
            if (newReceiverType != null && newSelectorExpression != null) {
                return this.getSelectorReturnType(new ExpressionReceiver(newReceiverExpression, newReceiverType), qualifiedExpression.getOperationTokenNode(), newSelectorExpression, context);
            }
        } else {
            context.trace.report(Errors.ILLEGAL_SELECTOR.on(selectorExpression, selectorExpression.getText()));
        }
        return null;
    }

    private static void checkSuper(@NotNull ReceiverDescriptor receiverDescriptor, @Nullable DeclarationDescriptor member, @NotNull BindingTrace trace, @NotNull JetExpression expression) {
        if (!(receiverDescriptor instanceof ExpressionReceiver)) {
            return;
        }
        JetExpression receiver = ((ExpressionReceiver)receiverDescriptor).getExpression();
        if (receiver instanceof JetSuperExpression && member instanceof MemberDescriptor && ((MemberDescriptor)member).getModality() == Modality.ABSTRACT) {
            trace.report(Errors.ABSTRACT_SUPER_CALL.on(expression));
        }
    }

    @Override
    public JetType visitCallExpression(JetCallExpression expression, ExpressionTypingContext context) {
        FunctionDescriptor functionDescriptor = context.resolveCall(ReceiverDescriptor.NO_RECEIVER, null, expression);
        JetType expressionType = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
        return DataFlowUtils.checkType(expressionType, expression, context);
    }

    @Override
    public JetType visitUnaryExpression(JetUnaryExpression expression, ExpressionTypingContext context) {
        return this.visitUnaryExpression(expression, context, false);
    }

    public JetType visitUnaryExpression(JetUnaryExpression expression, ExpressionTypingContext context, boolean isStatement) {
        JetType result;
        ExpressionReceiver receiver;
        OverloadResolutionResults<FunctionDescriptor> functionDescriptor;
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return null;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        if (JetTokens.LABELS.contains(operationSign.getReferencedNameElementType())) {
            String referencedName = operationSign.getReferencedName();
            referencedName = referencedName == null ? " <?>" : referencedName;
            context.labelResolver.enterLabeledElement(referencedName.substring(1), baseExpression);
            ExpressionTypingContext newContext = context.replaceExpectedReturnType(context.expectedType);
            JetType type = this.facade.getType(baseExpression, newContext, isStatement);
            context.labelResolver.exitLabeledElement(baseExpression);
            return DataFlowUtils.checkType(type, expression, context);
        }
        IElementType operationType = operationSign.getReferencedNameElementType();
        String name = (String)OperatorConventions.UNARY_OPERATION_NAMES.get((Object)operationType);
        if (name == null) {
            context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "visitUnaryExpression"));
            return null;
        }
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace);
        BindingTrace initialTrace = context.trace;
        JetType type = this.facade.getType(baseExpression, (context = context.replaceBindingTrace(temporaryTrace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        if (type == null) {
            temporaryTrace.commit();
            return null;
        }
        if ((operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) && baseExpression instanceof JetArrayAccessExpression) {
            JetExpression stubExpression = ExpressionTypingUtils.createStubExpressionOfNecessaryType(baseExpression.getProject(), type, context.trace);
            this.resolveArrayAccessSetMethod((JetArrayAccessExpression)baseExpression, stubExpression, context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE).replaceBindingTrace(TemporaryBindingTrace.create(initialTrace)), context.trace);
        }
        if (!(functionDescriptor = context.resolveCallWithGivenNameToDescriptor(CallMaker.makeCall((ReceiverDescriptor)(receiver = new ExpressionReceiver(baseExpression, type)), expression), expression.getOperationReference(), name)).isSuccess()) {
            temporaryTrace.commit();
            return null;
        }
        JetType returnType = functionDescriptor.getResultingDescriptor().getReturnType();
        if (operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) {
            if (context.semanticServices.getTypeChecker().isSubtypeOf(returnType, JetStandardClasses.getUnitType())) {
                result = JetStandardClasses.getUnitType();
                context.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                JetType receiverType = receiver.getType();
                if (!context.semanticServices.getTypeChecker().isSubtypeOf(returnType, receiverType)) {
                    context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name, receiverType, returnType));
                } else {
                    context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
                    ExpressionTypingUtils.checkWrappingInRef(baseExpression, context);
                    this.checkLValue(context.trace, baseExpression);
                }
                result = receiverType;
            }
        } else {
            result = returnType;
        }
        temporaryTrace.commit();
        return DataFlowUtils.checkType(result, expression, context);
    }

    public void checkLValue(BindingTrace trace, JetExpression expression) {
        this.checkLValue(trace, expression, false);
    }

    private void checkLValue(BindingTrace trace, JetExpression expressionWithParenthesis, boolean canBeThis) {
        JetExpression expression = JetPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression instanceof JetArrayAccessExpression) {
            this.checkLValue(trace, ((JetArrayAccessExpression)expressionWithParenthesis).getArrayExpression(), true);
            return;
        }
        if (canBeThis && expression instanceof JetThisExpression) {
            return;
        }
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        if (variable == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(expression != null ? expression : expressionWithParenthesis));
        }
    }

    @Override
    public JetType visitIdeTemplateExpression(JetIdeTemplateExpression expression, ExpressionTypingContext context) {
        context.trace.report(Errors.UNRESOLVED_IDE_TEMPLATE.on(expression, (String)ObjectUtils.notNull((Object)expression.getText(), (Object)"<no name>")));
        return null;
    }

    @Override
    public JetType visitBinaryExpression(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        JetType result = null;
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.IDENTIFIER) {
            String referencedName = operationSign.getReferencedName();
            if (referencedName != null) {
                result = this.getTypeForBinaryCall(context.scope, referencedName, context, expression);
            }
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey((Object)operationType)) {
            result = this.getTypeForBinaryCall(context.scope, (String)OperatorConventions.BINARY_OPERATION_NAMES.get((Object)operationType), context, expression);
        } else if (operationType == JetTokens.EQ) {
            result = this.visitAssignment(expression, contextWithExpectedType);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
            result = this.visitAssignmentOperation(expression, contextWithExpectedType);
        } else if (OperatorConventions.COMPARISON_OPERATIONS.contains((Object)operationType)) {
            JetType compareToReturnType = this.getTypeForBinaryCall(context.scope, "compareTo", context, expression);
            if (compareToReturnType != null) {
                JetStandardLibrary standardLibrary;
                TypeConstructor intTypeConstructor;
                TypeConstructor constructor = compareToReturnType.getConstructor();
                if (constructor.equals(intTypeConstructor = (standardLibrary = context.semanticServices.getStandardLibrary()).getInt().getTypeConstructor())) {
                    result = standardLibrary.getBooleanType();
                } else {
                    context.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
                }
            }
        } else {
            JetType booleanType = context.semanticServices.getStandardLibrary().getBooleanType();
            if (OperatorConventions.EQUALS_OPERATIONS.contains((Object)operationType)) {
                String name = "equals";
                if (right != null) {
                    ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context.replaceScope(context.scope));
                    OverloadResolutionResults<FunctionDescriptor> resolutionResults = context.resolveExactSignature(receiver, "equals", Collections.singletonList(JetStandardClasses.getNullableAnyType()));
                    if (resolutionResults.isSuccess()) {
                        FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
                        context.trace.record(BindingContext.REFERENCE_TARGET, operationSign, equals);
                        if (ExpressionTypingUtils.ensureBooleanResult(operationSign, name, equals.getReturnType(), context)) {
                            this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
                        }
                    } else if (resolutionResults.isAmbiguity()) {
                        context.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
                    } else {
                        context.trace.report(Errors.EQUALS_MISSING.on(operationSign));
                    }
                }
                result = booleanType;
            } else if (operationType == JetTokens.EQEQEQ || operationType == JetTokens.EXCLEQEQEQ) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
                result = booleanType;
            } else if (OperatorConventions.IN_OPERATIONS.contains((Object)operationType)) {
                if (right == null) {
                    result = ErrorUtils.createErrorType("No right argument");
                    return null;
                }
                this.checkInExpression(expression, expression.getOperationReference(), expression.getLeft(), expression.getRight(), context);
                result = booleanType;
            } else if (operationType == JetTokens.ANDAND || operationType == JetTokens.OROR) {
                JetType rightType;
                JetType leftType = this.facade.getType(left, context.replaceScope(context.scope));
                WritableScopeImpl leftScope = ExpressionTypingUtils.newWritableScopeImpl(context).setDebugName("Left scope of && or ||");
                DataFlowInfo flowInfoLeft = DataFlowUtils.extractDataFlowInfoFromCondition(left, operationType == JetTokens.ANDAND, leftScope, context);
                WritableScopeImpl rightScope = operationType == JetTokens.ANDAND ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context).setDebugName("Right scope of && or ||");
                JetType jetType = rightType = right == null ? null : this.facade.getType(right, context.replaceDataFlowInfo(flowInfoLeft).replaceScope(rightScope));
                if (leftType != null && !ExpressionTypingUtils.isBoolean(context.semanticServices, leftType)) {
                    context.trace.report(Errors.TYPE_MISMATCH.on((PsiElement)left, booleanType, leftType));
                }
                if (rightType != null && !ExpressionTypingUtils.isBoolean(context.semanticServices, rightType)) {
                    context.trace.report(Errors.TYPE_MISMATCH.on((PsiElement)right, booleanType, rightType));
                }
                result = booleanType;
            } else if (operationType == JetTokens.ELVIS) {
                JetType rightType;
                JetType leftType = this.facade.getType(left, context.replaceScope(context.scope));
                JetType jetType = rightType = right == null ? null : this.facade.getType(right, contextWithExpectedType.replaceScope(context.scope));
                if (leftType != null) {
                    if (!leftType.isNullable()) {
                        context.trace.report(Errors.USELESS_ELVIS.on(left, leftType));
                    }
                    if (rightType != null) {
                        DataFlowUtils.checkType(TypeUtils.makeNullableAsSpecified(leftType, rightType.isNullable()), left, contextWithExpectedType);
                        return TypeUtils.makeNullableAsSpecified(CommonSupertypes.commonSupertype(Arrays.asList(leftType, rightType)), rightType.isNullable());
                    }
                }
            } else {
                context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "Unknown operation"));
            }
        }
        return DataFlowUtils.checkType(result, expression, contextWithExpectedType);
    }

    public boolean checkInExpression(JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @Nullable JetExpression left, @NotNull JetExpression right, ExpressionTypingContext context) {
        String name = "contains";
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = context.resolveCallWithGivenNameToDescriptor(CallMaker.makeCallWithExpressions(callElement, receiver, null, operationSign, Collections.singletonList(left)), operationSign, name);
        JetType containsType = OverloadResolutionResultsUtil.getResultType(resolutionResult);
        ExpressionTypingUtils.ensureBooleanResult(operationSign, name, containsType, context);
        return resolutionResult.isSuccess();
    }

    private void ensureNonemptyIntersectionOfOperandTypes(JetBinaryExpression expression, ExpressionTypingContext context) {
        JetType intersect;
        JetType rightType;
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        JetType leftType = this.facade.getType(left, context.replaceScope(context.scope));
        if (leftType != null && right != null && (rightType = this.facade.getType(right, context.replaceScope(context.scope))) != null && (intersect = TypeUtils.intersect(context.semanticServices.getTypeChecker(), new HashSet<JetType>(Arrays.asList(leftType, rightType)))) == null) {
            context.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression, operationSign, leftType, rightType));
        }
    }

    protected JetType visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression, context);
    }

    protected JetType visitAssignment(JetBinaryExpression expression, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression, context);
    }

    private JetType assignmentIsNotAnExpressionError(JetBinaryExpression expression, ExpressionTypingContext context) {
        this.facade.checkStatementType(expression, context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        context.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression));
        return null;
    }

    @Override
    public JetType visitArrayAccessExpression(JetArrayAccessExpression expression, ExpressionTypingContext context) {
        JetType type = this.resolveArrayAccessGetMethod(expression, context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        DataFlowUtils.checkType(type, expression, context);
        return type;
    }

    @Nullable
    public JetType getTypeForBinaryCall(JetScope scope, String name, ExpressionTypingContext context, JetBinaryExpression binaryExpression) {
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, binaryExpression.getLeft(), context.replaceScope(scope));
        return OverloadResolutionResultsUtil.getResultType(this.getResolutionResultsForBinaryCall(scope, name, context, binaryExpression, receiver));
    }

    @NotNull
    OverloadResolutionResults<FunctionDescriptor> getResolutionResultsForBinaryCall(JetScope scope, String name, ExpressionTypingContext context, JetBinaryExpression binaryExpression, ExpressionReceiver receiver) {
        return context.replaceScope(scope).resolveCallWithGivenNameToDescriptor(CallMaker.makeCall((ReceiverDescriptor)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
    }

    @Override
    public JetType visitDeclaration(JetDeclaration dcl, ExpressionTypingContext context) {
        context.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(dcl));
        return null;
    }

    @Override
    public JetType visitRootNamespaceExpression(JetRootNamespaceExpression expression, ExpressionTypingContext context) {
        if (context.namespacesAllowed) {
            return DataFlowUtils.checkType(JetModuleUtil.getRootNamespaceType(expression), expression, context);
        }
        context.trace.report(Errors.NAMESPACE_IS_NOT_AN_EXPRESSION.on(expression));
        return null;
    }

    @Override
    public JetType visitStringTemplateExpression(JetStringTemplateExpression expression, ExpressionTypingContext contextWithExpectedType) {
        final ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        final StringBuilder builder = new StringBuilder();
        final CompileTimeConstant[] value = new CompileTimeConstant[1];
        for (JetStringTemplateEntry entry : expression.getEntries()) {
            entry.accept(new JetVisitorVoid(){

                @Override
                public void visitStringTemplateEntryWithExpression(JetStringTemplateEntryWithExpression entry) {
                    JetExpression entryExpression = entry.getExpression();
                    if (entryExpression != null) {
                        BasicExpressionTypingVisitor.this.facade.getType(entryExpression, context);
                    }
                    value[0] = CompileTimeConstantResolver.OUT_OF_RANGE;
                }

                @Override
                public void visitLiteralStringTemplateEntry(JetLiteralStringTemplateEntry entry) {
                    builder.append(entry.getText());
                }

                @Override
                public void visitEscapeStringTemplateEntry(JetEscapeStringTemplateEntry entry) {
                    String text = entry.getText();
                    CompileTimeConstant<?> character = CompileTimeConstantResolver.escapedStringToCharValue(text);
                    if (character instanceof ErrorValue) {
                        context.trace.report(Errors.ILLEGAL_ESCAPE_SEQUENCE.on(entry));
                        value[0] = CompileTimeConstantResolver.OUT_OF_RANGE;
                    } else {
                        builder.append(((CharValue)character).getValue());
                    }
                }
            });
        }
        if (value[0] != CompileTimeConstantResolver.OUT_OF_RANGE) {
            context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new StringValue(builder.toString()));
        }
        return DataFlowUtils.checkType(context.semanticServices.getStandardLibrary().getStringType(), expression, contextWithExpectedType);
    }

    @Override
    public JetType visitAnnotatedExpression(JetAnnotatedExpression expression, ExpressionTypingContext data) {
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return null;
        }
        return this.facade.getType(baseExpression, data);
    }

    @Override
    public JetType visitJetElement(JetElement element, ExpressionTypingContext context) {
        context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element, ((Object)((Object)this)).getClass().getCanonicalName()));
        return null;
    }

    @Nullable
    JetType resolveArrayAccessSetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false);
    }

    @Nullable
    JetType resolveArrayAccessGetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context, context.trace, true);
    }

    @Nullable
    private JetType resolveArrayAccessSpecialMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @Nullable JetExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult, boolean isGet) {
        JetType arrayType = this.facade.getType(arrayAccessExpression.getArrayExpression(), context);
        if (arrayType == null) {
            return null;
        }
        ExpressionReceiver receiver = new ExpressionReceiver(arrayAccessExpression.getArrayExpression(), arrayType);
        if (!isGet) assert (rightHandSide != null);
        OverloadResolutionResults<FunctionDescriptor> functionResults = context.resolveCallWithGivenName(isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide), arrayAccessExpression, isGet ? "get" : "set");
        if (!functionResults.isSuccess()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            return null;
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        return functionResults.getResultingDescriptor().getReturnType();
    }
}

