/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.util.CommonSuppliers;

public class TypeUtils {
    public static final JetType FORBIDDEN = new JetType(){

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNullable() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "FORBIDDEN";
        }
    };
    public static final JetType NO_EXPECTED_TYPE = new JetType(){

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNullable() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "NO_EXPECTED_TYPE";
        }
    };

    @NotNull
    public static JetType makeNullable(@NotNull JetType type) {
        return TypeUtils.makeNullableAsSpecified(type, true);
    }

    @NotNull
    public static JetType makeNotNullable(@NotNull JetType type) {
        return TypeUtils.makeNullableAsSpecified(type, false);
    }

    @NotNull
    public static JetType makeNullableAsSpecified(@NotNull JetType type, boolean nullable) {
        if (type.isNullable() == nullable) {
            return type;
        }
        if (ErrorUtils.isErrorType(type)) {
            return type;
        }
        return new JetTypeImpl(type.getAnnotations(), type.getConstructor(), nullable, type.getArguments(), type.getMemberScope());
    }

    @NotNull
    public static JetType safeIntersect(JetTypeChecker typeChecker, Set<JetType> types) {
        JetType intersection = TypeUtils.intersect(typeChecker, types);
        if (intersection == null) {
            return ErrorUtils.createErrorType("No intersection for " + types);
        }
        return intersection;
    }

    @Nullable
    public static JetType intersect(@NotNull JetTypeChecker typeChecker, @NotNull Set<JetType> types) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return types.iterator().next();
        }
        boolean allNullable = true;
        boolean nothingTypePresent = false;
        ArrayList nullabilityStripped = Lists.newArrayList();
        for (JetType type : types) {
            nothingTypePresent |= JetStandardClasses.isNothingOrNullableNothing(type);
            allNullable &= type.isNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type));
        }
        if (nothingTypePresent) {
            return allNullable ? JetStandardClasses.getNullableNothingType() : JetStandardClasses.getNothingType();
        }
        ArrayList resultingTypes = Lists.newArrayList();
        block1: for (JetType type : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker, type)) {
                for (JetType other : nullabilityStripped) {
                    if (((Object)type).equals(other) || typeChecker.isSubtypeOf(type, other) || typeChecker.isSubtypeOf(other, type)) continue;
                    return null;
                }
                return TypeUtils.makeNullableAsSpecified(type, allNullable);
            }
            for (JetType other : nullabilityStripped) {
                if (((Object)type).equals(other) || !typeChecker.isSubtypeOf(other, type)) continue;
                continue block1;
            }
            resultingTypes.add(type);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((JetType)resultingTypes.get(0), allNullable);
        }
        List<AnnotationDescriptor> noAnnotations = Collections.emptyList();
        TypeConstructorImpl constructor = new TypeConstructorImpl(null, noAnnotations, false, TypeUtils.makeDebugNameForIntersectionType(resultingTypes).toString(), Collections.<TypeParameterDescriptor>emptyList(), resultingTypes);
        JetScope[] scopes = new JetScope[resultingTypes.size()];
        int i = 0;
        for (JetType type : resultingTypes) {
            scopes[i] = type.getMemberScope();
            ++i;
        }
        return new JetTypeImpl(noAnnotations, constructor, allNullable, Collections.<TypeProjection>emptyList(), new ChainedScope(null, scopes));
    }

    private static StringBuilder makeDebugNameForIntersectionType(Iterable<JetType> resultingTypes) {
        StringBuilder debugName = new StringBuilder("{");
        Iterator<JetType> iterator = resultingTypes.iterator();
        while (iterator.hasNext()) {
            JetType type = iterator.next();
            debugName.append(type.toString());
            if (!iterator.hasNext()) continue;
            debugName.append(" & ");
        }
        debugName.append("}");
        return debugName;
    }

    public static boolean canHaveSubtypes(JetTypeChecker typeChecker, JetType type) {
        if (type.isNullable()) {
            return true;
        }
        if (!type.getConstructor().isSealed()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters = type.getConstructor().getParameters();
        List<TypeProjection> arguments = type.getArguments();
        int parametersSize = parameters.size();
        block10: for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters.get(i);
            TypeProjection typeProjection = arguments.get(i);
            Variance projectionKind = typeProjection.getProjectionKind();
            JetType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(JetTypeChecker typeChecker, JetType argument, TypeParameterDescriptor parameterDescriptor) {
        for (JetType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    public static JetType makeNullableIfNeeded(JetType type, boolean nullable) {
        if (nullable) {
            return TypeUtils.makeNullable(type);
        }
        return type;
    }

    @NotNull
    public static JetType makeUnsubstitutedType(ClassDescriptor classDescriptor, JetScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classDescriptor)) {
            return ErrorUtils.createErrorType("This is very helpful diagnostics message");
        }
        List<TypeProjection> arguments = TypeUtils.getDefaultTypeProjections(classDescriptor.getTypeConstructor().getParameters());
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), classDescriptor.getTypeConstructor(), false, arguments, unsubstitutedMemberScope);
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(List<TypeParameterDescriptor> parameters) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>();
        for (TypeParameterDescriptor parameterDescriptor : parameters) {
            result.add(new TypeProjection(parameterDescriptor.getDefaultType()));
        }
        return result;
    }

    @NotNull
    public static List<JetType> getDefaultTypes(List<TypeParameterDescriptor> parameters) {
        ArrayList result = Lists.newArrayList();
        for (TypeParameterDescriptor parameterDescriptor : parameters) {
            result.add(parameterDescriptor.getDefaultType());
        }
        return result;
    }

    @NotNull
    public static Map<TypeConstructor, TypeProjection> buildSubstitutionContext(@NotNull JetType context) {
        return TypeUtils.buildSubstitutionContext(context.getConstructor().getParameters(), context.getArguments());
    }

    @NotNull
    public static TypeSubstitutor buildDeepSubstitutor(@NotNull JetType type) {
        HashMap substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        TypeUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, null);
        return typeSubstitutor;
    }

    @NotNull
    public static Multimap<TypeConstructor, TypeProjection> buildDeepSubstitutionMultimap(@NotNull JetType type) {
        SetMultimap fullSubstitution = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        HashMap substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        TypeUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, fullSubstitution);
        return fullSubstitution;
    }

    private static void fillInDeepSubstitutor(@NotNull JetType context, @NotNull TypeSubstitutor substitutor, @NotNull Map<TypeConstructor, TypeProjection> substitution, @Nullable Multimap<TypeConstructor, TypeProjection> fullSubstitution) {
        List<TypeParameterDescriptor> parameters = context.getConstructor().getParameters();
        List<TypeProjection> arguments = context.getArguments();
        if (parameters.size() != arguments.size()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < arguments.size(); ++i) {
            TypeProjection typeProjection = arguments.get(i);
            TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
            JetType substitute = substitutor.substitute(typeProjection.getType(), Variance.INVARIANT);
            assert (substitute != null);
            TypeProjection substitutedTypeProjection = new TypeProjection(typeProjection.getProjectionKind(), substitute);
            substitution.put(typeParameterDescriptor.getTypeConstructor(), substitutedTypeProjection);
            if (fullSubstitution == null) continue;
            fullSubstitution.put((Object)typeParameterDescriptor.getTypeConstructor(), (Object)substitutedTypeProjection);
        }
        if (JetStandardClasses.isNothingOrNullableNothing(context)) {
            return;
        }
        for (JetType jetType : context.getConstructor().getSupertypes()) {
            TypeUtils.fillInDeepSubstitutor(jetType, substitutor, substitution, fullSubstitution);
        }
    }

    @NotNull
    public static Map<TypeConstructor, TypeProjection> buildSubstitutionContext(@NotNull List<TypeParameterDescriptor> parameters, @NotNull List<TypeProjection> contextArguments) {
        HashMap<TypeConstructor, TypeProjection> parameterValues = new HashMap<TypeConstructor, TypeProjection>();
        TypeUtils.fillInSubstitutionContext(parameters, contextArguments, parameterValues);
        return parameterValues;
    }

    private static void fillInSubstitutionContext(List<TypeParameterDescriptor> parameters, List<TypeProjection> contextArguments, Map<TypeConstructor, TypeProjection> parameterValues) {
        int parametersSize = parameters.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameter = parameters.get(i);
            TypeProjection value = contextArguments.get(i);
            parameterValues.put(parameter.getTypeConstructor(), value);
        }
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        return new TypeProjection(Variance.OUT_VARIANCE, parameterDescriptor.getUpperBoundsAsType());
    }

    private static void collectImmediateSupertypes(@NotNull JetType type, @NotNull Collection<JetType> result) {
        TypeSubstitutor substitutor = TypeSubstitutor.create(type);
        for (JetType jetType : type.getConstructor().getSupertypes()) {
            result.add(substitutor.substitute(jetType, Variance.INVARIANT));
        }
    }

    @NotNull
    public static List<JetType> getImmediateSupertypes(@NotNull JetType type) {
        ArrayList result = Lists.newArrayList();
        TypeUtils.collectImmediateSupertypes(type, result);
        return result;
    }

    private static void collectAllSupertypes(@NotNull JetType type, @NotNull Set<JetType> result) {
        List<JetType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type);
        result.addAll(immediateSupertypes);
        for (JetType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result);
        }
    }

    @NotNull
    public static Set<JetType> getAllSupertypes(@NotNull JetType type) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        TypeUtils.collectAllSupertypes(type, result);
        return result;
    }

    public static boolean hasNullableLowerBound(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        for (JetType bound : typeParameterDescriptor.getLowerBounds()) {
            if (!bound.isNullable()) continue;
            return true;
        }
        return false;
    }

    public static boolean equalClasses(@NotNull JetType type1, @NotNull JetType type2) {
        ClassifierDescriptor declarationDescriptor1 = type1.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor1 == null) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor2 == null) {
            return false;
        }
        return declarationDescriptor1.getOriginal().equals(declarationDescriptor2.getOriginal());
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull JetType type) {
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    public static boolean hasUnsubstitutedTypeParameters(JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return true;
        }
        for (TypeProjection proj : type.getArguments()) {
            if (!TypeUtils.hasUnsubstitutedTypeParameters(proj.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        return JetTypeChecker.INSTANCE.isSubtypeOf(a, b) && JetTypeChecker.INSTANCE.isSubtypeOf(b, a);
    }
}

