/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.types.CompositeTypeSubstitution;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;

public class TypeSubstitutor {
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    @NotNull
    private final TypeSubstitution substitution;

    public static TypeSubstitutor makeConstantSubstitutor(Collection<TypeParameterDescriptor> typeParameterDescriptors, JetType type) {
        final HashSet constructors = Sets.newHashSet();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
            constructors.add(typeParameterDescriptor.getTypeConstructor());
        }
        final TypeProjection projection = new TypeProjection(type);
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (constructors.contains(key)) {
                    return projection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
    }

    public static TypeSubstitutor create(@NotNull TypeSubstitution substitution) {
        return new TypeSubstitutor(substitution);
    }

    public static TypeSubstitutor create(TypeSubstitution ... substitutions) {
        return TypeSubstitutor.create((TypeSubstitution)new CompositeTypeSubstitution(substitutions));
    }

    public static TypeSubstitutor create(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
        return TypeSubstitutor.create((TypeSubstitution)new MapToTypeSubstitutionAdapter(substitutionContext));
    }

    public static TypeSubstitutor create(@NotNull JetType context) {
        return TypeSubstitutor.create(TypeUtils.buildSubstitutionContext(context));
    }

    protected TypeSubstitutor(@NotNull TypeSubstitution substitution) {
        this.substitution = substitution;
    }

    public boolean inRange(@NotNull TypeConstructor typeConstructor) {
        return this.substitution.get(typeConstructor) != null;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    @NotNull
    public TypeSubstitution getSubstitution() {
        return this.substitution;
    }

    @NotNull
    public JetType safeSubstitute(@NotNull JetType type, @NotNull Variance howThisTypeIsUsed) {
        if (this.isEmpty()) {
            return type;
        }
        try {
            return this.unsafeSubstitute(type, howThisTypeIsUsed);
        }
        catch (SubstitutionException e) {
            return ErrorUtils.createErrorType(e.getMessage());
        }
    }

    @Nullable
    public JetType substitute(@NotNull JetType type, @NotNull Variance howThisTypeIsUsed) {
        if (this.isEmpty()) {
            return type;
        }
        try {
            return this.unsafeSubstitute(type, howThisTypeIsUsed);
        }
        catch (SubstitutionException e) {
            return null;
        }
    }

    @NotNull
    private JetType unsafeSubstitute(@NotNull JetType type, @NotNull Variance howThisTypeIsUsed) throws SubstitutionException {
        if (ErrorUtils.isErrorType(type)) {
            return type;
        }
        TypeProjection value = this.getValueWithCorrectNullability(this.substitution, type);
        if (value != null) {
            TypeConstructor constructor = type.getConstructor();
            assert (constructor.getDeclarationDescriptor() instanceof TypeParameterDescriptor);
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)constructor.getDeclarationDescriptor();
            TypeProjection result = this.substitutionResult(typeParameterDescriptor, howThisTypeIsUsed, Variance.INVARIANT, value);
            return TypeUtils.makeNullableIfNeeded(result.getType(), type.isNullable());
        }
        return this.specializeType(type, howThisTypeIsUsed);
    }

    private TypeProjection getValueWithCorrectNullability(TypeSubstitution substitution, JetType type) {
        TypeProjection typeProjection = substitution.get(type.getConstructor());
        if (typeProjection == null) {
            return null;
        }
        return type.isNullable() ? TypeSubstitutor.makeNullableProjection(typeProjection) : typeProjection;
    }

    @NotNull
    private static TypeProjection makeNullableProjection(@NotNull TypeProjection value) {
        return new TypeProjection(value.getProjectionKind(), TypeUtils.makeNullable(value.getType()));
    }

    private JetType specializeType(JetType subjectType, Variance callSiteVariance) throws SubstitutionException {
        if (ErrorUtils.isErrorType(subjectType)) {
            return subjectType;
        }
        ArrayList<TypeProjection> newArguments = new ArrayList<TypeProjection>();
        List<TypeProjection> arguments = subjectType.getArguments();
        int argumentsSize = arguments.size();
        for (int i = 0; i < argumentsSize; ++i) {
            TypeProjection argument = arguments.get(i);
            TypeParameterDescriptor parameterDescriptor = subjectType.getConstructor().getParameters().get(i);
            newArguments.add(this.substituteInProjection(this.substitution, argument, parameterDescriptor, callSiteVariance));
        }
        return new JetTypeImpl(subjectType.getAnnotations(), subjectType.getConstructor(), subjectType.isNullable(), newArguments, new SubstitutingScope(subjectType.getMemberScope(), this));
    }

    @NotNull
    private TypeProjection substituteInProjection(@NotNull TypeSubstitution substitutionContext, @NotNull TypeProjection passedProjection, @NotNull TypeParameterDescriptor correspondingTypeParameter, @NotNull Variance contextCallSiteVariance) throws SubstitutionException {
        JetType typeToSubstituteIn = passedProjection.getType();
        if (ErrorUtils.isErrorType(typeToSubstituteIn)) {
            return passedProjection;
        }
        Variance passedProjectionKind = passedProjection.getProjectionKind();
        Variance parameterVariance = correspondingTypeParameter.getVariance();
        Variance effectiveProjectionKind = TypeSubstitutor.asymmetricOr(passedProjectionKind, parameterVariance);
        Variance effectiveContextVariance = contextCallSiteVariance.superpose(effectiveProjectionKind);
        TypeProjection projectionValue = this.getValueWithCorrectNullability(substitutionContext, typeToSubstituteIn);
        if (projectionValue != null) {
            assert (typeToSubstituteIn.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor);
            if (!TypeSubstitutor.allows(parameterVariance, passedProjectionKind)) {
                return TypeUtils.makeStarProjection(correspondingTypeParameter);
            }
            return this.substitutionResult(correspondingTypeParameter, effectiveContextVariance, passedProjectionKind, projectionValue);
        }
        return new TypeProjection(passedProjectionKind, this.specializeType(typeToSubstituteIn, effectiveContextVariance));
    }

    private TypeProjection substitutionResult(TypeParameterDescriptor correspondingTypeParameter, Variance effectiveContextVariance, Variance passedProjectionKind, TypeProjection value) throws SubstitutionException {
        JetType effectiveTypeValue;
        Variance projectionKindValue = value.getProjectionKind();
        JetType typeValue = value.getType();
        Variance effectiveProjectionKindValue = TypeSubstitutor.asymmetricOr(passedProjectionKind, projectionKindValue);
        switch (effectiveContextVariance) {
            case INVARIANT: {
                effectiveProjectionKindValue = projectionKindValue;
                effectiveTypeValue = typeValue;
                break;
            }
            case IN_VARIANCE: {
                if (projectionKindValue == Variance.OUT_VARIANCE) {
                    throw new SubstitutionException("");
                }
                effectiveTypeValue = typeValue;
                break;
            }
            case OUT_VARIANCE: {
                if (projectionKindValue == Variance.IN_VARIANCE) {
                    effectiveProjectionKindValue = Variance.INVARIANT;
                    effectiveTypeValue = correspondingTypeParameter.getUpperBoundsAsType();
                    break;
                }
                effectiveTypeValue = typeValue;
                break;
            }
            default: {
                throw new IllegalStateException(effectiveContextVariance.toString());
            }
        }
        return new TypeProjection(effectiveProjectionKindValue, this.specializeType(effectiveTypeValue, effectiveContextVariance));
    }

    private static Variance asymmetricOr(Variance a, Variance b) {
        return a == Variance.INVARIANT ? b : a;
    }

    private static boolean allows(Variance declarationSiteVariance, Variance callSiteVariance) {
        switch (declarationSiteVariance) {
            case INVARIANT: {
                return true;
            }
            case IN_VARIANCE: {
                return callSiteVariance != Variance.OUT_VARIANCE;
            }
            case OUT_VARIANCE: {
                return callSiteVariance != Variance.IN_VARIANCE;
            }
        }
        throw new IllegalStateException(declarationSiteVariance.toString());
    }

    public static final class SubstitutionException
    extends Exception {
        public SubstitutionException(String message) {
            super(message);
        }
    }

    public static class MapToTypeSubstitutionAdapter
    implements TypeSubstitution {
        @NotNull
        private final Map<TypeConstructor, TypeProjection> substitutionContext;

        public MapToTypeSubstitutionAdapter(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
            this.substitutionContext = substitutionContext;
        }

        @Override
        public TypeProjection get(TypeConstructor key) {
            return this.substitutionContext.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.substitutionContext.isEmpty();
        }
    }

    public static interface TypeSubstitution {
        public static final TypeSubstitution EMPTY = new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                return null;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        };

        @Nullable
        public TypeProjection get(TypeConstructor var1);

        public boolean isEmpty();
    }
}

