/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;

public class JetStandardClasses {
    static NamespaceDescriptorImpl STANDARD_CLASSES_NAMESPACE;
    private static final ClassDescriptor NOTHING_CLASS;
    private static final JetType NOTHING_TYPE;
    private static final JetType NULLABLE_NOTHING_TYPE;
    private static final ClassDescriptor ANY;
    private static final JetType ANY_TYPE;
    private static final JetType NULLABLE_ANY_TYPE;
    private static final JetType DEFAULT_BOUND;
    public static final JetScope STUB;
    public static final int TUPLE_COUNT = 22;
    private static final Set<TypeConstructor> TUPLE_CONSTRUCTORS;
    private static final ClassDescriptor[] TUPLE;
    public static final int FUNCTION_COUNT = 22;
    private static final ClassDescriptor[] FUNCTION;
    private static final ClassDescriptor[] RECEIVER_FUNCTION;
    private static final Set<TypeConstructor> FUNCTION_TYPE_CONSTRUCTORS;
    private static final Set<TypeConstructor> RECEIVER_FUNCTION_TYPE_CONSTRUCTORS;
    private static final JetType UNIT_TYPE;
    @NotNull
    static final JetScope STANDARD_CLASSES;

    private JetStandardClasses() {
    }

    private static List<TypeParameterDescriptor> createTypeParameters(int parameterCount, ClassDescriptorImpl function) {
        ArrayList<TypeParameterDescriptor> parameters = new ArrayList<TypeParameterDescriptor>();
        for (int j = 0; j < parameterCount; ++j) {
            parameters.add(TypeParameterDescriptor.createWithDefaultBound(function, Collections.<AnnotationDescriptor>emptyList(), true, Variance.IN_VARIANCE, "P" + j, j + 1));
        }
        parameters.add(TypeParameterDescriptor.createWithDefaultBound(function, Collections.<AnnotationDescriptor>emptyList(), true, Variance.OUT_VARIANCE, "R", parameterCount + 1));
        return parameters;
    }

    @NotNull
    public static JetType getDefaultBound() {
        return DEFAULT_BOUND;
    }

    @NotNull
    public static ClassDescriptor getAny() {
        return ANY;
    }

    @NotNull
    public static JetType getAnyType() {
        return ANY_TYPE;
    }

    public static boolean isAny(JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == ANY_TYPE.getConstructor();
    }

    public static JetType getNullableAnyType() {
        return NULLABLE_ANY_TYPE;
    }

    @NotNull
    public static ClassDescriptor getNothing() {
        return NOTHING_CLASS;
    }

    @NotNull
    public static ClassDescriptor getTuple(int size) {
        return TUPLE[size];
    }

    @NotNull
    public static ClassDescriptor getFunction(int parameterCount) {
        return FUNCTION[parameterCount];
    }

    @NotNull
    public static ClassDescriptor getReceiverFunction(int parameterCount) {
        return RECEIVER_FUNCTION[parameterCount];
    }

    public static JetType getUnitType() {
        return UNIT_TYPE;
    }

    public static JetType getNothingType() {
        return NOTHING_TYPE;
    }

    public static JetType getNullableNothingType() {
        return NULLABLE_NOTHING_TYPE;
    }

    public static boolean isNothing(@NotNull JetType type) {
        return JetStandardClasses.isNothingOrNullableNothing(type) && !type.isNullable();
    }

    public static boolean isNothingOrNullableNothing(@NotNull JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == NOTHING_CLASS.getTypeConstructor();
    }

    public static boolean isUnit(@NotNull JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == UNIT_TYPE.getConstructor();
    }

    public static JetType getTupleType(List<AnnotationDescriptor> annotations, List<JetType> arguments) {
        if (annotations.isEmpty() && arguments.isEmpty()) {
            return JetStandardClasses.getUnitType();
        }
        ClassDescriptor tuple = JetStandardClasses.getTuple(arguments.size());
        List<TypeProjection> typeArguments = JetStandardClasses.toProjections(arguments);
        return new JetTypeImpl(annotations, tuple.getTypeConstructor(), false, typeArguments, tuple.getMemberScope(typeArguments));
    }

    public static JetType getTupleType(List<JetType> arguments) {
        return JetStandardClasses.getTupleType(Collections.<AnnotationDescriptor>emptyList(), arguments);
    }

    public static JetType getTupleType(JetType ... arguments) {
        return JetStandardClasses.getTupleType(Collections.<AnnotationDescriptor>emptyList(), Arrays.asList(arguments));
    }

    public static boolean isTupleType(@NotNull JetType type) {
        return TUPLE_CONSTRUCTORS.contains(type.getConstructor());
    }

    public static JetType getLabeledTupleType(List<AnnotationDescriptor> annotations, List<ValueParameterDescriptor> arguments) {
        return JetStandardClasses.getTupleType(annotations, JetStandardClasses.toTypes(arguments));
    }

    public static JetType getLabeledTupleType(List<ValueParameterDescriptor> arguments) {
        return JetStandardClasses.getLabeledTupleType(Collections.<AnnotationDescriptor>emptyList(), arguments);
    }

    private static List<TypeProjection> toProjections(List<JetType> arguments) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>();
        for (JetType argument : arguments) {
            result.add(new TypeProjection(Variance.OUT_VARIANCE, argument));
        }
        return result;
    }

    private static List<JetType> toTypes(List<ValueParameterDescriptor> labeledEntries) {
        ArrayList<JetType> result = new ArrayList<JetType>();
        for (ValueParameterDescriptor entry : labeledEntries) {
            result.add(entry.getType());
        }
        return result;
    }

    public static JetType getFunctionType(List<AnnotationDescriptor> annotations, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        ArrayList<TypeProjection> arguments = new ArrayList<TypeProjection>();
        if (receiverType != null) {
            arguments.add(JetStandardClasses.defaultProjection(receiverType));
        }
        for (JetType parameterType : parameterTypes) {
            arguments.add(JetStandardClasses.defaultProjection(parameterType));
        }
        arguments.add(JetStandardClasses.defaultProjection(returnType));
        int size = parameterTypes.size();
        TypeConstructor constructor = receiverType == null ? FUNCTION[size].getTypeConstructor() : RECEIVER_FUNCTION[size].getTypeConstructor();
        return new JetTypeImpl(annotations, constructor, false, arguments, STUB);
    }

    private static TypeProjection defaultProjection(JetType returnType) {
        return new TypeProjection(Variance.INVARIANT, returnType);
    }

    public static boolean isFunctionType(@NotNull JetType type) {
        return FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor()) || RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor());
    }

    @Nullable
    public static JetType getReceiverType(@NotNull JetType type) {
        assert (JetStandardClasses.isFunctionType(type)) : type;
        if (RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor())) {
            return type.getArguments().get(0).getType();
        }
        return null;
    }

    @NotNull
    public static List<ValueParameterDescriptor> getValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetType type) {
        assert (JetStandardClasses.isFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        int first = RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor()) ? 1 : 0;
        int last = arguments.size() - 2;
        ArrayList valueParameters = Lists.newArrayList();
        for (int i = first; i <= last; ++i) {
            JetType parameterType = arguments.get(i).getType();
            ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, i - first, Collections.<AnnotationDescriptor>emptyList(), "p" + i, false, parameterType, false, null);
            valueParameters.add(valueParameterDescriptor);
        }
        return valueParameters;
    }

    @NotNull
    public static JetType getReturnTypeFromFunctionType(@NotNull JetType type) {
        assert (JetStandardClasses.isFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        return arguments.get(arguments.size() - 1).getType();
    }

    static {
        Field[] declaredFields;
        int i;
        STANDARD_CLASSES_NAMESPACE = new NamespaceDescriptorImpl(null, Collections.<AnnotationDescriptor>emptyList(), "jet");
        NOTHING_CLASS = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), "Nothing").initialize(true, Collections.<TypeParameterDescriptor>emptyList(), (Collection<JetType>)new AbstractCollection<JetType>(){

            @Override
            public boolean contains(Object o) {
                return o instanceof JetType;
            }

            @Override
            public Iterator<JetType> iterator() {
                throw new UnsupportedOperationException("Don't enumerate supertypes of Nothing");
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException("Supertypes of Nothing do not constitute a valid collection");
            }
        }, JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, null);
        NOTHING_TYPE = new JetTypeImpl(JetStandardClasses.getNothing());
        NULLABLE_NOTHING_TYPE = new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), JetStandardClasses.getNothing().getTypeConstructor(), true, Collections.<TypeProjection>emptyList(), JetScope.EMPTY);
        ANY = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), "Any").initialize(false, Collections.<TypeParameterDescriptor>emptyList(), Collections.<JetType>emptySet(), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, null);
        ANY_TYPE = new JetTypeImpl(ANY.getTypeConstructor(), new JetScopeImpl(){

            @Override
            @NotNull
            public DeclarationDescriptor getContainingDeclaration() {
                return STANDARD_CLASSES_NAMESPACE;
            }

            public String toString() {
                return "Scope for Any";
            }
        });
        NULLABLE_ANY_TYPE = TypeUtils.makeNullable(ANY_TYPE);
        DEFAULT_BOUND = JetStandardClasses.getNullableAnyType();
        STUB = JetScope.EMPTY;
        TUPLE_CONSTRUCTORS = Sets.newHashSet();
        TUPLE = new ClassDescriptor[22];
        for (i = 0; i < 22; ++i) {
            ArrayList<TypeParameterDescriptor> parameters = new ArrayList<TypeParameterDescriptor>();
            ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), "Tuple" + i);
            WritableScopeImpl writableScope = new WritableScopeImpl(JetScope.EMPTY, classDescriptor, RedeclarationHandler.THROW_EXCEPTION);
            for (int j = 0; j < i; ++j) {
                TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptor.createWithDefaultBound(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), true, Variance.OUT_VARIANCE, "T" + (j + 1), j);
                parameters.add(typeParameterDescriptor);
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibility.PUBLIC, false, false, "_" + (j + 1), CallableMemberDescriptor.Kind.DECLARATION);
                propertyDescriptor.setType(typeParameterDescriptor.getDefaultType(), Collections.<TypeParameterDescriptor>emptyList(), classDescriptor.getImplicitReceiver(), ReceiverDescriptor.NO_RECEIVER);
                PropertyGetterDescriptor getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibility.PUBLIC, false, true, CallableMemberDescriptor.Kind.DECLARATION);
                getterDescriptor.initialize(typeParameterDescriptor.getDefaultType());
                propertyDescriptor.initialize(getterDescriptor, null);
                writableScope.addPropertyDescriptor(propertyDescriptor);
            }
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            JetStandardClasses.TUPLE[i] = classDescriptor.initialize(true, parameters, Collections.singleton(JetStandardClasses.getAnyType()), writableScope, Collections.<ConstructorDescriptor>emptySet(), null);
            TUPLE_CONSTRUCTORS.add(TUPLE[i].getTypeConstructor());
        }
        FUNCTION = new ClassDescriptor[22];
        RECEIVER_FUNCTION = new ClassDescriptor[22];
        FUNCTION_TYPE_CONSTRUCTORS = Sets.newHashSet();
        RECEIVER_FUNCTION_TYPE_CONSTRUCTORS = Sets.newHashSet();
        for (i = 0; i < 22; ++i) {
            ClassDescriptorImpl function = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), "Function" + i);
            JetStandardClasses.FUNCTION[i] = function.initialize(false, JetStandardClasses.createTypeParameters(i, function), Collections.singleton(JetStandardClasses.getAnyType()), STUB, Collections.<ConstructorDescriptor>emptySet(), null);
            FUNCTION_TYPE_CONSTRUCTORS.add(FUNCTION[i].getTypeConstructor());
            ClassDescriptorImpl receiverFunction = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), "ExtensionFunction" + i);
            List<TypeParameterDescriptor> parameters = JetStandardClasses.createTypeParameters(i, receiverFunction);
            parameters.add(0, TypeParameterDescriptor.createWithDefaultBound(receiverFunction, Collections.<AnnotationDescriptor>emptyList(), true, Variance.IN_VARIANCE, "T", 0));
            JetStandardClasses.RECEIVER_FUNCTION[i] = receiverFunction.initialize(false, parameters, Collections.singleton(JetStandardClasses.getAnyType()), STUB, Collections.<ConstructorDescriptor>emptySet(), null);
            RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.add(RECEIVER_FUNCTION[i].getTypeConstructor());
        }
        UNIT_TYPE = new JetTypeImpl(JetStandardClasses.getTuple(0));
        WritableScopeImpl writableScope = new WritableScopeImpl(JetScope.EMPTY, STANDARD_CLASSES_NAMESPACE, RedeclarationHandler.DO_NOTHING).setDebugName("JetStandardClasses.STANDARD_CLASSES");
        writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        STANDARD_CLASSES = writableScope;
        writableScope.addClassifierAlias("Unit", JetStandardClasses.getTuple(0));
        for (Field field : declaredFields = JetStandardClasses.class.getDeclaredFields()) {
            if ((field.getModifiers() & 8) == 0) continue;
            Class<?> type = field.getType();
            if (type == ClassDescriptor.class) {
                try {
                    ClassDescriptor descriptor = (ClassDescriptor)field.get(null);
                    writableScope.addClassifierDescriptor(descriptor);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (!type.isArray() || type.getComponentType() != ClassDescriptor.class) continue;
            try {
                ClassDescriptor[] array;
                for (ClassDescriptor descriptor : array = (ClassDescriptor[])field.get(null)) {
                    writableScope.addClassifierDescriptor(descriptor);
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        STANDARD_CLASSES_NAMESPACE.initialize(writableScope);
    }
}

