/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.util.Box;
import org.jetbrains.jet.util.lazy.LazyValue;
import org.jetbrains.jet.util.lazy.ReenteringLazyValueComputationException;

public class DeferredType
implements JetType {
    private final LazyValue<JetType> lazyValue;

    public static DeferredType create(BindingTrace trace, LazyValue<JetType> lazyValue) {
        DeferredType deferredType = new DeferredType(lazyValue);
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        return deferredType;
    }

    private DeferredType(LazyValue<JetType> lazyValue) {
        this.lazyValue = lazyValue;
    }

    public boolean isComputed() {
        return this.lazyValue.isComputed();
    }

    public JetType getActualType() {
        return this.lazyValue.get();
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        return this.getActualType().getMemberScope();
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        return this.getActualType().getConstructor();
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        return this.getActualType().getArguments();
    }

    @Override
    public boolean isNullable() {
        return this.getActualType().isNullable();
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.getActualType().getAnnotations();
    }

    public String toString() {
        try {
            if (this.lazyValue.isComputed()) {
                return this.getActualType().toString();
            }
            return "<Not computed yet>";
        }
        catch (ReenteringLazyValueComputationException e) {
            return "<Failed to compute this type>";
        }
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.getActualType()).equals(obj);
    }

    public int hashCode() {
        return this.getActualType().hashCode();
    }
}

