/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeWithImports;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class WriteThroughScope
extends WritableScopeWithImports {
    private final WritableScope writableWorker;
    private Collection<DeclarationDescriptor> allDescriptors;

    public WriteThroughScope(@NotNull JetScope outerScope, @NotNull WritableScope scope, @NotNull RedeclarationHandler redeclarationHandler) {
        super(outerScope, redeclarationHandler);
        this.writableWorker = scope;
    }

    @Override
    @Nullable
    public PropertyDescriptor getPropertyByFieldReference(@NotNull String fieldName) {
        this.checkMayRead();
        return this.writableWorker.getPropertyByFieldReference(fieldName);
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(String labelName) {
        this.checkMayRead();
        return this.writableWorker.getDeclarationsByLabel(labelName);
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        this.checkMayRead();
        return this.writableWorker.getContainingDeclaration();
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        this.checkMayRead();
        return this.writableWorker.getImplicitReceiver();
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull String name) {
        this.checkMayRead();
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.writableWorker.getFunctions(name));
        result.addAll(this.getWorkerScope().getFunctions(name));
        result.addAll(super.getFunctions(name));
        return result;
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull String name) {
        this.checkMayRead();
        LinkedHashSet properties = Sets.newLinkedHashSet();
        properties.addAll(this.writableWorker.getProperties(name));
        properties.addAll(this.getWorkerScope().getProperties(name));
        properties.addAll(super.getProperties(name));
        return properties;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@NotNull String name) {
        this.checkMayRead();
        VariableDescriptor variable = this.writableWorker.getLocalVariable(name);
        if (variable != null) {
            return variable;
        }
        variable = this.getWorkerScope().getLocalVariable(name);
        if (variable != null) {
            return variable;
        }
        return super.getLocalVariable(name);
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull String name) {
        this.checkMayRead();
        NamespaceDescriptor namespace = this.writableWorker.getNamespace(name);
        if (namespace != null) {
            return namespace;
        }
        namespace = this.getWorkerScope().getNamespace(name);
        if (namespace != null) {
            return namespace;
        }
        return super.getNamespace(name);
    }

    @Override
    @Nullable
    public ClassifierDescriptor getClassifier(@NotNull String name) {
        this.checkMayRead();
        ClassifierDescriptor classifier = this.writableWorker.getClassifier(name);
        if (classifier != null) {
            return classifier;
        }
        classifier = this.getWorkerScope().getClassifier(name);
        if (classifier != null) {
            return classifier;
        }
        return super.getClassifier(name);
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull String name) {
        this.checkMayRead();
        ClassDescriptor objectDescriptor = this.writableWorker.getObjectDescriptor(name);
        if (objectDescriptor != null) {
            return objectDescriptor;
        }
        objectDescriptor = this.getWorkerScope().getObjectDescriptor(name);
        if (objectDescriptor != null) {
            return objectDescriptor;
        }
        return super.getObjectDescriptor(name);
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        this.checkMayRead();
        HashSet objectDescriptors = Sets.newHashSet();
        objectDescriptors.addAll(super.getObjectDescriptors());
        objectDescriptors.addAll(this.getWorkerScope().getObjectDescriptors());
        objectDescriptors.addAll(this.writableWorker.getObjectDescriptors());
        return objectDescriptors;
    }

    @Override
    public void addLabeledDeclaration(@NotNull DeclarationDescriptor descriptor) {
        this.checkMayWrite();
        this.writableWorker.addLabeledDeclaration(descriptor);
    }

    @Override
    public void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addVariableDescriptor(variableDescriptor);
    }

    @Override
    public void addPropertyDescriptor(@NotNull VariableDescriptor propertyDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addPropertyDescriptor(propertyDescriptor);
    }

    @Override
    public void addFunctionDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addFunctionDescriptor(functionDescriptor);
    }

    @Override
    public void addTypeParameterDescriptor(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addTypeParameterDescriptor(typeParameterDescriptor);
    }

    @Override
    public void addClassifierDescriptor(@NotNull ClassifierDescriptor classDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addClassifierDescriptor(classDescriptor);
    }

    @Override
    public void addObjectDescriptor(@NotNull ClassDescriptor objectDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addObjectDescriptor(objectDescriptor);
    }

    @Override
    public void addClassifierAlias(@NotNull String name, @NotNull ClassifierDescriptor classifierDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addClassifierAlias(name, classifierDescriptor);
    }

    @Override
    public void addNamespaceAlias(@NotNull String name, @NotNull NamespaceDescriptor namespaceDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addNamespaceAlias(name, namespaceDescriptor);
    }

    @Override
    public void addVariableAlias(@NotNull String name, @NotNull VariableDescriptor variableDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addVariableAlias(name, variableDescriptor);
    }

    @Override
    public void addFunctionAlias(@NotNull String name, @NotNull FunctionDescriptor functionDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addFunctionAlias(name, functionDescriptor);
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        this.checkMayWrite();
        this.writableWorker.addNamespace(namespaceDescriptor);
    }

    @Override
    @Nullable
    public NamespaceDescriptor getDeclaredNamespace(@NotNull String name) {
        this.checkMayRead();
        return this.writableWorker.getDeclaredNamespace(name);
    }

    @Override
    public void importScope(@NotNull JetScope imported) {
        this.checkMayWrite();
        super.importScope(imported);
    }

    @Override
    public void setImplicitReceiver(@NotNull ReceiverDescriptor implicitReceiver) {
        this.checkMayWrite();
        this.writableWorker.setImplicitReceiver(implicitReceiver);
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        this.checkMayRead();
        if (this.allDescriptors == null) {
            this.allDescriptors = Lists.newArrayList();
            this.allDescriptors.addAll(this.writableWorker.getAllDescriptors());
            this.allDescriptors.addAll(this.getWorkerScope().getAllDescriptors());
            for (JetScope imported : this.getImports()) {
                this.allDescriptors.addAll(imported.getAllDescriptors());
            }
        }
        return this.allDescriptors;
    }

    @NotNull
    public JetScope getOuterScope() {
        this.checkMayRead();
        return this.getWorkerScope();
    }
}

