/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeWithImports;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.util.CommonSuppliers;

public class WritableScopeImpl
extends WritableScopeWithImports {
    private final Collection<DeclarationDescriptor> allDescriptors = Sets.newLinkedHashSet();
    private boolean allDescriptorsDone = false;
    @NotNull
    private final DeclarationDescriptor ownerDeclarationDescriptor;
    @Nullable
    private Map<String, PropertyDescriptor> propertyDescriptorsByFieldNames;
    @Nullable
    private SetMultimap<String, FunctionDescriptor> functionGroups;
    @Nullable
    private Map<String, DeclarationDescriptor> variableClassOrNamespaceDescriptors;
    @Nullable
    private SetMultimap<String, VariableDescriptor> propertyGroups;
    @Nullable
    private Map<String, NamespaceDescriptor> namespaceAliases;
    @Nullable
    private Map<String, List<DeclarationDescriptor>> labelsToDescriptors;
    @Nullable
    private Map<String, ClassDescriptor> objectDescriptors;
    @Nullable
    private ReceiverDescriptor implicitReceiver;

    public WritableScopeImpl(@NotNull JetScope scope, @NotNull DeclarationDescriptor owner, @NotNull RedeclarationHandler redeclarationHandler) {
        super(scope, redeclarationHandler);
        this.ownerDeclarationDescriptor = owner;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.ownerDeclarationDescriptor;
    }

    @Override
    public void importScope(@NotNull JetScope imported) {
        this.checkMayWrite();
        super.importScope(imported);
    }

    @Override
    public void importClassifierAlias(@NotNull String importedClassifierName, @NotNull ClassifierDescriptor classifierDescriptor) {
        this.checkMayWrite();
        this.allDescriptors.add(classifierDescriptor);
        super.importClassifierAlias(importedClassifierName, classifierDescriptor);
    }

    @Override
    public void importNamespaceAlias(@NotNull String aliasName, @NotNull NamespaceDescriptor namespaceDescriptor) {
        this.checkMayWrite();
        this.allDescriptors.add(namespaceDescriptor);
        super.importNamespaceAlias(aliasName, namespaceDescriptor);
    }

    @Override
    public void importFunctionAlias(@NotNull String aliasName, @NotNull FunctionDescriptor functionDescriptor) {
        this.checkMayWrite();
        this.addFunctionDescriptor(functionDescriptor);
        super.importFunctionAlias(aliasName, functionDescriptor);
    }

    @Override
    public void importVariableAlias(@NotNull String aliasName, @NotNull VariableDescriptor variableDescriptor) {
        this.checkMayWrite();
        this.addPropertyDescriptor(variableDescriptor);
        super.importVariableAlias(aliasName, variableDescriptor);
    }

    @Override
    public void clearImports() {
        this.checkMayWrite();
        super.clearImports();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        this.checkMayRead();
        if (!this.allDescriptorsDone) {
            this.allDescriptorsDone = true;
            this.allDescriptors.addAll(this.getWorkerScope().getAllDescriptors());
            for (JetScope imported : this.getImports()) {
                this.allDescriptors.addAll(imported.getAllDescriptors());
            }
        }
        return this.allDescriptors;
    }

    @NotNull
    private Map<String, List<DeclarationDescriptor>> getLabelsToDescriptors() {
        if (this.labelsToDescriptors == null) {
            this.labelsToDescriptors = new HashMap<String, List<DeclarationDescriptor>>();
        }
        return this.labelsToDescriptors;
    }

    @NotNull
    private Map<String, ClassDescriptor> getObjectDescriptorsMap() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = Maps.newHashMap();
        }
        return this.objectDescriptors;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull String labelName) {
        this.checkMayRead();
        Collection<DeclarationDescriptor> superResult = super.getDeclarationsByLabel(labelName);
        Map<String, List<DeclarationDescriptor>> labelsToDescriptors = this.getLabelsToDescriptors();
        List<DeclarationDescriptor> declarationDescriptors = labelsToDescriptors.get(labelName);
        if (declarationDescriptors == null) {
            return superResult;
        }
        if (superResult.isEmpty()) {
            return declarationDescriptors;
        }
        ArrayList<DeclarationDescriptor> result = new ArrayList<DeclarationDescriptor>(declarationDescriptors);
        result.addAll(superResult);
        return result;
    }

    @Override
    public void addLabeledDeclaration(@NotNull DeclarationDescriptor descriptor) {
        this.checkMayWrite();
        Map<String, List<DeclarationDescriptor>> labelsToDescriptors = this.getLabelsToDescriptors();
        String name = descriptor.getName();
        assert (name != null);
        List<DeclarationDescriptor> declarationDescriptors = labelsToDescriptors.get(name);
        if (declarationDescriptors == null) {
            declarationDescriptors = new ArrayList<DeclarationDescriptor>();
            labelsToDescriptors.put(name, declarationDescriptors);
        }
        declarationDescriptors.add(descriptor);
    }

    @NotNull
    private Map<String, DeclarationDescriptor> getVariableClassOrNamespaceDescriptors() {
        if (this.variableClassOrNamespaceDescriptors == null) {
            this.variableClassOrNamespaceDescriptors = Maps.newHashMap();
        }
        return this.variableClassOrNamespaceDescriptors;
    }

    @NotNull
    private Map<String, NamespaceDescriptor> getNamespaceAliases() {
        if (this.namespaceAliases == null) {
            this.namespaceAliases = Maps.newHashMap();
        }
        return this.namespaceAliases;
    }

    @Override
    public void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor) {
        this.addVariableDescriptor(variableDescriptor, false);
    }

    @Override
    public void addPropertyDescriptor(@NotNull VariableDescriptor propertyDescriptor) {
        this.addVariableDescriptor(propertyDescriptor, true);
    }

    private void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor, boolean isProperty) {
        this.checkMayWrite();
        String name = variableDescriptor.getName();
        if (isProperty) {
            this.checkForPropertyRedeclaration(name, variableDescriptor);
            this.getPropertyGroups().put((Object)name, (Object)variableDescriptor);
        }
        if (!variableDescriptor.getReceiverParameter().exists()) {
            this.checkForRedeclaration(name, variableDescriptor);
            this.getVariableClassOrNamespaceDescriptors().put(name, variableDescriptor);
        }
        this.allDescriptors.add(variableDescriptor);
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull String name) {
        this.checkMayRead();
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)this.getPropertyGroups().get((Object)name));
        result.addAll(this.getWorkerScope().getProperties(name));
        result.addAll(super.getProperties(name));
        return result;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull String name) {
        this.checkMayRead();
        Map<String, DeclarationDescriptor> variableClassOrNamespaceDescriptors = this.getVariableClassOrNamespaceDescriptors();
        DeclarationDescriptor descriptor = variableClassOrNamespaceDescriptors.get(name);
        if (descriptor instanceof VariableDescriptor && !this.getPropertyGroups().get((Object)name).contains(descriptor)) {
            return (VariableDescriptor)descriptor;
        }
        VariableDescriptor variableDescriptor = this.getWorkerScope().getLocalVariable(name);
        if (variableDescriptor != null) {
            return variableDescriptor;
        }
        return super.getLocalVariable(name);
    }

    @NotNull
    private SetMultimap<String, VariableDescriptor> getPropertyGroups() {
        if (this.propertyGroups == null) {
            this.propertyGroups = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        }
        return this.propertyGroups;
    }

    @NotNull
    private SetMultimap<String, FunctionDescriptor> getFunctionGroups() {
        if (this.functionGroups == null) {
            this.functionGroups = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        }
        return this.functionGroups;
    }

    @Override
    public void addFunctionDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        this.checkMayWrite();
        this.getFunctionGroups().put((Object)functionDescriptor.getName(), (Object)functionDescriptor);
        this.allDescriptors.add(functionDescriptor);
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull String name) {
        this.checkMayRead();
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)this.getFunctionGroups().get((Object)name));
        result.addAll(this.getWorkerScope().getFunctions(name));
        result.addAll(super.getFunctions(name));
        return result;
    }

    @Override
    public void addTypeParameterDescriptor(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        this.checkMayWrite();
        String name = typeParameterDescriptor.getName();
        this.addClassifierAlias(name, typeParameterDescriptor);
    }

    @Override
    public void addClassifierDescriptor(@NotNull ClassifierDescriptor classDescriptor) {
        this.checkMayWrite();
        this.addClassifierAlias(classDescriptor.getName(), classDescriptor);
    }

    @Override
    public void addObjectDescriptor(@NotNull ClassDescriptor objectDescriptor) {
        this.checkMayWrite();
        this.getObjectDescriptorsMap().put(objectDescriptor.getName(), objectDescriptor);
    }

    @Override
    public void addClassifierAlias(@NotNull String name, @NotNull ClassifierDescriptor classifierDescriptor) {
        this.checkMayWrite();
        this.checkForRedeclaration(name, classifierDescriptor);
        this.getVariableClassOrNamespaceDescriptors().put(name, classifierDescriptor);
        this.allDescriptors.add(classifierDescriptor);
    }

    @Override
    public void addNamespaceAlias(@NotNull String name, @NotNull NamespaceDescriptor namespaceDescriptor) {
        this.checkMayWrite();
        this.checkForRedeclaration(name, namespaceDescriptor);
        this.getNamespaceAliases().put(name, namespaceDescriptor);
        this.allDescriptors.add(namespaceDescriptor);
    }

    @Override
    public void addFunctionAlias(@NotNull String name, @NotNull FunctionDescriptor functionDescriptor) {
        this.checkMayWrite();
        this.checkForRedeclaration(name, functionDescriptor);
        this.getFunctionGroups().put((Object)name, (Object)functionDescriptor);
        this.allDescriptors.add(functionDescriptor);
    }

    @Override
    public void addVariableAlias(@NotNull String name, @NotNull VariableDescriptor variableDescriptor) {
        this.checkMayWrite();
        this.checkForRedeclaration(name, variableDescriptor);
        this.getVariableClassOrNamespaceDescriptors().put(name, variableDescriptor);
        this.allDescriptors.add(variableDescriptor);
    }

    private void checkForPropertyRedeclaration(String name, VariableDescriptor variableDescriptor) {
        Set properties = this.getPropertyGroups().get((Object)name);
        ReceiverDescriptor receiverParameter = variableDescriptor.getReceiverParameter();
        for (VariableDescriptor oldProperty : properties) {
            ReceiverDescriptor receiverParameterForOldVariable = oldProperty.getReceiverParameter();
            if (!receiverParameter.exists() || !receiverParameterForOldVariable.exists() || !JetTypeChecker.INSTANCE.equalTypes(receiverParameter.getType(), receiverParameterForOldVariable.getType())) continue;
            this.redeclarationHandler.handleRedeclaration(oldProperty, variableDescriptor);
        }
    }

    private void checkForRedeclaration(String name, DeclarationDescriptor classifierDescriptor) {
        DeclarationDescriptor originalDescriptor = this.getVariableClassOrNamespaceDescriptors().get(name);
        if (originalDescriptor != null) {
            this.redeclarationHandler.handleRedeclaration(originalDescriptor, classifierDescriptor);
        }
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull String name) {
        this.checkMayRead();
        Map<String, DeclarationDescriptor> variableClassOrNamespaceDescriptors = this.getVariableClassOrNamespaceDescriptors();
        DeclarationDescriptor descriptor = variableClassOrNamespaceDescriptors.get(name);
        if (descriptor instanceof ClassifierDescriptor) {
            return (ClassifierDescriptor)descriptor;
        }
        ClassifierDescriptor classifierDescriptor = this.getWorkerScope().getClassifier(name);
        if (classifierDescriptor != null) {
            return classifierDescriptor;
        }
        return super.getClassifier(name);
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull String name) {
        return this.getObjectDescriptorsMap().get(name);
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        return Sets.newHashSet(this.getObjectDescriptorsMap().values());
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        this.checkMayWrite();
        Map<String, DeclarationDescriptor> variableClassOrNamespaceDescriptors = this.getVariableClassOrNamespaceDescriptors();
        DeclarationDescriptor oldValue = variableClassOrNamespaceDescriptors.put(namespaceDescriptor.getName(), namespaceDescriptor);
        if (oldValue != null) {
            this.redeclarationHandler.handleRedeclaration(oldValue, namespaceDescriptor);
        }
        this.allDescriptors.add(namespaceDescriptor);
    }

    @Override
    public NamespaceDescriptor getDeclaredNamespace(@NotNull String name) {
        this.checkMayRead();
        Map<String, DeclarationDescriptor> variableClassOrNamespaceDescriptors = this.getVariableClassOrNamespaceDescriptors();
        DeclarationDescriptor namespaceDescriptor = variableClassOrNamespaceDescriptors.get(name);
        if (namespaceDescriptor instanceof NamespaceDescriptor) {
            return (NamespaceDescriptor)namespaceDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull String name) {
        this.checkMayRead();
        NamespaceDescriptor declaredNamespace = this.getDeclaredNamespace(name);
        if (declaredNamespace != null) {
            return declaredNamespace;
        }
        NamespaceDescriptor aliased = this.getNamespaceAliases().get(name);
        if (aliased != null) {
            return aliased;
        }
        NamespaceDescriptor namespace = this.getWorkerScope().getNamespace(name);
        if (namespace != null) {
            return namespace;
        }
        return super.getNamespace(name);
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        this.checkMayRead();
        if (this.implicitReceiver == null) {
            return super.getImplicitReceiver();
        }
        return this.implicitReceiver;
    }

    @Override
    public void setImplicitReceiver(@NotNull ReceiverDescriptor implicitReceiver) {
        this.checkMayWrite();
        if (this.implicitReceiver != null) {
            throw new UnsupportedOperationException("Receiver redeclared");
        }
        this.implicitReceiver = implicitReceiver;
    }

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
        this.checkMayRead();
        if (this.implicitReceiver != null && this.implicitReceiver.exists()) {
            result.add(this.implicitReceiver);
        }
        super.getImplicitReceiversHierarchy(result);
    }

    @NotNull
    private Map<String, PropertyDescriptor> getPropertyDescriptorsByFieldNames() {
        if (this.propertyDescriptorsByFieldNames == null) {
            this.propertyDescriptorsByFieldNames = new HashMap<String, PropertyDescriptor>();
        }
        return this.propertyDescriptorsByFieldNames;
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull String fieldName) {
        this.checkMayRead();
        if (!fieldName.startsWith("$")) {
            throw new IllegalStateException();
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptorsByFieldNames().get(fieldName);
        if (descriptor != null) {
            return descriptor;
        }
        return super.getPropertyByFieldReference(fieldName);
    }

    public List<VariableDescriptor> getDeclaredVariables() {
        this.checkMayRead();
        ArrayList result = Lists.newArrayList();
        for (DeclarationDescriptor descriptor : this.getVariableClassOrNamespaceDescriptors().values()) {
            if (!(descriptor instanceof VariableDescriptor)) continue;
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
            result.add(variableDescriptor);
        }
        return result;
    }

    public boolean hasDeclaredItems() {
        return this.variableClassOrNamespaceDescriptors != null && !this.variableClassOrNamespaceDescriptors.isEmpty();
    }

    @Override
    public WritableScopeImpl setDebugName(@NotNull String debugName) {
        this.checkMayWrite();
        super.setDebugName(debugName);
        return this;
    }
}

