/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class SubstitutingScope
implements JetScope {
    private final JetScope workerScope;
    private final TypeSubstitutor substitutor;
    private Map<DeclarationDescriptor, DeclarationDescriptor> substitutedDescriptors = null;
    private Collection<DeclarationDescriptor> allDescriptors = null;

    public SubstitutingScope(JetScope workerScope, @NotNull TypeSubstitutor substitutor) {
        this.workerScope = workerScope;
        this.substitutor = substitutor;
    }

    @Nullable
    private <D extends DeclarationDescriptor> D substitute(@Nullable D descriptor) {
        DeclarationDescriptor substituted;
        if (descriptor == null) {
            return null;
        }
        if (this.substitutor.isEmpty()) {
            return descriptor;
        }
        if (this.substitutedDescriptors == null) {
            this.substitutedDescriptors = Maps.newHashMap();
        }
        if ((substituted = this.substitutedDescriptors.get(descriptor)) == null) {
            substituted = descriptor.substitute(this.substitutor);
            this.substitutedDescriptors.put(descriptor, substituted);
        }
        return (D)substituted;
    }

    @NotNull
    private <D extends DeclarationDescriptor> Set<D> substitute(@NotNull Set<D> descriptors) {
        if (this.substitutor.isEmpty()) {
            return descriptors;
        }
        if (descriptors.isEmpty()) {
            return descriptors;
        }
        HashSet result = Sets.newHashSet();
        for (DeclarationDescriptor descriptor : descriptors) {
            DeclarationDescriptor substitute = this.substitute(descriptor);
            if (substitute == null) continue;
            result.add(substitute);
        }
        return result;
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull String name) {
        return this.substitute(this.workerScope.getProperties(name));
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull String name) {
        return this.substitute(this.workerScope.getLocalVariable(name));
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull String name) {
        return this.substitute(this.workerScope.getClassifier(name));
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull String name) {
        return this.substitute(this.workerScope.getObjectDescriptor(name));
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        return this.substitute(this.workerScope.getObjectDescriptors());
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull String name) {
        return this.substitute(this.workerScope.getFunctions(name));
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull String name) {
        return this.workerScope.getNamespace(name);
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.workerScope.getContainingDeclaration();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(String labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull String fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = Sets.newHashSet();
            for (DeclarationDescriptor descriptor : this.workerScope.getAllDescriptors()) {
                DeclarationDescriptor substitute = this.substitute(descriptor);
                if (substitute == null) continue;
                this.allDescriptors.add(substitute);
            }
        }
        return this.allDescriptors;
    }
}

