/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public final class JetScopeUtils {
    private JetScopeUtils() {
    }

    @NotNull
    public static Collection<ReceiverDescriptor> getImplicitReceiversHierarchy(@NotNull JetScope scope) {
        ArrayList descriptors = Lists.newArrayList();
        scope.getImplicitReceiversHierarchy(descriptors);
        return descriptors;
    }

    public static Collection<CallableDescriptor> getAllExtensions(@NotNull JetScope scope) {
        HashSet result = Sets.newHashSet();
        for (DeclarationDescriptor descriptor : scope.getAllDescriptors()) {
            CallableDescriptor callDescriptor;
            if (!(descriptor instanceof CallableDescriptor) || !(callDescriptor = (CallableDescriptor)descriptor).getReceiverParameter().exists()) continue;
            result.add(callDescriptor);
        }
        return result;
    }
}

