/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class ChainedScope
implements JetScope {
    private final DeclarationDescriptor containingDeclaration;
    private final JetScope[] scopeChain;
    private Collection<DeclarationDescriptor> allDescriptors;

    public ChainedScope(DeclarationDescriptor containingDeclaration, JetScope ... scopes) {
        this.containingDeclaration = containingDeclaration;
        this.scopeChain = (JetScope[])scopes.clone();
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull String name) {
        for (JetScope scope : this.scopeChain) {
            ClassifierDescriptor classifier = scope.getClassifier(name);
            if (classifier == null) continue;
            return classifier;
        }
        return null;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull String name) {
        for (JetScope scope : this.scopeChain) {
            ClassDescriptor objectDescriptor = scope.getObjectDescriptor(name);
            if (objectDescriptor == null) continue;
            return objectDescriptor;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        HashSet objectDescriptors = Sets.newHashSet();
        for (JetScope scope : this.scopeChain) {
            objectDescriptors.addAll(scope.getObjectDescriptors());
        }
        return objectDescriptors;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull String name) {
        for (JetScope jetScope : this.scopeChain) {
            NamespaceDescriptor namespace = jetScope.getNamespace(name);
            if (namespace == null) continue;
            return namespace;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull String name) {
        LinkedHashSet properties = Sets.newLinkedHashSet();
        for (JetScope jetScope : this.scopeChain) {
            properties.addAll(jetScope.getProperties(name));
        }
        return properties;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull String name) {
        for (JetScope jetScope : this.scopeChain) {
            VariableDescriptor variable = jetScope.getLocalVariable(name);
            if (variable == null) continue;
            return variable;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull String name) {
        if (this.scopeChain.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (JetScope jetScope : this.scopeChain) {
            result.addAll(jetScope.getFunctions(name));
        }
        return result;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
        for (JetScope jetScope : this.scopeChain) {
            jetScope.getImplicitReceiversHierarchy(result);
        }
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(String labelName) {
        for (JetScope jetScope : this.scopeChain) {
            Collection<DeclarationDescriptor> declarationsByLabel = jetScope.getDeclarationsByLabel(labelName);
            if (declarationsByLabel.isEmpty()) continue;
            return declarationsByLabel;
        }
        return Collections.emptyList();
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull String fieldName) {
        for (JetScope jetScope : this.scopeChain) {
            PropertyDescriptor propertyByFieldReference = jetScope.getPropertyByFieldReference(fieldName);
            if (propertyByFieldReference == null) continue;
            return propertyByFieldReference;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = Sets.newHashSet();
            for (JetScope scope : this.scopeChain) {
                this.allDescriptors.addAll(scope.getAllDescriptors());
            }
        }
        return this.allDescriptors;
    }
}

