/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWrapper;

public class JetValueParameterAnnotation
extends PsiAnnotationWrapper {
    private String name;
    private String type;
    private boolean nullable;
    private boolean nullableInitialized = false;
    private boolean receiver;
    private boolean receiverInitialized = false;
    private boolean hasDefaultValue;
    private boolean hasDefaultValueInitialized = false;

    public JetValueParameterAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @NotNull
    public String name() {
        if (this.name == null) {
            this.name = this.getStringAttribute("name", "");
        }
        return this.name;
    }

    @NotNull
    public String type() {
        if (this.type == null) {
            this.type = this.getStringAttribute("type", "");
        }
        return this.type;
    }

    public boolean nullable() {
        if (!this.nullableInitialized) {
            this.nullable = this.getBooleanAttribute("nullable", false);
            this.nullableInitialized = true;
        }
        return this.nullable;
    }

    public boolean receiver() {
        if (!this.receiverInitialized) {
            this.receiver = this.getBooleanAttribute("receiver", false);
            this.receiverInitialized = true;
        }
        return this.receiver;
    }

    public boolean hasDefaultValue() {
        if (!this.hasDefaultValueInitialized) {
            this.hasDefaultValue = this.getBooleanAttribute("hasDefaultValue", false);
            this.hasDefaultValueInitialized = true;
        }
        return this.hasDefaultValue;
    }

    public static JetValueParameterAnnotation get(PsiParameter psiParameter) {
        return new JetValueParameterAnnotation(psiParameter.getModifierList().findAnnotation(JvmStdlibNames.JET_VALUE_PARAMETER.getFqName()));
    }
}

