/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWrapper;

public class JetMethodAnnotation
extends PsiAnnotationWrapper {
    private int kind;
    private boolean kindInitialized;
    private String typeParameters;
    private String returnType;
    private boolean returnTypeNullable;
    private boolean returnTypeNullableInitialized;
    private String propertyType;

    public JetMethodAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    public int kind() {
        if (!this.kindInitialized) {
            this.kind = this.getIntAttribute("kind", 0);
            this.kindInitialized = true;
        }
        return this.kind;
    }

    @NotNull
    public String typeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = this.getStringAttribute("typeParameters", "");
        }
        return this.typeParameters;
    }

    @NotNull
    public String returnType() {
        if (this.returnType == null) {
            this.returnType = this.getStringAttribute("returnType", "");
        }
        return this.returnType;
    }

    @NotNull
    public boolean returnTypeNullable() {
        if (!this.returnTypeNullableInitialized) {
            this.returnTypeNullable = this.getBooleanAttribute("nullableReturnType", false);
            this.returnTypeNullableInitialized = true;
        }
        return this.returnTypeNullable;
    }

    @NotNull
    public String propertyType() {
        if (this.propertyType == null) {
            this.propertyType = this.getStringAttribute("propertyType", "");
        }
        return this.propertyType;
    }

    public static JetMethodAnnotation get(PsiMethod psiMethod) {
        return new JetMethodAnnotation(psiMethod.getModifierList().findAnnotation(JvmStdlibNames.JET_METHOD.getFqName()));
    }
}

