/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;

public class TypeVariableResolverFromTypeDescriptors
implements TypeVariableResolver {
    @NotNull
    private final List<TypeParameterDescriptor> typeParameters;
    @Nullable
    private final TypeVariableResolver parent;

    public TypeVariableResolverFromTypeDescriptors(@NotNull List<TypeParameterDescriptor> typeParameters, @Nullable TypeVariableResolver parent) {
        this.typeParameters = typeParameters;
        this.parent = parent;
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable(@NotNull String name) {
        for (TypeParameterDescriptor typeParameter : this.typeParameters) {
            if (!typeParameter.getName().equals(name)) continue;
            return typeParameter;
        }
        if (this.parent != null) {
            return this.parent.getTypeVariable(name);
        }
        throw new RuntimeException("type parameter not found by name " + name);
    }
}

